<?php
/*******************************************************************************
 *
 * LEIDEN OPEN VARIATION DATABASE (LOVD)
 *
 * Created     : 2006-05-08
 * Modified    : 2007-06-18
 * For LOVD    : 2.0-beta-05
 *
 * Access      : Public
 * Purpose     : Allows managers to create new genes and edit previously added
 *               genes. Also curators can, to a certain extent, edit genes.
 *
 * Copyright   : 2004-2007 Leiden University Medical Center; http://www.LUMC.nl/
 * Programmer  : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *
 * This file is part of LOVD.
 *
 * LOVD is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * LOVD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LOVD; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *************/

define('ROOT_PATH', './');
require ROOT_PATH . 'inc-init.php';

if (HAS_AUTH) {
    // If authorized, check for updates.
    require ROOT_PATH . 'inc-upgrade.php';
}

// Require manager clearance.
lovd_requireAUTH(LEVEL_CURATOR);





if (($_GET['action'] == 'edit' && !empty($_GET['edit'])) || $_GET['action'] == 'manage') {
    // Edit gene (managers and, to some extent, curators).

    // Should we forward to the setup?
    if ($_AUTH['level'] >= LEVEL_MANAGER && $_GET['action'] == 'edit' && !empty($_GET['edit'])) {
        // Manager specifically gave gene to edit.
        $bSetup = true;
    } else {
        $_GET['action'] = 'manage';
        $_GET['edit'] = $_SESSION['currdb'];
        $bSetup = false;
    }

    $zData = @mysql_fetch_assoc(mysql_query('SELECT * FROM ' . TABLE_DBS . ' WHERE symbol = "' . $_GET['edit'] . '"'));
    if (!$zData) {
        // Wrong ID, apparently.
        require ROOT_PATH . 'inc-top.php';
        if ($bSetup) {
            lovd_printHeader('setup_genes_manage', 'LOVD Setup - Manage configured genes');
        } else {
            lovd_printHeader('config_gene_manage', 'LOVD Configuration - Manage gene');
        }
        lovd_showInfoTable('No such ID!', 'stop');
        require ROOT_PATH . 'inc-bot.php';
        exit;
    }

    // Curator? Only the ones curating this gene.
    if (!lovd_isCurator($_GET['edit'])) {
        // This is a hack-attempt.
        require ROOT_PATH . 'inc-top.php';
        lovd_printHeader('config_gene_manage', 'LOVD Configuration - Manage gene');
        lovd_writeLog('MySQL:Error', 'HackAttempt', $_AUTH['username'] . ' (' . mysql_real_escape_string($_AUTH['name']) . ') tried to edit ' . $_GET['edit']);
        lovd_showInfoTable('Hack Attempt', 'warning');
        require ROOT_PATH . 'inc-bot.php';
        exit;
    }

    // Require form functions.
    require ROOT_PATH . 'inc-lib-form.php';

    if (isset($_GET['sent'])) {
        lovd_errorClean();

        // Mandatory fields.
        $aCheck =
                 array(
                        'gene' => 'Full gene name',
                        'chrom_location' => 'Chromosome location',
                        'password' => 'Enter your password for authorization',
                      );

        foreach ($aCheck as $key => $val) {
            if (!$_POST[$key]) {
                lovd_errorAdd('Please fill in the \'' . $val . '\' field.');
            }
        }

        // GenBank file or ID.
        if ($_POST['genbank'] && empty($_POST['genbank_uri'])) {
            lovd_errorAdd('If you wish to use a GenBank file, please fill in the "GenBank file name or ID" field. Otherwise, clear the "Has a GenBank file" field.');
        }

        // Disclaimer text.
        if ($_POST['disclaimer'] == 2 && empty($_POST['disclaimer_text'])) {
            lovd_errorAdd('If you wish to use an own disclaimer, please fill in the "Text for own disclaimer" field. Otherwise, select \'No\' for the "Include disclaimer" field.');
        }

        // Numeric fields.
        $aCheck =
                 array(
                        'id_entrez' => 'Entrez Gene (Locuslink) ID',
                        'id_omim_gene' => 'OMIM Gene ID',
                      );

        foreach ($aCheck as $key => $val) {
            if ($_POST[$key] && !is_numeric($_POST[$key])) {
                lovd_errorAdd('The \'' . $val . '\' field has to contain a numeric value.');
            }
        }

        // URLs.
        $aCheck =
                 array(
                        'url_homepage' => 'Homepage URL',
                        'refseq_url' => 'Reference sequence location',
                      );

        foreach ($aCheck as $key => $val) {
            if ($_POST[$key] && !lovd_matchURL($_POST[$key])) {
                lovd_errorAdd('The \'' . $val . '\' field does not seem to contain a correct URL.');
            }
        }

        // List of external links.
        if ($_POST['url_external']) {
            $aExternalLinks = explode("\r\n", trim($_POST['url_external']));
            foreach ($aExternalLinks as $n => $sLink) {
                if (!lovd_matchURL($sLink) && (!preg_match('/^[^<>]+ <?([^< >]+)>?$/', $sLink, $aRegs) || !lovd_matchURL($aRegs[1]))) {
                    lovd_errorAdd('External link #' . ($n + 1) . ' (' . htmlspecialchars($sLink) . ') not understood.');
                }
            }
        }

        // OMIM disease ID list.
        if ($_POST['id_omim_disease']) {
            // OMIM Disease ID's.
            $aOMIM = explode("\r\n", $_POST['id_omim_disease']);
            foreach ($aOMIM as $n => $sOMIM) {
                if (!preg_match('/^[0-9]{1,6} [^<>]+$/', $sOMIM)) {
                    lovd_errorAdd('OMIM Disease ID #' . ($n + 1) . ' (' . htmlspecialchars($sOMIM) . ') not understood.');
                }
            }
        }

        // User had to enter his/her password for authorization.
        if ($_POST['password'] && md5($_POST['password']) != $_AUTH['password']) {
            lovd_errorAdd('Please enter your correct password for authorization.');
        }

        if (!lovd_error()) {
            // Query text.
            $sQ = 'UPDATE ' . TABLE_DBS . ' SET ';

            $_POST['reference'] = $_POST['Gene/Reference'];

            // Standard fields to be used.
            $aQ = array('gene', 'chrom_location', 'reference', 'url_homepage', 'url_external', 'allow_download', 'id_entrez', 'id_omim_gene', 'id_omim_disease', 'show_hgmd', 'show_genetests', 'note_index', 'note_listing', 'genbank', 'genbank_uri', 'refseq', 'refseq_url', 'disclaimer', 'disclaimer_text', 'header', 'footer');

            foreach ($aQ as $key => $val) {
                $sQ .= ($key? ', ' : '') . $val . ' = "' . $_POST[$val] . '"';
            }

            $sQ .= ', edited_by = "' . $_AUTH['userid'] . '", edited_date = NOW() WHERE symbol = "' . $zData['symbol'] . '"';

            $q = mysql_query($sQ);
            if (!$q) {
                require ROOT_PATH . 'inc-top.php';
                if ($bSetup) {
                    lovd_printHeader('setup_genes_manage', 'LOVD Setup - Manage configured genes');
                } else {
                    lovd_printHeader('config_gene_manage', 'LOVD Configuration - Manage gene');
                }
                lovd_dbFout('GeneEdit', $sQ, mysql_error());
            }

            // Write to log...
            lovd_writeLog('MySQL:Event', 'GeneEdit', $_AUTH['username'] . ' (' . mysql_real_escape_string($_AUTH['name']) . ') successfully edited gene ' . $zData['symbol'] . ' (' . $_POST['gene'] . ')');

            // Manipulation to send users coming from the setup right back there...
            if ($bSetup) {
                $sURL = '/setup_genes.php?action=view&view=' . $_GET['edit'];
            } else {
                $sURL = '/config.php';
            }

            // Thank the user...
            header('Refresh: 5; url=http://' . $_SERVER['HTTP_HOST'] . rtrim(dirname($_SERVER['PHP_SELF']), '/') . $sURL . lovd_showSID(true));

            require ROOT_PATH . 'inc-top.php';
            if ($bSetup) {
                lovd_printHeader('setup_genes_manage', 'LOVD Setup - Manage configured genes');
            } else {
                lovd_printHeader('config_gene_manage', 'LOVD Configuration - Manage gene');
            }
            print('      Successfully edited gene ' . stripslashes($_POST['gene']) . '!<BR><BR>' . "\n\n");

            require ROOT_PATH . 'inc-bot.php';
            exit;

        } else {
            // Errors, so the whole lot returns to the form.
            lovd_magicUnquote();

            // Because we're sending the data back to the form, I need to unset the password fields!
            unset($_POST['password']);
        }

    } else {
        foreach ($zData as $key => $val) {
            if (!isset($_POST[$key]) || !$_POST[$key]) {
                $_POST[$key] = $val;
            }
        }
        $_POST['Gene/Reference'] = $_POST['reference'];
        $_POST['password'] = '';
    }



    require ROOT_PATH . 'inc-top.php';
    if ($bSetup) {
        lovd_printHeader('setup_genes_manage', 'LOVD Setup - Manage configured genes');
    } else {
        lovd_printHeader('config_gene_manage', 'LOVD Configuration - Manage gene');
    }

    lovd_errorPrint();

    // Table.
    print('      <FORM action="' . $_SERVER['PHP_SELF'] . '?action=' . $_GET['action'] . ($bSetup? '&amp;edit=' . $zData['symbol'] : '') . '&amp;sent" method="post">' . "\n" .
          '        <TABLE border="0" cellpadding="0" cellspacing="1" width="760">');

    // Array which will make up the form table.
    $aForm = array(
                    array('POST', '', '', '40%', '60%'),
                    array('', 'print', '<B>General information</B>'),
                    'hr',
                    array('Full gene name', 'text', 'gene', 40),
                    'hr',
                    array('Chromosome location', 'text', 'chrom_location', 15),
                    array('', 'print', '<SPAN class="form_note">Example: Xp21.2</SPAN>'),
                    'hr',
                    'skip',
                    'skip',
                    array('', 'print', '<B>Links to information sources (optional)</B>'),
                    array('', 'print', '<SPAN class="form_note">Here you can add links that will be displayed on the gene\'s LOVD gene homepage.</SPAN>'),
                    'hr',
                    array('Homepage URL', 'text', 'url_homepage', 40),
                    array('', 'print', '<SPAN class="form_note">If you have a separate homepage about this gene, you can specify the URL here.<BR>Format: complete URL, including &quot;http://&quot;.</SPAN>'),
                    'hr',
                    array('External links', 'textarea', 'url_external', 55, 3),
                    array('', 'print', '<SPAN class="form_note">Here you can provide links to other resources on the internet that you would like to link to.<BR>One link per line, format: complete URLs or &quot;Description &lt;URL&gt;&quot;.</SPAN>'),
                    'hr',
                    array('Entrez Gene (Locuslink) ID', 'text', 'id_entrez', 10),
                    'hr',
                    array('OMIM Gene ID', 'text', 'id_omim_gene', 10),
                    'hr',
                    array('OMIM Disease IDs', 'textarea', 'id_omim_disease', 30, 3),
                    array('', 'print', '<SPAN class="form_note">One line per OMIM ID, format : &quot;OMIM_ID Disease_name&quot;.<BR>Example : &quot;310200 DMD&quot;.</SPAN>'),
                    'hr',
                    array('Provide link to HGMD', 'checkbox', 'show_hgmd', 1),
                    array('', 'print', '<SPAN class="form_note">Do you want a link to this gene\'s entry in the Human Gene Mutation Database added to the homepage?</SPAN>'),
                    'hr',
                    array('Provide link to GeneTests.org', 'checkbox', 'show_genetests', 1),
                    array('', 'print', '<SPAN class="form_note">Do you want a link to this gene\'s entry in GeneTests.org database added to the homepage?</SPAN>'),
                    'hr',
                    array('Has a GenBank file', 'select', 'genbank', 1, array(1 => 'Uploaded own GenBank file', 2 => 'NCBI GenBank record'), 'No', false, false),
                    array('', 'print', '<SPAN class="form_note">LOVD uses a GenBank file containing your gene sequence for some optional functionalities, such as creating a reference sequence and the mutation check Mutalyzer module. Select this option if you have a GenBank file uploaded to the genbank directory or if you want to use a GenBank record at the NCBI.</SPAN>'),
                    'hr',
                    array('GenBank file name or ID', 'text', 'genbank_uri', 30),
                    array('', 'print', '<SPAN class="form_note">If you have a GenBank file uploaded to the genbank directory, fill in the filename. If you wish to use a NCBI GenBank record, fill in the GenBank accession number.</SPAN>'),
                    'hr',
                    array('Has a reference sequence', 'select', 'refseq', 1, array('c' => 'Coding DNA', 'g' => 'Genomic'), 'No', false, false),
                    array('', 'print', '<SPAN class="form_note">If you have a reference sequence for this gene, please select the type here.</SPAN>'),
                    'hr',
                    array('Reference sequence location', 'text', 'refseq_url', 40),
                    /* FIXME */
                    array('', 'print', '<SPAN class="form_note">If you used our Reference Sequence Parser (not yet functional), the result is located at &quot;http://' . $_SERVER['HTTP_HOST'] . lovd_cleanDirName(dirname($_SERVER['PHP_SELF']) . '/' . ROOT_PATH) . 'refseq/GENESYMBOL_codingDNA.html&quot;.</SPAN>'),
                    'hr',
                    'skip',
                    'skip',
                    array('', 'print', '<B>Customizations (optional)</B>'),
                    array('', 'print', '<SPAN class="form_note">You can use the following fields to customize the gene\'s LOVD gene homepage.</SPAN>'),
                    'hr',
                    array('Citation reference(s)', 'textarea', 'Gene/Reference', 30, 3),
                    /* FIXME; this is hard-coded... do this gracefully, add links if applicable and remove this if it's deactivated */
                    array('', 'print', '<SPAN class="S11">(Active custom link : <A href="#" onclick="javascript:lovd_openWindow(\'' . ROOT_PATH . 'links.php?view=1&amp;col=Gene/Reference\', \'LinkView\', \'800\', \'200\'); return false;">PubMed</A>)</SPAN>'),
                    'hr',
                    array('Include disclaimer', 'select', 'disclaimer', 1, array(1 => 'Use standard LOVD disclaimer', 2 => 'Use own disclaimer (enter below)'), 'No', false, false),
                    array('', 'print', '<SPAN class="form_note">If you want a disclaimer added to the gene\'s LOVD gene homepage, select your preferred option here.</SPAN>'),
                    'hr',
                    array('Text for own disclaimer', 'textarea', 'disclaimer_text', 55, 3),
                    array('', 'print', '<SPAN class="form_note">Only applicable if you choose to use your own disclaimer (see option above).</SPAN>'),
                    'hr',
                    array('Page header', 'textarea', 'header', 55, 3),
                    array('', 'print', '<SPAN class="form_note">Text entered here will appear above all public gene-specific pages.</SPAN>'),
                    'hr',
                    array('Page footer', 'textarea', 'footer', 55, 3),
                    array('', 'print', '<SPAN class="form_note">Text entered here will appear below all public gene-specific pages.</SPAN>'),
                    'hr',
                    array('Notes for the LOVD gene homepage', 'textarea', 'note_index', 55, 3),
                    array('', 'print', '<SPAN class="form_note">Text entered here will appear in the General Information box on the gene\'s LOVD gene homepage.</SPAN>'),
                    'hr',
                    array('Notes for the variant listings', 'textarea', 'note_listing', 55, 3),
                    array('', 'print', '<SPAN class="form_note">Text entered here will appear below the gene\'s variant listings.</SPAN>'),
                    'hr',
                    'skip',
                    'skip',
                    array('', 'print', '<B>Security settings</B>'),
                    array('', 'print', '<SPAN class="form_note">Using the following settings you can control some security settings of LOVD.</SPAN>'),
                    'hr',
                    array('Allow public to download variant entries', 'checkbox', 'allow_download', 1),
                    'hr',
                    'skip',
                    array('Enter your password for authorization', 'password', 'password', 20),
                    array('', 'submit', 'Edit'),
                  );
    $_MODULES->processForm('ConfigGenesEdit', $aForm);
    lovd_viewForm($aForm);

    print('</TABLE></FORM>' . "\n\n");

    require ROOT_PATH . 'inc-bot.php';
    exit;





} elseif ($_GET['action'] == 'empty') {
    // Empty gene variant table.
    list($nTotalVars) = mysql_fetch_row(mysql_query('SELECT COUNT(*) FROM ' . TABLE_PAT2VAR . ' WHERE symbol = "' . $_SESSION['currdb'] . '"'));

    if (!$nTotalVars) {
        // No variants, apparently.
        require ROOT_PATH . 'inc-top.php';
        lovd_printHeader('config_gene_empty', 'LOVD Configuration - Empty gene database');
        lovd_showInfoTable('There are already no variants in this gene database!', 'stop');
        require ROOT_PATH . 'inc-bot.php';
        exit;
    }

    // Curator? Only the ones curating this gene.
    if (!lovd_isCurator($_SESSION['currdb'])) {
        // This is a hack-attempt.
        require ROOT_PATH . 'inc-top.php';
        lovd_printHeader('config_gene_empty', 'LOVD Configuration - Empty gene database');
        lovd_writeLog('MySQL:Error', 'HackAttempt', $_AUTH['username'] . ' (' . mysql_real_escape_string($_AUTH['name']) . ') tried to empty ' . $_GET['edit']);
        lovd_showInfoTable('Hack Attempt', 'warning');
        require ROOT_PATH . 'inc-bot.php';
        exit;
    }

    // Require form functions.
    require ROOT_PATH . 'inc-lib-form.php';

    if (isset($_GET['sent'])) {
        lovd_errorClean();

        // Mandatory fields.
        $aCheck =
                 array(
                        'password' => 'Enter your password for authorization',
                      );

        foreach ($aCheck as $key => $val) {
            if (!$_POST[$key]) {
                lovd_errorAdd('Please fill in the \'' . $val . '\' field.');
            }
        }

        // Other checks ...
        // User had to enter his/her password for authorization.
        if ($_POST['password'] && md5($_POST['password']) != $_AUTH['password']) {
            lovd_errorAdd('Please enter your correct password for authorization.');
        }

        if (!lovd_error()) {
            // Truncate TABLE_CURRDB_VARS, Drop Variant links, Remove orphaned patients from TABLE_PATIENTS.
            require ROOT_PATH . 'inc-top.php';
            lovd_printHeader('config_gene_empty', 'LOVD Configuration - Empty gene database');

            // Using transactions useless here; TRUNCATE TABLE will commit!

            // Start with the variants table.
            print('      Emptying gene database...<BR>' . "\n" .
                  '      Removing all variants ... ');

            flush();
            $sQ = 'TRUNCATE TABLE ' . TABLE_CURRDB_VARS;
            $q = mysql_query($sQ);
            if (!$q) {
                lovd_dbFout('GeneEmptyA', $sQ, mysql_error());
            }

            // Variant links.
            print('      Removing variant <-> patient links ... ');
            flush();
            $sQ = 'DELETE FROM ' . TABLE_PAT2VAR . ' WHERE symbol = "' . $_SESSION['currdb'] . '"';
            $q = mysql_query($sQ);
            if (!$q) {
                lovd_dbFout('GeneEmptyB', $sQ, mysql_error());
            }
            print('OK<BR>' . "\n");

            // Orphaned patients.
            print('      Removing obsolete patients ... ');
            flush();
            // Backwards compatible with MySQL 4.0 and earlier. These versions do not support subqueries, which would really come in handy now.
            // Fist, determine the ID's of the orphaned patients. Then construct the DELETE query.
            $aOrphaned = array();
            $qOrphaned = mysql_query('SELECT p.patientid FROM ' . TABLE_PATIENTS . ' AS p LEFT OUTER JOIN ' . TABLE_PAT2VAR . ' AS p2v USING (patientid) WHERE p2v.symbol IS NULL');
            while ($rOrphaned = mysql_fetch_row($qOrphaned)) {
                $aOrphaned[] = $rOrphaned[0];
            }
            if (count($aOrphaned)) {
                // Construct DELETE query.
                $sQ = 'DELETE FROM ' . TABLE_PATIENTS . ' WHERE patientid IN (' . implode(', ', $aOrphaned) . ')';
                $q = mysql_query($sQ);
                if (!$q) {
                    lovd_dbFout('GeneEmptyC', $sQ, mysql_error());
                }
                print('OK<BR><BR>' . "\n");
            } else {
                print('N/A<BR><BR>' . "\n");
            }

            // Write to log...
            lovd_writeLog('MySQL:Event', 'GeneEmpty', $_AUTH['username'] . ' (' . mysql_real_escape_string($_AUTH['name']) . ') successfully emptied gene ' . $_SESSION['currdb'] . ' (' . $_SETT['currdb']['gene'] . ')');

            // Thank the user...
            print('      Successfully emptied ' . $_SESSION['currdb'] . ' gene database!<BR><BR>' . "\n\n");

            // Alternate refresh; since we can't send a HTTP header...
            print('      <SCRIPT type="text/javascript">' . "\n" .
                  '      <!--' . "\n" .
                  '        setTimeout(\'window.location.href = "http://' . $_SERVER['HTTP_HOST'] . rtrim(dirname($_SERVER['PHP_SELF']), '/') . '/config.php' . lovd_showSID(false, true) . '"\', 3000);' . "\n" .
                  '      // -->' . "\n" .
                  '      </SCRIPT>' . "\n\n");

            require ROOT_PATH . 'inc-bot.php';
            exit;

        } else {
            // Errors, so the whole lot returns to the form.
            lovd_magicUnquote();

            // Because we're sending the data back to the form, I need to unset the password fields!
            unset($_POST['password']);
        }
    }



    require ROOT_PATH . 'inc-top.php';
    lovd_printHeader('config_gene_empty', 'LOVD Configuration - Empty gene database');

    if (!isset($_GET['sent'])) {
        lovd_showInfoTable('Please not that this will delete all variant information for the ' . $_SESSION['currdb'] . ' database!', 'warning');
    }

    lovd_errorPrint();

    // Table.
    print('      <FORM action="' . $_SERVER['PHP_SELF'] . '?action=' . $_GET['action'] . '&amp;sent" method="post">' . "\n" .
          '        <TABLE border="0" cellpadding="0" cellspacing="1" width="760">');

    // Array which will make up the form table.
    $aForm = array(
                    array('POST', '', '', '50%', '50%'),
                    array('Emptying gene database', 'print', $_SESSION['currdb'] . ' (' . $_SETT['currdb']['gene'] . ')'),
                    'skip',
                    array('Enter your password for authorization', 'password', 'password', 20),
                    array('', 'submit', 'Empty gene database'),
                  );
    $_MODULES->processForm('ConfigGenesEmpty', $aForm);
    lovd_viewForm($aForm);

    print('</TABLE></FORM>' . "\n\n");

    require ROOT_PATH . 'inc-bot.php';
    exit;





} else {
    // Default action:
    header('Location: http://' . $_SERVER['HTTP_HOST'] . $_SERVER['PHP_SELF'] . '?action=manage' . lovd_showSID(true));
    exit;
}
?>
