<?php
/*******************************************************************************
 *
 * LEIDEN OPEN VARIATION DATABASE (LOVD)
 *
 * Created     : 2006-11-20
 * Modified    : 2007-12-14
 * For LOVD    : 2.0-02
 *
 * Access      : Public
 * Purpose     : Edit & drop variant selected gene's variants.
 *
 * Copyright   : 2004-2007 Leiden University Medical Center; http://www.LUMC.nl/
 * Programmer  : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *
 * This file is part of LOVD.
 *
 * LOVD is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * LOVD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LOVD; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *************/

define('ROOT_PATH', './');
require ROOT_PATH . 'inc-init.php';

if (HAS_AUTH) {
    // If authorized, check for updates.
    require ROOT_PATH . 'inc-upgrade.php';
}

// Require curator clearance.
lovd_requireAUTH(LEVEL_CURATOR);

// If no gene selected, forward to the select list.
if (!$_SESSION['currdb']) {
    header('Location: http://' . $_SERVER['HTTP_HOST'] . rtrim(dirname($_SERVER['PHP_SELF']), '/') . '/home.php' . lovd_showSID());
    exit;
}

// Whether or not a user can see non-public data.
if (lovd_isCurator($_SESSION['currdb'])) {
    define('IS_CURATOR', true);
} else {
    define('IS_CURATOR', false);
}

// Non-curators do not belong here.
if (!IS_CURATOR) {
    require ROOT_PATH . 'inc-top.php';
    lovd_showInfoTable('You are not allowed access to this gene database. Please contact your manager or the administrator to grant you access.', 'stop');
    require ROOT_PATH . 'inc-bot.php';
    exit;
}





if ($_GET['action'] == 'edit' && preg_match('/^([0-9]{1,7})\,([0-9]{1,7})\,([0-9]{1,2})$/', $_GET['edit'], $aRegs) && list(, $_GET['patientid'], $_GET['variantid'], $_GET['allele']) = $aRegs) {
    // Edit sequence variant incl. specific variant/patient link.

    $zData = @mysql_fetch_assoc(mysql_query('SELECT p2v.*, v.* FROM ' . TABLE_PAT2VAR . ' AS p2v LEFT JOIN ' . TABLE_CURRDB_VARS . ' AS v ON (p2v.variantid = v.variantid) WHERE p2v.symbol = "' . $_SESSION['currdb'] . '" AND v.variantid = "' . $_GET['variantid'] . '" AND p2v.patientid = "' . $_GET['patientid'] . '" AND p2v.allele = "' . $_GET['allele'] . '"'));
    if (!$zData) {
        // Wrong ID, apparently.
        require ROOT_PATH . 'inc-top.php';
        lovd_printHeader('variant_manage', 'LOVD Manage sequence variants');
        lovd_showInfoTable('No such ID!', 'stop');
        require ROOT_PATH . 'inc-bot.php';
        exit;
    }

    // Require form functions.
    require ROOT_PATH . 'inc-lib-form.php';
    require ROOT_PATH . 'class/currdb.php';
    $_CURRDB = new CurrDB();
    $sMutationCol = $_CURRDB->getMutationCol();

    // 2007-09-04; 2.0-beta-08; Add quick-curate option.
    if (isset($_GET['curate']) && !isset($_GET['sent'])) {
        // Curate this entry... nothing edited except for the status.
        foreach ($zData as $key => $val) {
            if (!isset($_POST[$key]) || !$_POST[$key]) {
                $_POST[$key] = $val;
            }
        }
        // Transform select lists' values.
        $_CURRDB->transformSelectValues($_POST, true);
        $_POST['pathogenic_reported'] = $_POST['pathogenic']{0};
        $_POST['pathogenic_concluded'] = $_POST['pathogenic']{1};
        $_POST['status'] = 9;
        $_POST['password'] = $_AUTH['password'];
        $_GET['sent'] = true;
    }

    if (isset($_GET['sent'])) {
        lovd_errorClean();

        // Mandatory fields.
        if ($_POST['status'] >= STATUS_MARKED) {
            $_CURRDB->checkMandatory('Variant');
        }

        // Field lengths.
        $_CURRDB->checkInputLength();

        // Field types.
        $_CURRDB->checkInputType();

        // Regular expressions.
        $_CURRDB->checkInputRegExp();

        // Mandatory fields.
        $aCheck =
                 array(
                        'password' => 'Enter your password for authorization',
                      );

        foreach ($aCheck as $key => $val) {
            if (!$_POST[$key]) {
                lovd_errorAdd('Please fill in the \'' . $val . '\' field.');
            }
        }

        // Other checks ...
        // User had to enter his/her password for authorization.
        if (isset($_GET['curate']) && $_POST['password'] && $_POST['password'] != $_AUTH['password']) {
            lovd_errorAdd('Please enter your correct password for authorization.');
        } elseif (!isset($_GET['curate']) && $_POST['password'] && md5($_POST['password']) != $_AUTH['password']) {
            lovd_errorAdd('Please enter your correct password for authorization.');
        }

        // 2006-12-07; 2.0-alpha-02
        // XSS attack prevention. Simply deny input of HTML, PHP other stuff blocked by strip_tags().
        lovd_checkXSS();

        if (!lovd_error()) {
            // Query text.
            $sQ = 'UPDATE ' . TABLE_CURRDB_VARS . ' SET ';

            // Get columns to update in the database.
            $aCols = $_CURRDB->getColList('Variant');

            if ($sMutationCol && in_array($sMutationCol, array('Variant/DNA', 'Variant/RNA'))) {
                // Find mutation column, include sort column in list.
                $aCols[] = 'sort';
                $_POST['sort'] = lovd_sort($_POST[$sMutationCol]);
            }

            foreach ($aCols as $key => $val) {
                // 2007-06-28; 2.0-beta-05; sometimes fields are not sent. HTTP posting faked or empty selection list?
                if (!isset($_POST[$val])) {
                    $_POST[$val] = '';
                }

                // Selection list to value.
                if (is_array($_POST[$val])) {
                    $_POST[$val] = implode(';', $_POST[$val]);
                }
                $sQ .= ($key? ', ' : '') . '`' . $val . '` = "' . $_POST[$val] . '"';
            }

            $sQ .= ' WHERE variantid = ' . $_GET['variantid'];

            $q = mysql_query($sQ);
            if (!$q) {
                require ROOT_PATH . 'inc-top.php';
                lovd_printHeader('variant_manage', 'LOVD Manage sequence variants');
                lovd_dbFout('VariantEditA', $sQ, mysql_error());
            }

            // We need to update *all* edited_by and edited_date fields if the fields of the mutation itself were actually changed.
            $bUpdateAll = mysql_affected_rows();

            if ($bUpdateAll) {
                $sQ = 'UPDATE ' . TABLE_PAT2VAR . ' SET edited_by = "' . $_AUTH['userid'] . '", edited_date = NOW() WHERE symbol = "' . $_SESSION['currdb'] . '" AND variantid = "' . $_GET['variantid'] . '"';
                $q = mysql_query($sQ);
                if (!$q) {
                    require ROOT_PATH . 'inc-top.php';
                    lovd_printHeader('variant_manage', 'LOVD Manage sequence variants');
                    lovd_dbFout('VariantEditB', $sQ, mysql_error());
                }
            }

            // Variant pathogenicity.
            if (HAS_AUTH) {
                // Curator and up.
                $_POST['pathogenic'] = $_POST['pathogenic_reported'] . $_POST['pathogenic_concluded'];
            } else {
                // FIXME; not possible at this point, but keep this here for later.
                // Submitter...
                if (!array_key_exists($_POST['pathogenic_reported'], $_SETT['var_pathogenic'])) {
                    $_POST['pathogenic'] = 99;
                } else {
                    $_POST['pathogenic'] = $_POST['pathogenic_reported'] . '9';
                }
            }

            // Update PAT2VAR table.
            $sQ = 'UPDATE ' . TABLE_PAT2VAR . ' SET allele = "' . $_POST['allele'] . '", pathogenic = "' . $_POST['pathogenic'] . '", status = "' . $_POST['status'] . '", edited_by = "' . $_AUTH['userid'] . '", edited_date = NOW() WHERE symbol = "' . $_SESSION['currdb'] . '" AND variantid = "' . $_GET['variantid'] . '" AND patientid = "' . $_GET['patientid'] . '" AND allele = "' . $_GET['allele'] . '"';
            $q = mysql_query($sQ);
            if (!$q) {
                require ROOT_PATH . 'inc-top.php';
                lovd_printHeader('variant_manage', 'LOVD Manage sequence variants');
                lovd_dbFout('VariantEditC', $sQ, mysql_error());
            }

            // 2007-12-05; 2.0-02; Fixed bug #20 - Gene's "Last update" field not updated.
            lovd_setUpdatedDate($_SESSION['currdb']);

            // Write to log...
            lovd_writeLog('MySQL:Event', 'VariantEdit', $_AUTH['username'] . ' (' . mysql_real_escape_string($_AUTH['name']) . ') successfully ' . (isset($_GET['curate'])? 'curat' : 'edit') . 'ed variant #' . $zData['variantid'] . ' (' . $_SESSION['currdb'] . ')');

            // Thank the user...
            header('Refresh: ' . (isset($_GET['curate'])? '1' : '3') . '; url=http://' . $_SERVER['HTTP_HOST'] . rtrim(dirname($_SERVER['PHP_SELF']), '/') . '/variants.php?action=view&view=' . $_GET['patientid'] . '%2C' . $_GET['variantid'] . '%2C' . $_POST['allele'] . lovd_showSID(true));

            require ROOT_PATH . 'inc-top.php';
            lovd_printHeader('variant_manage', 'LOVD Manage sequence variants');
            lovd_showInfoTable('Successfully ' . (isset($_GET['curate'])? 'curat' : 'edit') . 'ed variant!', 'success');

            require ROOT_PATH . 'inc-bot.php';
            exit;

        } else {
            // Errors, so the whole lot returns to the form.
            lovd_magicUnquoteAll();

            // Because we're sending the data back to the form, I need to unset the password fields!
            unset($_POST['password']);
        }

    } else {
        foreach ($zData as $key => $val) {
            if (!isset($_POST[$key]) || !$_POST[$key]) {
                $_POST[$key] = $val;
            }
        }
        // Transform select lists' values.
        $_CURRDB->transformSelectValues($_POST, true);
        $_POST['pathogenic_reported'] = $_POST['pathogenic']{0};
        $_POST['pathogenic_concluded'] = $_POST['pathogenic']{1};
        $_POST['password'] = '';
    }



    require ROOT_PATH . 'inc-top.php';
    lovd_printHeader('variant_manage', 'LOVD Manage sequence variants');

    if (!isset($_GET['sent'])) {
        print('      To edit the sequence variant, please fill out the form below.<BR>' . "\n" .
              '      <BR>' . "\n\n");
    }

    lovd_errorPrint();

    // Table.
    print('      <FORM action="' . $_SERVER['PHP_SELF'] . '?select_db=' . $_SESSION['currdb'] . '&amp;action=' . $_GET['action'] . '&amp;edit=' . $_GET['edit'] . '&amp;sent=true" method="post">' . "\n" .
          '        <TABLE border="0" cellpadding="0" cellspacing="1" width="760">');

    // Array which will make up the form table.
    $aForm = array_merge(
                         array(
                                array('POST', '', '', '40%', '60%'),
                                array('Variant allele', 'select', 'allele', 1, $_SETT['var_allele'], false, false, false),
                              ),
                         $_CURRDB->buildFormTable('Variant'),
                         array(
                                'skip',
                                array('Pathogenicity (reported)', 'select', 'pathogenic_reported', 1, $_SETT['var_pathogenic'], false, false, false),
                                array('Pathogenicity (concluded)', 'select', 'pathogenic_concluded', 1, $_SETT['var_pathogenic'], false, false, false),
                                array('Variant status', 'select', 'status', 1, $_SETT['var_status'], false, false, false),
                                'skip',
                                array('Enter your password for authorization', 'password', 'password', 20),
                                array('', 'submit', 'Edit variant data'),
                              ));
    $_MODULES->processForm('SubmitVariantsEdit', $aForm);
    lovd_viewForm($aForm);

    print('</TABLE></FORM>' . "\n\n");

    require ROOT_PATH . 'inc-bot.php';
    exit;





} elseif ($_GET['action'] == 'drop' && preg_match('/^([0-9]{1,7})\,([0-9]{1,7})\,([0-9]{1,2})$/', $_GET['drop'], $aRegs) && list(, $_GET['patientid'], $_GET['variantid'], $_GET['allele']) = $aRegs) {
    // Drop specific variant/patient link.

    // Require form functions.
    require ROOT_PATH . 'inc-lib-form.php';
    require ROOT_PATH . 'class/currdb.php';
    $_CURRDB = new CurrDB();
    $sMutationCol = $_CURRDB->getMutationCol();

    $zData = @mysql_fetch_assoc(mysql_query('SELECT p2v.*' . (!$sMutationCol? '' : ', v.`' . $sMutationCol . '`') . ' FROM ' . TABLE_PAT2VAR . ' AS p2v LEFT JOIN ' . TABLE_CURRDB_VARS . ' AS v ON (p2v.variantid = v.variantid) WHERE p2v.symbol = "' . $_SESSION['currdb'] . '" AND v.variantid = "' . $_GET['variantid'] . '" AND p2v.patientid = "' . $_GET['patientid'] . '" AND p2v.allele = "' . $_GET['allele'] . '"'));
    if (!$zData) {
        // Wrong ID, apparently.
        require ROOT_PATH . 'inc-top.php';
        lovd_printHeader('variant_manage', 'LOVD Manage sequence variants');
        lovd_showInfoTable('No such ID!', 'stop');
        require ROOT_PATH . 'inc-bot.php';
        exit;
    }

    if (isset($_GET['sent'])) {
        lovd_errorClean();

        // Mandatory fields.
        $aCheck =
                 array(
                        'password' => 'Enter your password for authorization',
                      );

        foreach ($aCheck as $key => $val) {
            if (!$_POST[$key]) {
                lovd_errorAdd('Please fill in the \'' . $val . '\' field.');
            }
        }

        // Other checks ...
        // User had to enter his/her password for authorization.
        if ($_POST['password'] && md5($_POST['password']) != $_AUTH['password']) {
            lovd_errorAdd('Please enter your correct password for authorization.');
        }

        if (!lovd_error()) {
            // Drop Variant link, Remove orphaned patients from TABLE_PATIENTS and orphaned variants from TABLE_CURRDB_VARS.

            require ROOT_PATH . 'inc-top.php';
            lovd_printHeader('variant_manage', 'LOVD Manage sequence variants');

            // If using transactional tables; begin transaction.
            if ($_INI['database']['engine'] == 'InnoDB') {
                // FIXME; It's better to use 'START TRANSACTION', but that's only available from 4.0.11.
                //   This works from the introduction of InnoDB in 3.23
                @mysql_query('BEGIN WORK');
            }

            // Start with the variant's connection.
            print('      Removing variant...<BR>' . "\n" .
                  '      Removing variant <-> patient link ... ');
            flush();
            $sQ = 'DELETE FROM ' . TABLE_PAT2VAR . ' WHERE patientid = "' . $_GET['patientid'] . '" AND allele = "' . $_GET['allele'] . '" AND symbol = "' . $_SESSION['currdb'] . '" AND variantid = "' . $_GET['variantid'] . '"';
            $q = mysql_query($sQ);
            if (!$q) {
                lovd_dbFout('VariantDropA', $sQ, mysql_error());
            }
            print('OK<BR>' . "\n");

            // Orphaned patients.
            print('      Removing obsolete patients ... ');
            flush();
            // Backwards compatible with MySQL 4.0 and earlier. These versions do not support subqueries, which would really come in handy now.
            // First, determine the ID's of the orphaned patients. Then construct the DELETE query.
            $aOrphaned = array();
            $qOrphaned = mysql_query('SELECT p.patientid FROM ' . TABLE_PATIENTS . ' AS p LEFT OUTER JOIN ' . TABLE_PAT2VAR . ' AS p2v USING (patientid) WHERE p2v.symbol IS NULL');
            while ($rOrphaned = mysql_fetch_row($qOrphaned)) {
                $aOrphaned[] = $rOrphaned[0];
            }
            $bDeleted = in_array($zData['patientid'], $aOrphaned);
            if (count($aOrphaned)) {
                // Construct DELETE query.
                $sQ = 'DELETE FROM ' . TABLE_PATIENTS . ' WHERE patientid IN (' . implode(', ', $aOrphaned) . ')';
                $q = mysql_query($sQ);
                if (!$q) {
                    lovd_dbFout('VariantDropB', $sQ, mysql_error());
                }
                print('OK<BR>' . "\n");
            } else {
                print('N/A<BR>' . "\n");
            }

            // Orphaned variants.
            print('      Removing obsolete variants ... ');
            flush();
            // Backwards compatible with MySQL 4.0 and earlier. These versions do not support subqueries, which would really come in handy now.
            // Fist, determine the ID's of the orphaned patients. Then construct the DELETE query.
            $aOrphaned = array();
            $qOrphaned = mysql_query('SELECT v.variantid FROM ' . TABLE_CURRDB_VARS . ' AS v LEFT OUTER JOIN ' . TABLE_PAT2VAR . ' AS p2v ON (v.variantid = p2v.variantid AND p2v.symbol = "' . $_SESSION['currdb'] . '") WHERE p2v.symbol IS NULL');
            while ($rOrphaned = mysql_fetch_row($qOrphaned)) {
                $aOrphaned[] = $rOrphaned[0];
            }
            if (count($aOrphaned)) {
                // Construct DELETE query.
                $sQ = 'DELETE FROM ' . TABLE_CURRDB_VARS . ' WHERE variantid IN (' . implode(', ', $aOrphaned) . ')';
                $q = mysql_query($sQ);
                if (!$q) {
                    lovd_dbFout('VariantDropC', $sQ, mysql_error());
                }
                print('OK<BR><BR>' . "\n\n");
            } else {
                print('N/A<BR><BR>' . "\n\n");
            }

            // If we don't do this, we haven't got anything in the DB... duh!
            if ($_INI['database']['engine'] == 'InnoDB') {
                // Could this actually fail?!!??
                @mysql_query('COMMIT');
            }

            // 2007-12-05; 2.0-02; Fixed bug #20 - Gene's "Last update" field not updated.
            lovd_setUpdatedDate($_SESSION['currdb']);

            // Write to log...
            lovd_writeLog('MySQL:Event', 'VariantDrop', $_AUTH['username'] . ' (' . mysql_real_escape_string($_AUTH['name']) . ') successfully deleted variant for ' . $_SESSION['currdb'] . ' (Patient #' . $_GET['patientid'] . '; Mutation #' . $_GET['variantid'] . '; Allele #' . $_GET['allele'] . ')');

            // Thank the user...
            print('      Successfully deleted variant!<BR><BR>' . "\n\n");

            // Alternate refresh; since we can't send a HTTP header...
            print('      <SCRIPT type="text/javascript">' . "\n" .
                  '      <!--' . "\n");
            // 2007-08-09; 2.0-beta-07; View patient information without considering any variants is now possible.
            if ($bDeleted) {
                print('        setTimeout(\'window.location.href = "http://' . $_SERVER['HTTP_HOST'] . rtrim(dirname($_SERVER['PHP_SELF']), '/') . '/variants.php?action=view_all' . lovd_showSID(true) . '"\', 3000);' . "\n");
            } else {
                print('        setTimeout(\'window.location.href = "http://' . $_SERVER['HTTP_HOST'] . rtrim(dirname($_SERVER['PHP_SELF']), '/') . '/variants.php?select_db=' . $_SESSION['currdb'] . '&action=view&view=' . $zData['patientid'] . lovd_showSID(true) . '"\', 3000);' . "\n");
            }
            print('      // -->' . "\n" .
                  '      </SCRIPT>' . "\n\n");

            require ROOT_PATH . 'inc-bot.php';
            exit;

        } else {
            // Fouten, dus de zooi moet terug naar het formulier.
            lovd_magicUnquoteAll();

            // Omdat het geheel terug gaat naar het formulier, moet ik de password fields wel weghalen!
            unset($_POST['password']);
        }
    }



    require ROOT_PATH . 'inc-top.php';
    lovd_printHeader('variant_manage', 'LOVD Manage sequence variants');

    lovd_errorPrint();

    // Table.
    print('      <FORM action="' . $_SERVER['PHP_SELF'] . '?action=' . $_GET['action'] . '&amp;drop=' . $_GET['drop'] . '&amp;sent=true" method="post">' . "\n" .
          '        <TABLE border="0" cellpadding="0" cellspacing="1" width="760">');

    // Array which will make up the form table.
    $aForm = array(
                    array('POST', '', '', '50%', '50%'),
                    array('Deleting variant', 'print', ($sMutationCol? $zData[$sMutationCol] . ' (allele ' . $zData['allele'] . ')' : 'Variant in allele ' . $zData['allele'])),
                    'skip',
                    array('Enter your password for authorization', 'password', 'password', 20),
                    array('', 'submit', 'Delete variant'),
                  );
    $_MODULES->processForm('SubmitVariantsDelete', $aForm);
    lovd_viewForm($aForm);

    print('</TABLE></FORM>' . "\n\n");

    require ROOT_PATH . 'inc-bot.php';
    exit;





} else {
    // Default action:
    header('Location: http://' . $_SERVER['HTTP_HOST'] . rtrim(dirname($_SERVER['PHP_SELF']), '/') . '/variants.php?action=view_all' . lovd_showSID(true));
    exit;
}
?>