<?php
/*******************************************************************************
 *
 * LEIDEN OPEN VARIATION DATABASE (LOVD)
 *
 * Created     : 2007-02-19
 * Modified    : 2007-12-21
 * For LOVD    : 2.0-02
 *
 * Access      : Administrator and managers
 * Purpose     : Create and manage LOVD custom columns.
 *
 * Copyright   : 2004-2007 Leiden University Medical Center; http://www.LUMC.nl/
 * Programmer  : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *
 * This file is part of LOVD.
 *
 * LOVD is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * LOVD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LOVD; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *************/

define('ROOT_PATH', './');
require ROOT_PATH . 'inc-init.php';

if (HAS_AUTH) {
    // If authorized, check for updates.
    require ROOT_PATH . 'inc-upgrade.php';
}

// Require manager clearance.
lovd_requireAUTH(LEVEL_MANAGER);





if ($_GET['action'] == 'view_all') {
    // View all cols.

    require ROOT_PATH . 'inc-lib-list.php';
    require ROOT_PATH . 'inc-lib-columns.php';
    require ROOT_PATH . 'inc-top.php';
    lovd_printHeader('setup_columns_view_defaults', 'LOVD Setup - View custom column defaults');

    list($nTotal) = mysql_fetch_row(mysql_query('SELECT COUNT(*) FROM ' . TABLE_COLS));
    if (!$nTotal) {
        lovd_showInfoTable('There are no custom columns configured in this system.', 'information');
        require ROOT_PATH . 'inc-bot.php';
        exit;
    }

    lovd_showInfoTable('Please note that these are all columns available in this LOVD installation. This is not the list of columns actually added to the system. Also, modifications made to the columns added to the system are not shown.', 'information', 950);

    // Standard query, will be extended later on.
    $sQ = 'SELECT *, (created_by = 0) AS created FROM ' . TABLE_COLS;

    // SORT: Current settings.
    if (isset($_GET['order']) && $_GET['order']) {
        $aOrder = explode(',', $_GET['order']);
    } else {
        $aOrder = array('', '');
    }

    // SORT: Column data.
    $aOrderList = array('colid' => array('colid', 'ASC'), 'hgvs' => array('hgvs', 'DESC'), 'standard' => array('standard', 'DESC'), 'head_column' => array('head_column', 'ASC'), 'public' => array('public', 'DESC'), 'created' => array('created', 'DESC'));
    if (!array_key_exists($aOrder[0], $aOrderList)) {
        $aOrder[0] = 'colid';
    }
    if ($aOrder[1] != 'ASC' && $aOrder[1] != 'DESC') {
        $aOrder[1] = $aOrderList[$aOrder[0]][1];
    }

    $sQueryLimit = lovd_pagesplitInit($nTotal, 25);
    $sQ .= ' ORDER BY ' . $aOrderList[$aOrder[0]][0] . ' ' . $aOrder[1] . ', colid ' . $sQueryLimit;



    // Show form; required for sorting and searching.
    print('      <FORM action="' . $_SERVER['PHP_SELF'] . '" method="get" style="margin : 0px;">' . "\n" .
          '        <INPUT type="hidden" name="action" value="' . $_GET['action'] . '">' . "\n" .
          '        <INPUT type="hidden" name="order" value="' . implode(',', $aOrder) . '">');
    print('</FORM>' . "\n\n");

    $q = mysql_query($sQ);
    if (!$q) {
        lovd_dbFout('Cols' . ucfirst($_GET['action']), $sQ, mysql_error());
    }

    $n = (isset($nResults)? $nResults : $nTotal);
    print('      <SPAN class="S11">' . $n . ' entr' . ($n == 1? 'y' : 'ies') . '</SPAN><BR>' . "\n");

    // Array which will make up the table (header and data).
    $aTable =
             array(
                    'colid' => array('ID', '*'),
                    'hgvs' => array('HGVS', '60', 'align="center"'),
                    'standard' => array('Standard', '80', 'align="center"'),
                    'head_column' => array('Column heading', '*'),
                    'form_type' => array('Form type', '*'),
                    'public' => array('Public', '60', 'align="center"'),
                    'created' => array('Created by', '90'),
                  );

    // Table.
    print('      <TABLE border="0" cellpadding="0" cellspacing="1" width="950" class="data">' . "\n" .
          '        <TR>');

    foreach ($aTable as $sField => $aCol) {
        print("\n" . '          <TH' . (isset($aCol[2]) && $aCol[2]? ' ' . $aCol[2] : '') . (is_numeric($aCol[1])? ' width="' . $aCol[1] . '"' : '') . (array_key_exists($sField, $aOrderList)? ' class="order' . ($aOrder[0] == $sField? 'ed' : '') . '" onclick="document.forms[0].order.value=\'' . $sField . ',' . ($aOrder[0] == $sField? ($aOrder[1] == 'ASC'? 'DESC' : 'ASC') : $aOrderList[$sField][1]) . '\';document.forms[0].submit();"' : '') . '>' .
              (array_key_exists($sField, $aOrderList)? "\n" .
                                                           '            <TABLE border="0" cellpadding="0" cellspacing="0" width="100%" class="S11">' . "\n" .
                                                           '              <TR>' . "\n" .
                                                           '                <TH>' . str_replace(' ', '&nbsp;', $aCol[0]) . '</TH>' . "\n" .
                                                           '                <TD align="right"><IMG src="gfx/order_arrow_desc' . ($aOrder[0] == $sField && $aOrder[1] == 'DESC'? '_sel' : '') . '.png" alt="Descending" title="Descending" width="13" height="6"><BR><IMG src="gfx/order_arrow_asc' . ($aOrder[0] == $sField && $aOrder[1] == 'ASC'? '_sel' : '') . '.png" alt="Ascending" title="Ascending" width="13" height="6"></TD></TR></TABLE>' : $aCol[0]) . '</TH>');
    }
    print('</TR>');

    while ($zData = mysql_fetch_assoc($q)) {
        print("\n" .
              '        <TR style="cursor : pointer; cursor : hand;" onmouseover="this.className = \'hover\';" onmouseout="this.className = \'\';" onclick="window.location.href = \'' . $_SERVER['PHP_SELF'] . '?action=view&amp;view=' . rawurlencode($zData['colid']) . lovd_showSID(true, true) . '\';">');

        // Put first part of colid in bold.
        $zData['colid']     = '<A href="' . $_SERVER['PHP_SELF'] . '?action=view&amp;view=' . $zData['colid'] . '" class="data">' . preg_replace('/^([[:alnum:]]+)\/(.*)$/', '<B>$1</B>/$2', $zData['colid']) . '</A>';
        $zData['hgvs']      = '<IMG src="' . ROOT_PATH . 'gfx/mark_' . $zData['hgvs'] . '.png" alt="" width="11" height="11">';
        $zData['standard']  = '<IMG src="' . ROOT_PATH . 'gfx/mark_' . $zData['standard'] . '.png" alt="" width="11" height="11">';
        $zData['form_type'] = lovd_describeFormType($zData);
        $zData['public']    = '<IMG src="' . ROOT_PATH . 'gfx/mark_' . $zData['public'] . '.png" alt="" width="11" height="11">';
        $zData['created']   = ($zData['created']? 'LOVD' : 'LOVD user');

        foreach ($aTable as $sField => $aCol) {
            print("\n" . '          <TD' . (isset($aCol[2]) && $aCol[2]? ' ' . $aCol[2] : '') . (is_numeric($aCol[1])? ' width="' . $aCol[1] . '"' : '') . ($aOrder[0] == $sField? ' class="ordered"' : '') . '>' . (!$zData[$sField]? '-' : $zData[$sField]) . '</TD>');
        }
        print('</TR>');
    }
    print('</TABLE>' . "\n\n");

    // URL pagelink.
    $sPageLink = 'order=' . rawurlencode(implode(',', $aOrder));

    lovd_pagesplitShowNav($sPageLink);

    require ROOT_PATH . 'inc-bot.php';
    exit;





} elseif ($_GET['action'] == 'view' && !empty($_GET['view'])) {
    // View specific column.

    require ROOT_PATH . 'inc-lib-columns.php';
    require ROOT_PATH . 'inc-top.php';
    lovd_printHeader('setup_columns_view_defaults', 'LOVD Setup - View custom column defaults');

    $zData = @mysql_fetch_assoc(mysql_query('SELECT c.*, u_c.name AS created_by, u_e.name AS edited_by FROM ' . TABLE_COLS . ' AS c LEFT OUTER JOIN ' . TABLE_USERS . ' AS u_c ON (c.created_by = u_c.userid) LEFT OUTER JOIN ' . TABLE_USERS . ' AS u_e ON (c.edited_by = u_e.userid) WHERE c.colid = "' . $_GET['view'] . '"'));
    if (!$zData) {
        // Wrong ID, apparently.
        lovd_showInfoTable('No such ID!', 'stop');
        require ROOT_PATH . 'inc-bot.php';
        exit;
    }

    // Array which will make up the data table.
    $aTable =
             array(
                    'colid' => 'Column ID',
                    'hgvs_' => 'HGVS column',
                    'standard' => 'Standard',
                    'mandatory' => 'Mandatory',
                    'head_column' => 'Column heading',
                    'description_form' => 'Description on form',
                    'description_legend_short' => 'Description on short legend',
                    'description_legend_full' => 'Description on full legend',
                    'mysql_type' => 'Database type',
                    'form_type' => 'Form type',
                    'select_options' => 'Select options',
                    'preg_pattern' => 'Regular expression pattern',
                    'public' => 'Show to public',
                    'public_form' => 'Show on public form',
                    'created_by' => 'Created by',
                    'created_date' => 'Date created',
                    'edited_by' => 'Last edited by',
                    'edited_date' => 'Date last edited',
                  );

    // Prepare information for created by column.
    if (!$zData['created_by']) {
        // LOVD custom column.
        $zData['created_by'] = 'LOVD';
    }

    // Remove unnecessary columns.
    if ($zData['edited_by'] == NULL) {
        // Never been edited.
        unset($aTable['edited_by'], $aTable['edited_date']);
    }

    // Remove columns based on form type?
    $aFormType = explode('|', $zData['form_type']);
    if ($aFormType[1] != 'select') {
        unset($aTable['select_options']);
    } else {
        unset($aTable['preg_pattern']);
    }

    // Table.
    print('      <TABLE border="0" cellpadding="0" cellspacing="1" width="600" class="data">');

    $zData['hgvs_']          = '<IMG src="' . ROOT_PATH . 'gfx/mark_' . $zData['hgvs'] . '.png" alt="" width="11" height="11">';
    $zData['standard']       = '<IMG src="gfx/mark_' . $zData['standard'] . '.png" alt="" width="11" height="11">';
    $zData['mandatory']      = '<IMG src="gfx/mark_' . $zData['mandatory'] . '.png" alt="" width="11" height="11">';
    $zData['form_type']      = lovd_describeFormType($zData) . '<BR>' . $zData['form_type'];
    $zData['select_options'] = str_replace(array("\r\n", "\r", "\n"), '<BR>', $zData['select_options']);
    $zData['public']         = '<IMG src="gfx/mark_' . $zData['public'] . '.png" alt="" width="11" height="11">';
    $zData['public_form']    = '<IMG src="gfx/mark_' . $zData['public_form'] . '.png" alt="" width="11" height="11">';

    foreach ($aTable as $sField => $sHeader) {
        print("\n" .
              '        <TR>' . "\n" .
              '          <TH valign="top">' . str_replace(' ', '&nbsp;', $sHeader) . '</TH>' . "\n" .
              '          <TD>' . (!$zData[$sField]? '-' : $zData[$sField]) . '</TD></TR>');
    }
    print('</TABLE>' . "\n\n");

    $sNavigation = '';
    // Authorized user (admin or manager) is logged in. Provide tools.
    $sNavigation = '<A href="' . $_SERVER['PHP_SELF'] . '?action=edit&amp;edit=' . rawurlencode($zData['colid']) . '">Edit settings</A>';
// FIXME; Drop global column?
    $sNavigation .= ' | <A ' . (!$zData['hgvs'] && false? 'href="' . $_SERVER['PHP_SELF'] . '?action=drop&amp;drop=' . rawurlencode($zData['colid']) . '"' : 'style="color : #999999;"') . '>Delete column</A>';

    if ($sNavigation) {
        print('      <IMG src="gfx/trans.png" alt="" width="1" height="5"><BR>' . "\n");
        lovd_viewNavigation($sNavigation);
    }

    require ROOT_PATH . 'inc-bot.php';
    exit;





} elseif ($_GET['action'] == 'form_type_define') {
    // Show form type forms and send info back.

    // Require form functions.
    require ROOT_PATH . 'inc-lib-form.php';

    // Step 1: Choose column form type.
    if (empty($_POST['form_type'])) {
        // Choose from five form types, and continue.

        require ROOT_PATH . 'inc-top-clean.php';
        lovd_printHeader('setup_columns_manage_defaults', 'LOVD Setup - Manage custom column defaults');

        // Table.
        print('      <FORM action="' . $_SERVER['PHP_SELF'] . '?action=' . $_GET['action'] . '" method="post">' . "\n" .
              '        <TABLE border="0" cellpadding="0" cellspacing="1" width="760">');

        // If we've been here before, select last used option.
        if (!empty($_SESSION['form_type']['form_type'])) {
            $_POST['form_type'] = $_SESSION['form_type']['form_type'];
        }

        // Form types.
        $aTypes =
                 array(
                        'text' => 'Text/numeric input field',
                        'int' => 'Integer input field',
                        'textarea' => 'Large multi-row textual input field',
                        'select' => 'Drop down list (one option selected)',
                        'select_multiple' => 'Selection list (multiple options selected)',
                        'checkbox' => 'On/off checkbox',
                      );

        // Array which will make up the form table.
        $aForm = array(
                        array('POST', '', '', '30%', '70%'),
                        array('', 'print', '<B>Select custom column\'s form style</B>'),
                        array('Basic form style', 'select', 'form_type', 1, $aTypes, false, false, false),
                        array('', 'print', '<SPAN class="form_note">This is the type of field your custom column will appear on the input forms, such as the submission form.</SPAN>'),
                        'skip',
                        array('', 'submit', 'Next &raquo;'),
                      );
        $_MODULES->processForm('SetupColumnsGlobalFormTypeStyle', $aForm);
        lovd_viewForm($aForm);

        print('</TABLE></FORM>' . "\n\n");

        require ROOT_PATH . 'inc-bot-clean.php';
        exit;
    }

    // Store in SESSION.
    $_SESSION['form_type']['form_type'] = $_POST['form_type'];



    // Step 2: Gather options.
    if (isset($_GET['sent'])) {
        lovd_errorClean();

        // Verplichte velden met de bijbehorende namen.
        $aCheckM =
                 array(
                        'name' => 'Column name on form',
                      );

        // Numeric fields.
        $aCheckN = array();

        // Mandatory and Numeric fields depend on column type.
        switch ($_POST['form_type']) {
            case 'text':
                $aCheckM['size'] = 'Width on form (characters)';
                $aCheckM['maxlength'] = 'Maximum input length (characters)';
                $aCheckN['size'] = 'Width on form (characters)';
                $aCheckN['maxlength'] = 'Maximum input length (characters)';
                break;
            case 'int':
                $aCheckM['size'] = 'Width on form (characters)';
                $aCheckM['maxlength'] = 'Maximum input length (characters)';
                $aCheckN['size'] = 'Width on form (characters)';
                $aCheckN['maxlength'] = 'Maximum input length (characters)';
                break;
            case 'textarea':
                $aCheckM['cols'] = 'Width on form (characters)';
                $aCheckM['rows'] = 'Height on form (lines)';
                $aCheckN['cols'] = 'Width on form (characters)';
                $aCheckN['rows'] = 'Height on form (lines)';
                break;
            case 'select':
                $aCheckM['select_options'] = 'List of possible options';
                break;
            case 'select_multiple':
                $aCheckM['rows'] = 'Height on form (lines)';
                $aCheckM['select_options'] = 'List of possible options';
                $aCheckN['rows'] = 'Height on form (lines)';
                break;
        }

        // Mandatory fields...
        foreach ($aCheckM as $key => $val) {
            if (!$_POST[$key]) {
                lovd_errorAdd('Please fill in the \'' . $val . '\' field.');
            }
        }

        // Numeric fields...
        foreach ($aCheckN as $key => $val) {
            if ($_POST[$key] && (!is_numeric($_POST[$key]) || $_POST[$key] < 0)) {
                lovd_errorAdd('The \'' . $val . '\' field has to contain a positive numeric value.');
            }
        }

        // FIXME; add proper check on proper PHP Perl-compatible regexp syntax.
        // Check regexp syntax.
        if (!empty($_POST['preg_pattern']) && !preg_match('/^\/.+\/[imsxeADSUXu]*$/', $_POST['preg_pattern'])) {
            lovd_errorAdd('The \'' . $val . '\' field does not seem to contain valid PHP Perl compatible regexp syntax.');
        }

        // Select_options.
        if (!empty($_POST['select_options'])) {
            $aOptions = explode("\r\n", $_POST['select_options']);
            foreach ($aOptions as $n => $sOption) {
                if (!preg_match('/^([^=]+|[A-Z0-9 \/\()?_+-]+ *= *[^=]+)$/i', $sOption)) {
                    lovd_errorAdd('Select option #' . ($n + 1) . ' &quot;' . htmlspecialchars($sOption) . '&quot; not understood.');
                }
            }
        }

        if (!lovd_error()) {
            // Build proper values and send them through.
            $sMySQLType = '';
            $sFormType = '';
            $sPregPattern = '';

            // Store vars in $_SESSION...
            $aStore = array('name', 'size', 'maxlength', 'preg_pattern', 'unsigned', 'cols', 'rows', 'select', 'select_options', 'select_all');
            foreach ($aStore as $val) {
                if (!isset($_POST[$val])) {
                    $_POST[$val] = '';
                }
                $_SESSION['form_type'][$val] = $_POST[$val];
            }

            // Thank the user...
            require ROOT_PATH . 'inc-top-clean.php';
            lovd_printHeader('setup_columns_manage_defaults', 'LOVD Setup - Manage custom column defaults');
            print('      Done! Gathering info and sending you through to the form...<BR><BR>' . "\n\n");

            // MySQL and Form type.
            switch ($_POST['form_type']) {
                case 'text':
                    if ($_POST['maxlength'] > 255) {
                        $sMySQLType = 'TEXT';
                    } else {
                        $sMySQLType = 'VARCHAR(' . $_POST['maxlength'] . ')';
                    }
                    $sFormType = $_POST['name'] . '|text|' . $_POST['size'];
                    $sPregPattern = $_POST['preg_pattern'];
                    break;
                case 'int':
                    // FIXME; doesn't seem very efficient.
                    if ($_POST['unsigned']) {
                        if ($_POST['maxlength'] < 3) {
                            $sMySQLType = 'TINY';
                        } elseif ($_POST['maxlength'] < 5) {
                            $sMySQLType = 'SMALL';
                        } elseif ($_POST['maxlength'] < 8) {
                            $sMySQLType = 'MEDIUM';
                        } elseif ($_POST['maxlength'] < 10) {
                            $sMySQLType = '';
                        } else {
                            $sMySQLType = 'BIG';
                        }
                        $sMySQLType .= 'INT(' . ($_POST['maxlength'] > 19? 19 : $_POST['maxlength']) . ') UNSIGNED';
                    } else {
                        if ($_POST['maxlength'] < 3) {
                            $sMySQLType = 'TINY';
                        } elseif ($_POST['maxlength'] < 5) {
                            $sMySQLType = 'SMALL';
                        } elseif ($_POST['maxlength'] < 7) {
                            $sMySQLType = 'MEDIUM';
                        } elseif ($_POST['maxlength'] < 10) {
                            $sMySQLType = '';
                        } else {
                            $sMySQLType = 'BIG';
                        }
                        $sMySQLType .= 'INT(' . ($_POST['maxlength'] > 18? 18 : $_POST['maxlength']) . ')';
                    }
                    $sFormType = $_POST['name'] . '|text|' . $_POST['size'];
                    break;
                case 'textarea':
                    $sMySQLType = 'TEXT';
                    $sFormType = $_POST['name'] . '|textarea|' . $_POST['cols'] . '|' . $_POST['rows'];
                    break;
                case 'select':
                    // Don't bother to check the maximum value length.
                    // By the way, one could change the select_options without
                    // changing the MySQL type (Variant columns).
                    $sMySQLType = 'VARCHAR(75)';
                    $sFormType = $_POST['name'] . '|select|1|' . ($_POST['select']? 'true' : 'false') . '|false|false';
                    break;
                case 'select_multiple':
                    $sMySQLType = 'TEXT';
                    $sFormType = $_POST['name'] . '|select|' . $_POST['rows'] . '|false|true|' . ($_POST['select_all']? 'true' : 'false');
                    break;
                case 'checkbox':
                    $sMySQLType = 'TINYINT(1) UNSIGNED';
                    // FIXME; allow option to choose from V or X?
                    $sFormType = $_POST['name'] . '|checkbox|1';
                    break;
            }

            // Pass it on to the opener...
            print('      <SCRIPT type="text/javascript">' . "\n" .
                  '        <!--' . "\n" .
                  '        opener.document.forms[0][\'mysql_type\'].value = \'' . addslashes($sMySQLType) . '\';' . "\n" .
                  '        opener.document.forms[0][\'form_type\'].value = \'' . addslashes($sFormType) . '\';' . "\n" .
                  '        opener.document.forms[0][\'preg_pattern\'].value = \'' . addslashes($sPregPattern) . '\';' . "\n" .
                  '        opener.document.forms[0][\'select_options\'].value = \'' . (!empty($_POST['select_options'])? str_replace(array("\r\n", "\r", "\n"), array('\r\n', '\r', '\n'), addslashes($_POST['select_options'])) : '') . '\';' . "\n" .
                  '        self.close();' . "\n" .
                  '        // -->' . "\n" .
                  '      </SCRIPT>' . "\n\n");

            // Script up there should suffice actually...
            print('      <BUTTON onclick="javascript:self.close();">Close window</BUTTON><BR>' . "\n\n");

            require ROOT_PATH . 'inc-bot-clean.php';
            exit;

        } else {
            // Fouten, dus de zooi moet terug naar het formulier.
            lovd_magicUnquoteAll();

            // Omdat het geheel terug gaat naar het formulier, moet ik de password fields wel weghalen!
            unset($_POST['password']);
        }

    } else {
        // Default values.
        $_POST['name'] = $_SESSION['form_type']['name'];

        switch ($_POST['form_type']) {
            case 'text':
                $_POST['size'] = ($_SESSION['form_type']['size']? $_SESSION['form_type']['size'] : '30');
                $_POST['maxlength'] = ($_SESSION['form_type']['maxlength']? $_SESSION['form_type']['maxlength'] : '255');
                $_POST['preg_pattern'] = ($_SESSION['form_type']['preg_pattern']? $_SESSION['form_type']['preg_pattern'] : '');
                break;
            case 'int':
                $_POST['size'] = ($_SESSION['form_type']['size']? $_SESSION['form_type']['size'] : '10');
                $_POST['maxlength'] = ($_SESSION['form_type']['maxlength']? $_SESSION['form_type']['maxlength'] : '8');
                $_POST['unsigned'] = ($_SESSION['form_type']['unsigned']? $_SESSION['form_type']['unsigned'] : '0');
                break;
            case 'textarea':
                $_POST['cols'] = ($_SESSION['form_type']['cols']? $_SESSION['form_type']['cols'] : '40');
                $_POST['rows'] = ($_SESSION['form_type']['rows']? $_SESSION['form_type']['rows'] : '4');
                break;
            case 'select':
                $_POST['select'] = ($_SESSION['form_type']['select']? $_SESSION['form_type']['select'] : '1');
                $_POST['select_options'] = ($_SESSION['form_type']['select_options']? $_SESSION['form_type']['select_options'] : '');
                break;
            case 'select_multiple':
                $_POST['rows'] = ($_SESSION['form_type']['rows']? $_SESSION['form_type']['rows'] : '4');
                $_POST['select_all'] = ($_SESSION['form_type']['select_all']? $_SESSION['form_type']['select_all'] : '0');
                $_POST['select_options'] = ($_SESSION['form_type']['select_options']? $_SESSION['form_type']['select_options'] : '');
                break;
        }
    }



    require ROOT_PATH . 'inc-top-clean.php';
    lovd_printHeader('setup_columns_manage_defaults', 'LOVD Setup - Manage custom column defaults');

    lovd_errorPrint();

    // Table.
    print('      <FORM action="' . $_SERVER['PHP_SELF'] . '?action=' . $_GET['action'] . '&amp;sent=true" method="post">' . "\n" .
          '        <INPUT type="hidden" name="form_type" value="' . $_POST['form_type'] . '">' . "\n" .
          '        <TABLE border="0" cellpadding="0" cellspacing="1" width="760">');

    // Array which will make up the form table.
    $aForm = array(
                    array('POST', '', '', '40%', '60%'),
                    array('', 'print', '<B>Column options</B>'),
                    array('Column name on form', 'text', 'name', 30),
                  );

    // Form depends on chosen form type.
    switch ($_POST['form_type']) {
        case 'text':
            $aForm[] = array('Width on form (characters)', 'text', 'size', 5);
            $aForm[] = array('Maximum input length (characters)', 'text', 'maxlength', 5);
            $aForm[] = array('Regular expression pattern (optional)', 'text', 'preg_pattern', 20);
            $aForm[] = array('', 'print', '<SPAN class="form_note">Note: for advanced users only. Type in a full regular expression pattern (PHP\'s Perl-compatible regexp syntax), including \'/\' delimiters and possible modifiers. Make sure it\'s valid, otherwise you risk getting all input rejected.</SPAN>');
            break;
        case 'int':
            $aForm[] = array('Width on form (characters)', 'text', 'size', 5);
            $aForm[] = array('Maximum input length (characters)', 'text', 'maxlength', 5);
            $aForm[] = array('Allow only positive values', 'checkbox', 'unsigned', 1);
            break;
        case 'textarea':
            $aForm[] = array('Width on form (characters)', 'text', 'cols', 5);
            $aForm[] = array('Height on form (lines)', 'text', 'rows', 5);
            break;
        case 'select':
            $aForm[] = array('Provide "-- select --" option', 'checkbox', 'select', 1);
            $aForm[] = array('', 'print', '<SPAN class="form_note">This will add an option called "-- select --" that will be regarded as an empty value.</SPAN>');
            $aForm[] = array('List of possible options', 'print', '<TEXTAREA name="select_options" cols="70" rows="5" class="S11">' . $_POST['select_options'] . '</TEXTAREA>');
            $aForm[] = array('', 'print', '<SPAN class="form_note">This is used to build the available options for the selection list.<BR>One option per line.<BR>If you want to use abbreviations, use: Abbreviation = Long name<BR>Example: &quot;DMD = Duchenne Muscular Dystrophy&quot;</SPAN>');
            break;
        case 'select_multiple':
            $aForm[] = array('Height on form (lines)', 'text', 'rows', 5);
            $aForm[] = array('Provide "select all" link', 'checkbox', 'select_all', 1);
            $aForm[] = array('', 'print', '<SPAN class="form_note">This will add a link next to the selection list that allows the user to instantly select all available options.</SPAN>');
            $aForm[] = array('List of possible options', 'print', '<TEXTAREA name="select_options" cols="70" rows="5" class="S11">' . $_POST['select_options'] . '</TEXTAREA>');
            $aForm[] = array('', 'print', '<SPAN class="form_note">This is used to build the available options for the selection list.<BR>One option per line.<BR>If you want to use abbreviations, use: Abbreviation = Long name<BR>Example: &quot;DMD = Duchenne Muscular Dystrophy&quot;</SPAN>');
            break;
    }

    $aForm[] = 'skip';
    $aForm[] = array('', 'submit', 'Finish');
    $_MODULES->processForm('SetupColumnsGlobalFinish', $aForm);
    lovd_viewForm($aForm);

    print('</TABLE></FORM>' . "\n\n");

    require ROOT_PATH . 'inc-bot-clean.php';
    exit;





} elseif ($_GET['action'] == 'create') {
    // Create brand new custom column.

    // Require form functions.
    require ROOT_PATH . 'inc-lib-form.php';

    if (isset($_GET['sent'])) {
        lovd_errorClean();

        // Verplichte velden met de bijbehorende namen.
        $aCheck =
                 array(
                        'col_cat' => 'Category',
                        'colid' => 'Column ID',
                        'head_column' => 'Column heading',
                        'description_legend_short' => 'Description on short legend',
                        'description_legend_full' => 'Description on full legend',
                        'mysql_type' => 'MySQL data type',
                        'form_type' => 'Form type',
                        'password' => 'Enter your password for authorization',
                      );

        foreach ($aCheck as $key => $val) {
            if (!$_POST[$key]) {
                lovd_errorAdd('Please fill in the \'' . $val . '\' field.');
            }
        }

        // ColID format.
        if ($_POST['colid'] && !preg_match('/^[A-Za-z0-9_]+(\/[A-Za-z0-9_]+)*$/', $_POST['colid'])) {
            lovd_errorAdd('The column ID is not of the correct format. It can contain only letters, numbers and underscores. Subcategories must be devided by a slash (/).');
        }

        // ColID must not exist in the database.
        if ($_POST['col_cat'] && $_POST['colid']) {
            list($n) = mysql_fetch_row(mysql_query('SELECT COUNT(*) FROM ' . TABLE_COLS . ' WHERE colid = "' . $_POST['col_cat'] . '/' . $_POST['colid'] . '"'));
            if ($n) {
                lovd_errorAdd('There is already a ' . $_POST['col_cat'] . ' column with this column ID. Please choose another one.');
            }
        }

        // FIXME; are we just assuming that select_options, preg_pattern and form_format are OK?

        // MySQL type format.
        if ($_POST['mysql_type'] && !preg_match('/^TEXT|VARCHAR\([0-9]{1,3}\)|(TINY|SMALL|MEDIUM|BIG)?INT\([0-9]{1,2}\)( UNSIGNED)?$/', $_POST['mysql_type'])) {
            lovd_errorAdd('The MySQL data type is not recognized. Please use the data type wizard to generate a proper MySQL data type.');
        }

        // User had to enter his/her password for authorization.
        if ($_POST['password'] && md5($_POST['password']) != $_AUTH['password']) {
            lovd_errorAdd('Please enter your correct password for authorization.');
        }

        if (!lovd_error()) {
            // Query text.
            $sQ = 'INSERT INTO ' . TABLE_COLS . ' VALUES (';

            $_POST['colid'] = $_POST['col_cat'] . '/' . $_POST['colid'];
            $_POST['hgvs'] = '0';

            // Standard fields to be used.
            $aQ = array('colid', 'hgvs', 'standard', 'mandatory', 'head_column', 'description_form', 'description_legend_short', 'description_legend_full', 'mysql_type', 'form_type', 'select_options', 'preg_pattern', 'public', 'public_form');

            foreach ($aQ as $key => $val) {
                $sQ .= ($key? ', ' : '') . '"' . $_POST[$val] . '"';
            }

            $sQ .= ', ' . $_AUTH['userid'] . ', NOW(), NULL, NULL)';

            $q = mysql_query($sQ);
            if (!$q) {
                require ROOT_PATH . 'inc-top.php';
                lovd_printHeader('setup_columns_create', 'LOVD Setup - Create new custom column');
                lovd_dbFout('ColCreate', $sQ, mysql_error());
            }

            // Clean up...
            $_SESSION['form_type'] = array();

            // Write to log...
            lovd_writeLog('MySQL:Event', 'ColCreate', $_AUTH['username'] . ' (' . mysql_real_escape_string($_AUTH['name']) . ') successfully created column ' . $_POST['colid'] . ' (' . $_POST['head_column'] . ')');

            // Thank the user...
            header('Refresh: 3; url=http://' . $_SERVER['HTTP_HOST'] . $_SERVER['PHP_SELF'] . '?action=view&view=' . rawurlencode($_POST['colid']) . lovd_showSID(true));

            require ROOT_PATH . 'inc-top.php';
            lovd_printHeader('setup_columns_create', 'LOVD Setup - Create new custom column');
            print('      Column "' . $_POST['head_column'] . '" has successfully been created!<BR><BR>' . "\n\n");

            require ROOT_PATH . 'inc-bot.php';
            exit;

        } else {
            // Fouten, dus de zooi moet terug naar het formulier.
            lovd_magicUnquoteAll();

            // Omdat het geheel terug gaat naar het formulier, moet ik de password fields wel weghalen!
            unset($_POST['password']);
        }

    } else {
        // Default values.
        $_POST['public'] = 1;
        $_POST['public_form'] = 1;
        $_POST['select_options'] = '';
        $_POST['preg_pattern'] = '';

        // Default data type information, loaded in SESSION.
        $_SESSION['form_type'] =
                 array(
                        'form_type' => '',
                        'name' => '',
                        'size' => '',
                        'maxlength' => '',
                        'preg_pattern' => '',
                        'unsigned' => '',
                        'cols' => '',
                        'rows' => '',
                        'select' => '',
                        'select_options' => '',
                        'select_all' => '',
                      );
    }



    require ROOT_PATH . 'inc-top.php';
    lovd_printHeader('setup_columns_create', 'LOVD Setup - Create new custom column');

    lovd_errorPrint();

    // Table.
    print('      <FORM action="' . $_SERVER['PHP_SELF'] . '?action=' . $_GET['action'] . '&amp;sent=true" method="post">' . "\n" .
          '        <INPUT type="hidden" name="select_options" value="' . $_POST['select_options'] . '">' . "\n" .
          '        <INPUT type="hidden" name="preg_pattern" value="' . $_POST['preg_pattern'] . '">' . "\n" .
          '        <TABLE border="0" cellpadding="0" cellspacing="1" width="760">');

    // Array which will make up the form table.
    $aForm = array(
                    array('POST', '', '', '50%', '50%'),
                    array('', 'print', '<B>Column name and descriptions</B>'),
                    array('Category', 'select', 'col_cat', 1, array('Patient' => 'Patient', 'Variant' => 'Variant'), true, false, false),
                    array('Column ID', 'text', 'colid', 30),
                    array('', 'print', '<SPAN class="form_note">This ID must be unique and may contain only letters, numbers and underscores. Subcategories must be divided by a slash (/), such as \'Phenotype/Disease\'.</SPAN>'),
                    array('Column heading', 'text', 'head_column', 30),
                    array('', 'print', '<SPAN class="form_note">This will appear above the column on data listings and the legend.</SPAN>'),
                    array('Description on form', 'textarea', 'description_form', 40, 2),
                    array('Description on short legend', 'textarea', 'description_legend_short', 40, 2),
                    array('Description on full legend', 'textarea', 'description_legend_full', 40, 2),
                    'skip',
                    array('', 'print', '<B>Data settings</B> (Use data type wizard to change values)'),
                    array('', 'print', '<BUTTON onclick="javascript:lovd_openWindow(\'' . $_SERVER['PHP_SELF'] . '?action=form_type_define' . lovd_showSID(true) . '\', \'FormTypeDefine\', 800, 400); return false;">Start data type wizard</BUTTON>'),
                    array('MySQL data type', 'text', 'mysql_type', 20),
                    array('Form type', 'text', 'form_type', 30),
                    'skip',
                    array('', 'print', '<B>Column settings</B>'),
                    array('Standard for new genes (Variant columns only)', 'checkbox', 'standard', 1),
                    array('Mandatory field', 'checkbox', 'mandatory', 1),
                    array('Show contents to public', 'checkbox', 'public', 1),
                    array('Show field on public forms', 'checkbox', 'public_form', 1),
                    'skip',
                    array('Enter your password for authorization', 'password', 'password', 20),
                    array('', 'submit', 'Create column'),
                  );
    $_MODULES->processForm('SetupColumnsGlobalCreate', $aForm);
    lovd_viewForm($aForm);

    print('</TABLE></FORM>' . "\n\n");

    require ROOT_PATH . 'inc-bot.php';
    exit;





} elseif ($_GET['action'] == 'edit' && !empty($_GET['edit'])) {
    // Edit specific custom column.

    $zData = @mysql_fetch_assoc(mysql_query('SELECT * FROM ' . TABLE_COLS . ' WHERE colid = "' . $_GET['edit'] . '"'));
    if (!$zData) {
        // Wrong ID, apparently.
        require ROOT_PATH . 'inc-top.php';
        lovd_printHeader('setup_columns_manage_defaults', 'LOVD Setup - Manage custom column defaults');
        lovd_showInfoTable('No such ID!', 'stop');
        require ROOT_PATH . 'inc-bot.php';
        exit;
    }

    // Require form functions.
    require ROOT_PATH . 'inc-lib-form.php';

    if (isset($_GET['sent'])) {
        lovd_errorClean();

        // Verplichte velden met de bijbehorende namen.
        $aCheck =
                 array(
                        'head_column' => 'Column heading',
                        'description_legend_short' => 'Description on short legend',
                        'description_legend_full' => 'Description on full legend',
                        'mysql_type' => 'MySQL data type',
                        'form_type' => 'Form type',
                        'password' => 'Enter your password for authorization',
                      );

        foreach ($aCheck as $key => $val) {
            if (!$_POST[$key]) {
                lovd_errorAdd('Please fill in the \'' . $val . '\' field.');
            }
        }

        // FIXME; are we just assuming that select_options, preg_pattern and form_format are OK?

        // MySQL type format.
        if ($_POST['mysql_type'] && !preg_match('/^TEXT|VARCHAR\([0-9]{1,3}\)|(TINY|SMALL|MEDIUM|BIG)?INT\([0-9]{1,2}\)( UNSIGNED)?$/', $_POST['mysql_type'])) {
            lovd_errorAdd('The MySQL data type is not recognized. Please use the data type wizard to generate a proper MySQL data type.');
        }

        // User had to enter his/her password for authorization.
        if ($_POST['password'] && md5($_POST['password']) != $_AUTH['password']) {
            lovd_errorAdd('Please enter your correct password for authorization.');
        }

        if (!lovd_error()) {
            // FIXME; Warning if MySQL type has been changed... possibly loss of data will occur.

            // First, alter all tables who have this column. Less problematic if things go wrong.
            if ($zData['mysql_type'] != $_POST['mysql_type']) {
                // Type changed... take action!
                $aSQL = array();
                if (substr($zData['colid'], 0, 7) == 'Variant') {
                    // Check genes to find if column is active.
                    $qGenes = mysql_query('SELECT symbol FROM ' . TABLE_DBS . ' ORDER BY symbol');
                    while ($rGenes = mysql_fetch_row($qGenes)) {
                        list($b) = mysql_fetch_row(mysql_query('SELECT colid FROM ' . TABLEPREFIX . '_' . $rGenes[0] . '_columns WHERE colid = "' . $zData['colid'] . '"'));
                        if ($b) {
                            // Column present in this gene.
                            $aSQL[TABLEPREFIX . '_' . $rGenes[0] . '_variants'] = 'ALTER TABLE ' . TABLEPREFIX . '_' . $rGenes[0] . '_variants MODIFY COLUMN `' . $zData['colid'] . '` ' . $_POST['mysql_type'] . ' NOT NULL';
                        }
                    }

                } else {
                    // Patient column.
                    list($b) = mysql_fetch_row(mysql_query('SELECT colid FROM ' . TABLE_PATIENTS_COLS . ' WHERE colid = "' . $zData['colid'] . '"'));
                    if ($b) {
                        // Column present in patient table.
                        $aSQL[TABLE_PATIENTS] = 'ALTER TABLE ' . TABLE_PATIENTS . ' MODIFY COLUMN `' . $zData['colid'] . '` ' . $_POST['mysql_type'] . ' NOT NULL';
                    }
                }

                // If we've got any entries in $aSQL, go ahead...
                $nSQL = count($aSQL);
                if ($nSQL) {
                    // Loop needed queries...
                    foreach ($aSQL as $sTable => $sQ) {
                        $q = mysql_query($sQ);
                        if (!$q) {
                            require ROOT_PATH . 'inc-top.php';
                            lovd_printHeader('setup_columns_manage_defaults', 'LOVD Setup - Manage custom column defaults');
                            lovd_dbFout('ColEditError', $sQ, mysql_error(), false);
                            // FIXME; this 'error log' is actually error.log; those errors should really go into the db error log.
                            lovd_showInfoTable('Error while modifying ' . $sTable . ' table!<BR>This may indicate an error in the MySQL data definition. For more information, see the error log.', 'warning');
                            lovd_showInfoTable('Unfortunately, due to an error I cannot continue to edit the column. Your changes are lost.', 'stop');
                            require ROOT_PATH . 'inc-bot.php';
                            exit;
                        }
                    }
                }
            }



            // Query text.
            $sQ = 'UPDATE ' . TABLE_COLS . ' SET ';

            // Standard fields to be used.
            $aQ = array('standard', 'mandatory', 'head_column', 'description_form', 'description_legend_short', 'description_legend_full', 'mysql_type', 'form_type', 'select_options', 'preg_pattern', 'public', 'public_form');

            foreach ($aQ as $key => $val) {
                $sQ .= ($key? ', ' : '') . $val . ' = "' . $_POST[$val] . '"';
            }

            $sQ .= ', edited_by = "' . $_AUTH['userid'] . '", edited_date = NOW() WHERE colid = "' . $zData['colid'] . '"';

            $q = mysql_query($sQ);
            if (!$q) {
                require ROOT_PATH . 'inc-top.php';
                lovd_printHeader('setup_columns_manage_defaults', 'LOVD Setup - Manage custom column defaults');
                lovd_dbFout('ColEdit', $sQ, mysql_error());
            }

            // Clean up...
            $_SESSION['form_type'] = array();

            // Write to log...
            lovd_writeLog('MySQL:Event', 'ColEdit', $_AUTH['username'] . ' (' . mysql_real_escape_string($_AUTH['name']) . ') successfully edited column ' . $zData['colid'] . ' (' . $_POST['head_column'] . ')');

            // Thank the user...
            header('Refresh: 3; url=http://' . $_SERVER['HTTP_HOST'] . $_SERVER['PHP_SELF'] . '?action=view&view=' . rawurlencode($_GET['edit']) . lovd_showSID(true));

            require ROOT_PATH . 'inc-top.php';
            lovd_printHeader('setup_columns_manage_defaults', 'LOVD Setup - Manage custom column defaults');
            print('      Successfully edited column \'' . $zData['colid'] . '\'!<BR>' .
                  ($zData['mysql_type'] != $_POST['mysql_type'] && $nSQL? 'Modified ' . $nSQL . ' data table' . ($nSQL == 1? '.' : 's.') : '') .
                  '<BR>' . "\n\n");

            require ROOT_PATH . 'inc-bot.php';
            exit;

        } else {
            // Errors, so the whole lot returns to the form.
            lovd_magicUnquoteAll();

            // Because we're sending the data back to the form, I need to unset the password fields!
            unset($_POST['password']);
        }

    } else {
        foreach ($zData as $key => $val) {
            if (!isset($_POST[$key]) || !$_POST[$key]) {
                $_POST[$key] = $val;
            }
        }
        $_POST['password'] = '';

        // Default data type information, loaded in SESSION.
        $aFormType = explode('|', $zData['form_type']);
        $_SESSION['form_type'] =
                 array(
                        'form_type' => '',
                        'name' => $aFormType[0],
                        'size' => '',
                        'maxlength' => '',
                        'preg_pattern' => $zData['preg_pattern'],
                        'unsigned' => '',
                        'cols' => '',
                        'rows' => '',
                        'select' => '',
                        'select_options' => $zData['select_options'],
                        'select_all' => '',
                      );

        // Load $_SESSION['form_type'] with current data from form_type and mysql_type.
        switch ($aFormType[1]) {
            case 'text':
                // VARCHAR, TEXT or INT columns.
                $_SESSION['form_type']['size'] = $aFormType[2];
                if (preg_match('/^VARCHAR\(([0-9]+)\)/', $zData['mysql_type'], $aRegs)) {
                    $_SESSION['form_type']['form_type'] = 'text';
                    $_SESSION['form_type']['maxlength'] = $aRegs[1];
                } elseif (substr($zData['mysql_type'], 0, 4) == 'TEXT') {
                    $_SESSION['form_type']['form_type'] = 'text';
                    $_SESSION['form_type']['maxlength'] = 65535;
                } elseif (preg_match('/^(TINY|SMALL|MEDIUM|BIG)?INT\(([0-9]+)\) *(UNSIGNED)?/', $zData['mysql_type'], $aRegs)) {
                    $_SESSION['form_type']['form_type'] = 'int';
                    $_SESSION['form_type']['maxlength'] = $aRegs[1];
                    $_SESSION['form_type']['unsigned']  = (!empty($aRegs[2])? 1 : 0);
                } else {
                    // Should not happen.
                    $_SESSION['form_type']['form_type'] = 'text';
                }
                break;
            case 'textarea':
                // TEXT column.
                $_SESSION['form_type']['form_type'] = 'textarea';
                $_SESSION['form_type']['cols']      = $aFormType[2];
                $_SESSION['form_type']['rows']      = $aFormType[3];
                break;
            case 'select':
                // VARCHAR or TEXT columns.
                if ($aFormType[4] == 'false') {
                    $_SESSION['form_type']['form_type'] = 'select';
                    $_SESSION['form_type']['select']    = ($aFormType[3] == 'false'? 0 : 1);
                } else {
                    $_SESSION['form_type']['form_type']  = 'select_multiple';
                    $_SESSION['form_type']['rows']       = $aFormType[2];
                    $_SESSION['form_type']['select']     = ($aFormType[3] == 'false'? 0 : 1);
                    $_SESSION['form_type']['select_all'] = ($aFormType[5] == 'false'? 0 : 1);
                }
                break;
            case 'checkbox':
                // TINYINT(1) UNSIGNED column.
                $_SESSION['form_type']['form_type']  = 'checkbox';
                break;
        }
    }



    require ROOT_PATH . 'inc-top.php';
    lovd_printHeader('setup_columns_manage_defaults', 'LOVD Setup - Manage custom column defaults');

    lovd_errorPrint();

    // Table.
    print('      <FORM action="' . $_SERVER['PHP_SELF'] . '?action=' . $_GET['action'] . '&amp;edit=' . rawurlencode($zData['colid']) . '&amp;sent=true" method="post">' . "\n" .
          '        <INPUT type="hidden" name="select_options" value="' . $_POST['select_options'] . '">' . "\n" .
          '        <INPUT type="hidden" name="preg_pattern" value="' . $_POST['preg_pattern'] . '">' . "\n" .
          '        <TABLE border="0" cellpadding="0" cellspacing="1" width="760">');

    // Array which will make up the form table.
    $aForm = array(
                    array('POST', '', '', '50%', '50%'),
                    array('', 'print', '<B>Column name and descriptions</B>'),
                    array('Column heading', 'text', 'head_column', 30),
                    array('', 'print', '<SPAN class="form_note">This will appear above the column on data listings and the legend.</SPAN>'),
                    array('Description on form', 'textarea', 'description_form', 40, 2),
                    array('Description on short legend', 'textarea', 'description_legend_short', 40, 2),
                    array('Description on full legend', 'textarea', 'description_legend_full', 40, 2),
                    'skip',
                    array('', 'print', '<B>Data settings</B> (Use data type wizard to change values)'),
                    array('', 'print', '<BUTTON onclick="javascript:lovd_openWindow(\'' . $_SERVER['PHP_SELF'] . '?action=form_type_define' . lovd_showSID(true) . '\', \'FormTypeDefine\', 800, 400); return false;">Start data type wizard</BUTTON>'),
                    array('MySQL data type', 'text', 'mysql_type', 20),
                    array('Form type', 'text', 'form_type', 30),
                    'skip',
                    array('', 'print', '<B>Column settings</B>'),
                    array('Standard for new genes (Variant columns only)', 'checkbox', 'standard', 1),
                    array('Mandatory field', 'checkbox', 'mandatory', 1),
                    array('Show contents to public', 'checkbox', 'public', 1),
                    array('Show field on public forms', 'checkbox', 'public_form', 1),
                    'skip',
                    array('Enter your password for authorization', 'password', 'password', 20),
                    array('', 'submit', 'Edit settings'),
                  );
    $_MODULES->processForm('SetupColumnsGlobalEdit', $aForm);
    lovd_viewForm($aForm);

    print('</TABLE></FORM>' . "\n\n");

    require ROOT_PATH . 'inc-bot.php';
    exit;





} else {
    // Default action:
    header('Location: http://' . $_SERVER['HTTP_HOST'] . $_SERVER['PHP_SELF'] . '?action=view_all' . lovd_showSID(true));
    exit;
}
?>