<?php
/*******************************************************************************
 *
 * LEIDEN OPEN VARIATION DATABASE (LOVD)
 *
 * Created     : 2006-05-11
 * Modified    : 2008-02-28
 * For LOVD    : 2.0-04
 *
 * Access      : Public
 * Purpose     : Include SQL to create the standard LOVD culumns.
 *
 * Copyright   : 2004-2008 Leiden University Medical Center; http://www.LUMC.nl/
 * Programmer  : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *
 * This file is part of LOVD.
 *
 * LOVD is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * LOVD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LOVD; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *************/

$aColSQL =
         array(
                'Variant/Location' => 'INSERT INTO ' . TABLE_COLS . ' VALUES (
                    "Variant/Location", 0, 0, 1, "Location", "", "Variant location at DNA level.", "Variant location at DNA level.", "VARCHAR(16)", "Location|select|1|true|false|false", "5\' Gene flanking\r\n5\' UTR\r\nExon\r\nIntron\r\n3\' UTR\r\n3\' Gene flanking", "", 1, 1, 0, NOW(), NULL, NULL)',
                'Variant/Exon' => 'INSERT INTO ' . TABLE_COLS . ' VALUES (
                    "Variant/Exon", 0, 1, 1, "Exon", "Please pad the exon number with a zero for ordering purposes, i.e. \'02\' in stead of \'2\'", "Exon numbering.", "Exon numbering.", "VARCHAR(3)", "Exon|text|3", "", "", 1, 1, 0, NOW(), NULL, NULL)',
                'Variant/Type' => 'INSERT INTO ' . TABLE_COLS . ' VALUES (
                    "Variant/Type", 0, 0, 1, "Type", "", "Type of variant at DNA level.", "Type of variant at DNA level.", "VARCHAR(20)", "Type of variant (DNA level)|select|1|false|false|false", "Substitution\r\nDeletion\r\nDuplication\r\nInsertion\r\nInversion\r\nInsertion/Deletion\r\nTranslocation\r\nOther/Complex", "", 1, 1, 0, NOW(), NULL, NULL)',
                'Variant/DNA' => 'INSERT INTO ' . TABLE_COLS . ' VALUES (
                    "Variant/DNA", 1, 1, 1, "DNA change", "", "Variation at DNA-level. If present, \"Full Details\" will show you the the full-length entry.", "Variation at DNA level.", "VARCHAR(100)", "DNA change (HGVS format)|text|30", "", "", 1, 1, 0, NOW(), NULL, NULL)',
                'Variant/RNA' => 'INSERT INTO ' . TABLE_COLS . ' VALUES (
                    "Variant/RNA", 1, 1, 0, "RNA change", "", "Variation at RNA-level, (?) unknown but probably identical to DNA.", "Effect of change on RNA.<BR>\r\n<UL style=\"margin-top : 0px;\">\r\n  <LI>= = RNA change identical to DNA change</LI>\r\n  <LI>? = unknown</LI>\r\n  <LI>(=) = no significant effect expected (but no experimental proof)</LI>\r\n  <LI>(0) = change expected to abolish transcription</LI>\r\n  <LI>(ex4ex5del) = probably deletion of exons 4 to 5</LI>\r\n  <LI>(ex4ex5dup) = probably duplication of exons 4 to 5</LI>\r\n <LI>+cry = activation of cryptic splice site (no sequence published)</LI>\r\n  <LI>spl? = effect on splicing very likely (no experimental proof), examples;</LI>\r\n  <UL>\r\n    <LI>splice donor site change (nucleotides +1 to +5 affected)</LI>\r\n    <LI>splice acceptor site change (nucleotides -2 to -1 affected)</LI>\r\n    <LI>new intronic AG splice acceptor di-nucleotide created close to (within 15 nucleotides) of normal splice acceptor site</LI>\r\n  </UL>\r\n  <LI>(spl?) = might affect splicing (no experimental proof), examples;</LI>\r\n  <UL>\r\n    <LI>change affects first or last nucleotide of exon</LI>\r\n    <LI>change creates strong splice donor or splice acceptor site in exon</LI>\r\n  </UL>\r\n</UL>", "VARCHAR(100)", "RNA change (HGVS format)|text|30", "", "", 1, 1, 0, NOW(), NULL, NULL)',
                'Variant/Protein' => 'INSERT INTO ' . TABLE_COLS . ' VALUES (
                    "Variant/Protein", 1, 1, 0, "Protein", "", "Variation at protein level.", "Predicted effect of change on protein (usually without experimental proof!)<BR>\r\n<UL style=\"margin-top : 0px;\">\r\n  <LI>? = unknown</LI>\r\n  <LI>(0) = change expected to abolish translation</LI>\r\n  <LI>?fs = frame shift, but observed phenotype does not fit with prediction (for instance less severe phenotype (BMD) observed, more severe phenotype (DMD) expected)</LI>\r\n  <LI>?no fs = frame shift, but observed phenotype does not fit with prediction (for instance more severe phenotype (DMD) observed, less severe phenotype (BMD) expected)</LI>\r\n  <LI>del = causes deletion</LI>\r\n  <LI>fs = causes frame shift</LI>\r\n  <LI>fs? = effect on reading frame very likely (no experimental proof)</LI>\r\n  <LI>(fs?) = might affect the reading frame (no experimental proof)</LI>\r\n  <LI>no fs = does not cause frame shift</LI>\r\n  <LI>X = stop codon (nonsense)</LI>\r\n</UL>", "VARCHAR(100)", "Protein change (HGVS format)|text|30", "", "", 1, 1, 0, NOW(), NULL, NULL)',
                'Variant/Restriction_site' => 'INSERT INTO ' . TABLE_COLS . ' VALUES (
                    "Variant/Restriction_site", 0, 1, 0, "Re-site", "", "Variant creates (+) or destroys (-) a restriction enzyme recognition site.", "Variant creates (+) or destroys (-) a restriction enzyme recognition site.", "VARCHAR(15)", "Re-site|text|10", "", "", 1, 1, 0, NOW(), NULL, NULL)',
                'Variant/Frequency' => 'INSERT INTO ' . TABLE_COLS . ' VALUES (
                    "Variant/Frequency", 0, 1, 0, "Frequency", "", "Frequency if variant is non pathogenic.", "Frequency of non pathogenic variant reported listed as number of variant alleles/number of control alleles tested, like 5/132.", "VARCHAR(15)", "Frequency|text|10", "", "", 1, 1, 0, NOW(), NULL, NULL)',
/*
                'Variant/DBID' => 'INSERT INTO ' . TABLE_COLS . ' VALUES (
                    "Variant/DBID", 1, 1, 1, "DB-ID", "The ID-field should start with the ID; the gene symbol followed by an underscore (_) and the ID code <SPAN class=\"S11\">(<A href=\"' . lovd_cleanDirName(dirname($_SERVER['PHP_SELF']) . '/' . ROOT_PATH) . 'help/about-dbid.html\" target=\"_blank\">more info</A>)</SPAN>", "<A href=\"' . lovd_cleanDirName(dirname($_SERVER['PHP_SELF']) . '/' . ROOT_PATH) . 'help/about-dbid.html\">Database IDentifier</A>; When available, links to OMIM ID\'s are provided.", "<A href=\"' . lovd_cleanDirName(dirname($_SERVER['PHP_SELF']) . '/' . ROOT_PATH) . 'help/about-dbid.html\">Database IDentifier</A>. When available, links to OMIM ID\'s are provided.", "VARCHAR(100)", "ID|text|40", "", "/^[A-Z][A-Z0-9]+_([0-9]{5}([a-z]{2})?|(SO|MP|e)[0-9]{1,2}((SO|MP|e)[0-9]{1,2})?b?)\\\\b/", 1, 0, 0, NOW(), NULL, NULL)',
*/
                'Variant/DBID' => 'INSERT INTO ' . TABLE_COLS . ' VALUES (
                    "Variant/DBID", 1, 1, 1, "DB-ID", "The ID-field should start with the ID; the gene symbol followed by an underscore (_) and the ID code, usually five digits <SPAN class=\"S11\">(<A href=\"http://www.lovd.nl/1.1.0/about-dbid.php\" target=\"_blank\">more info</A>)</SPAN>", "<A href=\"http://www.lovd.nl/1.1.0/about-dbid.php\">Database IDentifier</A>; When available, links to OMIM ID\'s are provided.", "<A href=\"http://www.lovd.nl/1.1.0/about-dbid.php\">Database IDentifier</A>. When available, links to OMIM ID\'s are provided.", "VARCHAR(100)", "ID|text|40", "", "/^[A-Z][A-Z0-9]+_([0-9]{5}([a-z]{2})?|(SO|MP|e)[0-9]{1,2}((SO|MP|e)[0-9]{1,2})?b?)\\\\b/", 1, 0, 0, NOW(), NULL, NULL)',
                'Patient/Patient_ID' => 'INSERT INTO ' . TABLE_COLS . ' VALUES (
                    "Patient/Patient_ID", 1, 1, 1, "Patient ID", "", "Internal reference to the patient.", "Internal reference to the patient, such as an hospital patient id.", "VARCHAR(15)", "Patient ID|text|10", "", "", 0, 1, 0, NOW(), NULL, NULL)',
                'Patient/Phenotype/Disease' => 'INSERT INTO ' . TABLE_COLS . ' VALUES (
                    "Patient/Phenotype/Disease", 1, 1, 0, "Disease", "", "Disease phenotype, as reported in paper/by submitter, unless modified by the curator.", "Disease phenotype of the patient(s).", "VARCHAR(50)", "Disease|select|4|false|true|false", "", "", 1, 1, 0, NOW(), NULL, NULL)',
                'Patient/Reference' => 'INSERT INTO ' . TABLE_COLS . ' VALUES (
                    "Patient/Reference", 1, 1, 0, "Reference", "", "Reference describing the variation, &quot;Submitted:&quot; indicating that the mutation was submitted directly to this database.", "Literature reference with possible link to publication in PubMed, dbSNP entry or other online resource. &quot;Submitted:&quot; indicates that the mutation was submitted directly to this database by the laboratory indicated.", "VARCHAR(200)", "Reference|text|50", "", "", 1, 1, 0, NOW(), NULL, NULL)',
                'Patient/Detection/Template' => 'INSERT INTO ' . TABLE_COLS . ' VALUES (
                    "Patient/Detection/Template", 1, 1, 1, "Template", "", "Variant detected in DNA, RNA and/or Protein.", "Variant detected in DNA, RNA and/or Protein.", "VARCHAR(20)", "Detection template|select|3|false|true|false", "DNA\r\nRNA\r\nProtein", "", 1, 1, 0, NOW(), NULL, NULL)',
                'Patient/Detection/Technique' => 'INSERT INTO ' . TABLE_COLS . ' VALUES (
                    "Patient/Detection/Technique", 1, 1, 1, "Technique", "", "Technique used to detect the variation.", "Technique used to reveal the change reported. For all methods, confirmation by sequencing (SEQ) is included. Select SEQ only when none of other techniques was used.", "VARCHAR(150)", "Technique(s) used|select|5|false|true|false", "BESS = Base Excision Sequence Scanning\r\nCMC = Chemical Mismatch Cleavage\r\nDGGE = Denaturing-Gradient Gel-Electrophoresis\r\nDHPLC = Denaturing High-Performance Liquid Chromatography\r\nDOVAM = Detection Of Virtually All Mutations (SSCA variant)\r\nDSCA = Double-Strand DNA Conformation Analysis\r\nHD = HeteroDuplex analysis\r\nIHC = Immuno-Histo-Chemistry\r\nmPCR = multiplex PCR\r\nMAPH = Multiplex Amplifiable Probe Hybridisation\r\nMLPA = Multiplex Ligation-dependent Probe Amplification\r\nPAGE = Poly-Acrylamide Gel-Electrophoresis\r\nPCR = Polymerase Chain Reaction\r\nPTT = Protein Truncation Test\r\nRT-PCR = Reverse Transcription and PCR\r\nSEQ = SEQuencing\r\nSouthern = Southern Blotting\r\nSSCA = Single-Strand DNA Conformation Analysis (SSCP)\r\nWestern = Western Blotting", "", 1, 1, 0, NOW(), NULL, NULL)',
                'Patient/Detection/Tissue' => 'INSERT INTO ' . TABLE_COLS . ' VALUES (
                    "Patient/Detection/Tissue", 0, 0, 1, "Tissue", "", "Tissue type the variant was detected in.", "Tissue type in which the sequence variant was detected.", "VARCHAR(25)", "Tissue|text|20", "", "", 1, 1, 0, NOW(), NULL, NULL)',
                'Patient/Remarks' => 'INSERT INTO ' . TABLE_COLS . ' VALUES (
                    "Patient/Remarks", 0, 1, 0, "Remarks", "", "", "", "TEXT", "Remarks|textarea|50|3", "", "", 1, 1, 0, NOW(), NULL, NULL)',
                'Patient/Remarks_Non_Public' => 'INSERT INTO ' . TABLE_COLS . ' VALUES (
                    "Patient/Remarks_Non_Public", 0, 1, 0, "Remarks (non public)", "", "", "", "TEXT", "Remarks (non public)|textarea|50|3", "", "", 0, 0, 0, NOW(), NULL, NULL)',
                'Patient/Times_Reported' => 'INSERT INTO ' . TABLE_COLS . ' VALUES (
                    "Patient/Times_Reported", 0, 1, 1, "# Reported", "", "Number of times this case has been reported", "Number of times this case has been reported", "SMALLINT(4) UNSIGNED DEFAULT 1", "Times reported|text|3", "", "", 1, 0, 0, NOW(), NULL, NULL)',
                'Patient/Occurrence' => 'INSERT INTO ' . TABLE_COLS . ' VALUES (
                    "Patient/Occurrence", 0, 0, 0, "Occurrence", "", "Occurrence", "Occurrence", "VARCHAR(8)", "Occurrence|select|1|Unknown|false|false", "Familial\r\nSporadic", "", 1, 1, 0, NOW(), NULL, NULL)',
                'Patient/Gender' => 'INSERT INTO ' . TABLE_COLS . ' VALUES (
                    "Patient/Gender", 0, 0, 0, "Gender", "", "Patient gender", "Patient gender", "VARCHAR(6)", "Gender|select|1|Unknown|false|false", "Female\r\nMale", "", 1, 1, 0, NOW(), NULL, NULL)',
                'Patient/Mutation/Origin' => 'INSERT INTO ' . TABLE_COLS . ' VALUES (
                    "Patient/Mutation/Origin", 0, 0, 0, "Mut. origin", "", "Origin of mutation", "Origin of mutation", "VARCHAR(9)", "Origin of mutation|select|1|Unknown|false|false", "De novo\r\nInherited", "", 1, 1, 0, NOW(), NULL, NULL)',
                'Patient/Mutation/Origin_De_Novo' => 'INSERT INTO ' . TABLE_COLS . ' VALUES (
                    "Patient/Mutation/Origin_De_Novo", 0, 0, 0, "De novo origin", "", "If de novo, origin of mutation", "If de novo, origin of mutation", "VARCHAR(11)", "If de novo, origin of mutation|select|1|true|false|false", "Patient\r\nFather\r\nMother\r\nGrandfather\r\nGrandmother", "", 1, 1, 0, NOW(), NULL, NULL)',
                'Patient/Origin/Geographic' => 'INSERT INTO ' . TABLE_COLS . ' VALUES (
                    "Patient/Origin/Geographic", 0, 0, 0, "Geographic origin", "", "Geographic origin of patient", "Geographic origin of the patient", "VARCHAR(50)", "Geographic origin|text|30", "", "", 1, 1, 0, NOW(), NULL, NULL)',
                'Patient/Origin/Ethnic' => 'INSERT INTO ' . TABLE_COLS . ' VALUES (
                    "Patient/Origin/Ethnic", 0, 0, 0, "Ethnic origin", "", "Ethnic origin of patient", "Ethnic origin of the patient", "VARCHAR(25)", "Ethnic origin|text|20", "", "", 1, 1, 0, NOW(), NULL, NULL)',
                'Patient/Origin/Population' => 'INSERT INTO ' . TABLE_COLS . ' VALUES (
                    "Patient/Origin/Population", 0, 0, 0, "Population", "", "Patient population", "Additional information on patient population", "VARCHAR(50)", "Patient population|text|30", "", "", 1, 1, 0, NOW(), NULL, NULL)',
              );
?>
