<?php
/*******************************************************************************
 *
 * LEIDEN OPEN VARIATION DATABASE (LOVD)
 *
 * Created     : 2006-04-21
 * Modified    : 2008-02-27
 * For LOVD    : 2.0-04
 *
 * Access      : Public
 * Purpose     : Log in the user, whether that's a submitter or a
 *               manager/administrator.
 *
 * Copyright   : 2004-2008 Leiden University Medical Center; http://www.LUMC.nl/
 * Programmer  : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *
 * This file is part of LOVD.
 *
 * LOVD is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * LOVD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LOVD; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *************/

define('ROOT_PATH', './');
require ROOT_PATH . 'inc-init.php';

// Already logged in to the system.
if ($_AUTH) {
    // Send manager and database administrator to setup, curators and submitters to the index.
    header('Location: ' . PROTOCOL . $_SERVER['HTTP_HOST'] . rtrim(dirname($_SERVER['PHP_SELF']), '/') . '/' . (HAS_AUTH? 'config' : 'index') . '.php' . lovd_showSID());
    exit;
}

require ROOT_PATH . 'inc-lib-form.php';
lovd_errorClean();

if (isset($_GET['sent'])) {
    // Get the user data to check if the lock is set.
    $aLock = mysql_fetch_assoc(mysql_query('SELECT * FROM ' . TABLE_SUBS . ' WHERE username = "' . $_POST['username'] . '" AND deleted = 0'));
    if (!$aLock) {
        $aLock = mysql_fetch_assoc(mysql_query('SELECT * FROM ' . TABLE_USERS . ' WHERE username = "' . $_POST['username'] . '" AND deleted = 0'));
    }

    if (is_array($aLock) && $aLock['login_attempts'] >= 3) {
        // Account is locked!

        // Show login form.
        unset($_GET['sent']);

        // Spit out error.
        lovd_errorAdd('Your account is locked, usually because a wrong password was provided three times. Please contact a LOVD manager or the database administrator to unlock your account.');
    }

    // Clean up after ourselves.
    unset($aLock);
}



if (isset($_GET['sent'])) {
    $_SESSION['subs'] = mysql_fetch_assoc(mysql_query('SELECT * FROM ' . TABLE_SUBS . ' WHERE username = "' . $_POST['username'] . '" AND password = "' . md5($_POST['password']) . '" AND deleted = 0'));
    if (is_array($_SESSION['subs'])) {
        $_SUBS = & $_SESSION['subs'];
        $_AUTH = & $_SUBS;
    } else {
        $_SUBS = false;
    }

    if (!$_SUBS) {
        $_SESSION['auth'] = mysql_fetch_assoc(mysql_query('SELECT * FROM ' . TABLE_USERS . ' WHERE username = "' . $_POST['username'] . '" AND password = "' . md5($_POST['password']) . '" AND deleted = 0'));
        if (is_array($_SESSION['auth'])) {
            $_AUTH = & $_SESSION['auth'];
        } else {
            $_AUTH = false;
        }
    }

    if (isset($_COOKIE['lovd_cookie_check'])) {
        if (!$_AUTH) {
            lovd_writeLog('MySQL:Auth', 'AuthError', $_SERVER['REMOTE_ADDR'] . ' (' . gethostbyaddr($_SERVER['REMOTE_ADDR']) . ') tried logging in using ' . $_POST['username'] . '/' . str_repeat('*', strlen($_POST['password'])));
            lovd_errorAdd('Invalid Username/Password combination.');

            // This may not actually update (user misspelled his username) but we can call the query anyway.
            if ($_CONF['lock_submitters']) {
                mysql_query('UPDATE ' . TABLE_SUBS . ' SET login_attempts = login_attempts + 1 WHERE username = "' . $_POST['username'] . '" AND deleted = 0');
            }
            if ($_CONF['lock_curators']) {
                mysql_query('UPDATE ' . TABLE_USERS . ' SET login_attempts = login_attempts + 1 WHERE username = "' . $_POST['username'] . '" AND level < 9 AND deleted = 0');
            }

            // Check if the user is locked, now.
// FIXME; kan deze niet weggelaten worden, als je kijkt naar het eerder opgehaalde nummer???
            $aLock = mysql_fetch_assoc(mysql_query('SELECT * FROM ' . TABLE_SUBS . ' WHERE username = "' . $_POST['username'] . '" AND deleted = 0'));
            if (!$aLock) {
                $aLock = mysql_fetch_assoc(mysql_query('SELECT * FROM ' . TABLE_USERS . ' WHERE username = "' . $_POST['username'] . '" AND deleted = 0'));
            }
            if (is_array($aLock) && $aLock['login_attempts'] >= 3) {
                lovd_errorAdd('Your account is now locked, since this is the third time a wrong password was provided.');
            }

        } else {
            lovd_writeLog('MySQL:Auth', 'AuthLogin', $_SERVER['REMOTE_ADDR'] . ' (' . gethostbyaddr($_SERVER['REMOTE_ADDR']) . ') successfully logged in using ' . $_POST['username'] . '/' . str_repeat('*', strlen($_POST['password'])));
            $_SESSION['last_login'] = $_AUTH['last_login'];
            mysql_query('UPDATE ' . ($_SUBS? TABLE_SUBS : TABLE_USERS) . ' SET ' . ($_SUBS? '' : 'phpsessid = "' . session_id() . '", ') . 'last_login = NOW(), login_attempts = 0 WHERE ' . ($_SUBS? 'submitterid = ' . $_SUBS['submitterid'] : 'userid = ' . $_AUTH['userid']));
            header('Location: ' . PROTOCOL . $_SERVER['HTTP_HOST'] . $_SERVER['PHP_SELF'] . lovd_showSID());
            exit;
        }
    } else {
        lovd_errorAdd('Cookies must be enabled before you can log in. Please enable cookies or lower your browser\'s security settings.');
        $_SUBS = $_AUTH = false;
    }
}

if (!$_AUTH) {
    require ROOT_PATH . 'inc-top.php';
    lovd_printHeader('account_login', 'Account - Log in');

    lovd_errorPrint();

    print('      <FORM action="' . $_SERVER['PHP_SELF'] . '?sent" method="post">
    <TABLE border="0" cellpadding="0" cellspacing="0" width="300">
      <TR align="right">
        <TD width="125" style="padding-right : 5px;">Username</TD>
        <TD width="175"><INPUT type="text" name="username" size="20"></TD></TR>
      <TR>
        <TD colspan="2"><IMG src="gfx/trans.png" alt="" width="1" height="1"></TD></TR>
      <TR align="right">
        <TD width="125" style="padding-right : 5px;">Password</TD>
        <TD width="175"><INPUT type="password" name="password" size="20"></TD></TR>
      <TR>
        <TD colspan="2"><IMG src="gfx/trans.png" alt="" width="1" height="1"></TD></TR>
      <TR align="right">
        <TD width="125">&nbsp;</TD>
        <TD width="175"><INPUT type="submit" value="Log in"></TD></TR></TABLE>
  </FORM>

  <SCRIPT type="text/javascript">
    document.forms[0].username.focus();
  </SCRIPT>' . "\n\n");

    require ROOT_PATH . 'inc-bot.php';
    exit;
}






?>