<?php
/*******************************************************************************
 *
 * LEIDEN OPEN VARIATION DATABASE (LOVD)
 *
 * Created     : 2006-01-27
 * Modified    : 2008-07-28
 * For LOVD    : 2.0-10
 *
 * Access      : Public
 * Purpose     : Provide top include file including menu.
 *
 * Copyright   : 2004-2008 Leiden University Medical Center; http://www.LUMC.nl/
 * Programmer  : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *
 * This file is part of LOVD.
 *
 * LOVD is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * LOVD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LOVD; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *************/

// Don't allow direct access.
if (!defined('ROOT_PATH')) {
    exit;
}

define('_INC_TOP_INCLUDED_', true);

// Load menu.
$_MENU = array(
                'home' =>
                         array(
                                array('', '', (isset($_SESSION['currdb']) && $_SESSION['currdb']? $_SESSION['currdb'] . ' homepage' : 'Home')),
                                array('', 'switch_db', 'Switch gene'),
                              ),
                'variants' =>
                         array(
                                array('', 'view_unique', 'View unique variants'),
                                array('', 'search_unique', 'Search unique variants'),
                                'vr',
                                array('', 'view_all', 'View all contents'),
                                array('', 'search_all', 'Full database search'),
                                'vr',
                                array('overview_origin', '', 'Variant listing based on patient origin'),
                                'vr',
                                array(ROOT_PATH . 'home.php', 'switch_db', 'Switch gene'),
/*                                array('stats', '', 'Database statistics'),*/
                              ),
                'submitters' =>
                         array(
                                array('', 'public_list', 'Public list of submitters'),
                                array('', 'register', 'Register as submitter'),
                                array('variants', '', (HAS_SUBS? 'My submissions' : 'Variant listings')),
                              ),
                'submit' =>
                         array(
                                array('', 'submit', 'Submit new data'),
                              ),
                'config' =>
                         array(
                                array('', '', 'Configuration', 'LOVD configuration area', 'lovd_config'),
                                array('', 'switch_db', 'Switch gene', 'Switch gene', 'lovd_database_switch'),
                                array(ROOT_PATH . 'variants.php', 'search_all&search_status_=Submitted%7CNon_Public%7CMarked', 'Curate', 'Curate', 'lovd_variants_curate'),
                                'vr',
                                array(ROOT_PATH . 'config_free_edit.php', 'fnr', 'Find &amp; Replace', 'Find &amp; Replace', 'lovd_free_edit_fnr'),
                                'vr',
                                array('columns', 'add', 'Add column', 'Add unselected pre-configured custom variant column to the ' . $_SESSION['currdb'] . ' gene', 'lovd_columns_add'),
                                array('columns', 'view_all', 'Edit columns', 'Manage selected custom columns in the ' . $_SESSION['currdb'] . ' gene', 'lovd_columns_edit'),
                                'vr',
                                array('genes', 'manage', 'Edit gene db', 'Manage ' . $_SESSION['currdb'] . ' gene', 'lovd_database_edit'),
                                array('genes', 'empty', 'Empty gene db', 'Empty ' . $_SESSION['currdb'] . ' gene', 'lovd_database_empty'),
                                'vr',
                                array(ROOT_PATH . 'download.php', 'view_all', 'Download', 'Download all variants from the ' . $_SESSION['currdb'] . ' gene database', 'lovd_save'),
                                array('import', '', 'Import', 'Import variants into the ' . $_SESSION['currdb'] . ' gene database', 'lovd_database_import'),
                              ),
                'setup' =>
                         array(
                                array('', '', 'Setup', 'LOVD system setup', 'lovd_setup'),
                                array('settings', '', 'Settings', 'LOVD system settings', 'lovd_settings'),
//                                array(ROOT_PATH . 'install/uninstall.php', '', 'Uninstall', 'Uninstall LOVD', 'lovd_warning'),
                                'vr',
                                array('columns', 'add', 'Add col', 'Add unselected pre-configured custom patient column', 'lovd_columns_add'),
                                array('columns', 'view_all', 'Edit cols', 'Manage selected custom patient columns', 'lovd_columns_edit'),
                                'vr',
                                array('columns_global', 'create', 'New col', 'New custom column', 'lovd_columns_create'),
                                array('columns_global', 'view_all', 'All cols', 'View all custom column default settings', 'lovd_columns_view'),
                                'vr',
                                array('links', 'create', 'New link', 'New custom link', 'lovd_links_create'),
                                array('links', 'view_all', 'Edit links', 'Manage custom links', 'lovd_links_edit'),
                                'vr',
                                array('modules', 'scan', 'Scan', 'Scan for new modules', 'lovd_modules_scan'),
                                array('modules', 'view_all', 'Modules', 'Manage installed modules', 'lovd_modules_manage'),
                                'vr',
                                array('genes', 'create', 'New gene', 'New gene database', 'lovd_database_create'),
                                array('genes', 'view_all', 'Edit genes', 'Manage configured genes', 'lovd_database_edit'),
                                'vr',
                                array('users', 'create', 'New user', 'Create new authorized user', 'lovd_users_create'),
                                array('users', 'view_all', 'Edit users', 'Manage authorized users', 'lovd_users_edit'),
                                'vr',
                                array('submitters', 'create', 'New sub', 'Create new submitter', 'lovd_submitters_create'),
                                array('submitters', 'view_all', 'Edit subs', 'Manage submitters', 'lovd_submitters_edit'),
                                'vr',
                                array('logs', 'select', 'Log files', 'System logs', 'lovd_logs'),
                              ),
                'docs' =>
                         array(
                                array('docs/index.php', '', 'LOVD manual table of contents'),
                              ),
              );

// Remove certain menu entries, if the user has no access to them.
if (!HAS_AUTH) {
    if (!$_CONF['my_submissions']) {
        unset($_MENU['submitters'][2]);
    }
    unset($_MENU['config'], $_MENU['setup']);
} elseif ($_AUTH['level'] < LEVEL_CURATOR) {
    unset($_MENU['config']);
} elseif ($_AUTH['level'] < LEVEL_MANAGER) {
    unset($_MENU['setup']);
} elseif ($_AUTH['level'] < LEVEL_ADMIN) {
    unset($_MENU['setup'][2]); // Uninstall.
}

// Unnecessary entries.
if (GENE_COUNT < 2) {
    // Disable switch genes.
    unset($_MENU['home'][1]);
    if (isset($_MENU['config'])) {
        unset($_MENU['config'][1]);
    }
    if (!GENE_COUNT) {
        // No gene at all! Disable lots of other options.
        unset($_MENU['submit']); // Submit new data.
        unset($_MENU['config'][2]); // Curate variants.
        unset($_MENU['config'][3], $_MENU['config'][4]); // Free Edit.
        unset($_MENU['config'][5], $_MENU['config'][6], $_MENU['config'][7]); // Column handling.
        unset($_MENU['config'][8], $_MENU['config'][9], $_MENU['config'][10]); // Edit & empty gene.
        unset($_MENU['config'][11], $_MENU['config'][12], $_MENU['config'][13]); // Download & import.
    }
}

// This is nice; create a dir structure. Not that it really matters, since you can't navigate from there much but still...
$aPath = explode('/', trim(dirname($_SERVER['PHP_SELF']), '/'));
for ($i = count($aPath) - substr_count(ROOT_PATH, '../'); $i > 0; $i --) {
    array_shift($aPath);
}
$aMenu = array();
if (isset($aPath[0]) && $aPath[0] == 'docs') {
    // We're at the documents section.
    array_shift($aPath);
    $aIndex = $_PAGES;
    while (count($aPath)) {
        // Looping to find where we're at.
        foreach ($aIndex as $nKey => $sPage) {
            if (!is_array($sPage) && lovd_strToFileName($sPage) == $aPath[0]) {
                $_MENU['docs'][] = array('docs/' . implode('/', $aMenu) . '/' . lovd_strToFileName($sPage) . '.php', '', '&raquo;&nbsp;&nbsp;&nbsp;' . $sPage);
                $aIndex = $aIndex[$nKey + 1];
                $aMenu[] = lovd_strToFileName($sPage);
                array_shift($aPath);
                break;
            }
        }
    }

    // Looping to find where we're at.
    foreach ($aIndex as $sPage) {
        if (!is_array($sPage) && lovd_strToFileName($sPage) . '.php' == basename($_SERVER['PHP_SELF'])) {
            $_MENU['docs'][] = array('docs/' . implode('/', $aMenu) . '/' . lovd_strToFileName($sPage) . '.php', '', '&raquo;&nbsp;&nbsp;&nbsp;' . $sPage . '&nbsp;&nbsp;&nbsp;&nbsp;');
            break;
        }
    }
}

// FIXME; isn't there a better way for doing this?
// Pages that 'require' $_GET['select_db'].
// Although a $_SESSION variable handles this, after a long timeout it's annoying to lose this data.
$aRequireSelectDB = array('home', 'variants');

// 2007-09-28; 2.0-beta-09; Define title...
$aFileName = explode('_', basename($_SERVER['PHP_SELF'], '.php'), 2);
$sPrefix = $aFileName[0];
$sTitle = ucfirst($sPrefix);
if (array_key_exists($sPrefix, $_MENU)) {
    // We may find a title here.
    foreach ($_MENU[$sPrefix] as $aLink) {
        if (is_array($aLink) && ($aLink[0] && !empty($aFileName[1]) && $aLink[0] == $aFileName[1]) || (!$aLink[0] && !isset($aFileName[1]))) {
            // Filenames like setup_XXXX.php and like setup.php.
            if (($aLink[1] && isset($_GET['action']) && $aLink[1] == $_GET['action']) || !$aLink[1]) {
                // Action required, perfect match; or no action required.
                $sTitle = (!empty($aLink[3])? $aLink[3] : $aLink[2]);
            }
            continue;
        }
    }
}
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" 
        "http://www.w3.org/TR/html4/loose.dtd">
<HTML lang="en_US">
<HEAD>
  <TITLE><?php echo $sTitle . ' - ' . $_CONF['system_title']; ?> - Leiden Open Variation Database</TITLE>
  <META http-equiv="Content-Type" content="text/html; charset=ISO-8859-1"> 
  <META name="Author" content="Ing. Ivo F.A.C. Fokkema, LUMC, Netherlands">
  <META name="Generator" content="gPHPEdit / GIMP @ GNU/Linux (Debian/Ubuntu)">
  <LINK rel="stylesheet" type="text/css" href="<?php echo (defined('_INC_TOP_USE_LOCAL_STYLES_') && _INC_TOP_USE_LOCAL_STYLES_ == true? '' : ROOT_PATH); ?>styles.css">

  <SCRIPT type="text/javascript">
    <!--
<?php
foreach ($_MENU as $sPrefix => $aMenu) {
    // Create javascript for mouseovers.
    $sFileName = 'tab_' . $sPrefix;
    $sVariable = 'nav' . ucfirst($sPrefix);

    print('    ' . $sVariable . '_B     = new Image();' . "\n" .
          '    ' . $sVariable . '_B.src = \'' . ROOT_PATH . 'gfx/' . $sFileName . '_B.png\';' . "\n" .
          '    ' . $sVariable . '_H     = new Image();' . "\n" .
          '    ' . $sVariable . '_H.src = \'' . ROOT_PATH . 'gfx/' . $sFileName . '_H.png\';' . "\n");
}
?>

    // Used for tab images.
    function lovd_imageSwitch (image_id, image_mode) {
      document.getElementById(image_id).src = eval(image_id + '_' + image_mode + '.src');
    }

    // Load function to open up new windows.
    function lovd_openWindow (var_dest, var_name, var_width, var_height, varPosX, varPosY) {
<?php // Normally, we wouldn't need to do a preg_replace, but in some cases the ID might be set directly to a string value. ?>
      var_name = 'LOVD_<?php echo preg_replace('/[^a-z0-9_]/i', '_', $_STAT['signature']); ?>_' + var_name;
      if (!var_width) {
        var var_width = screen.width - 100;
      }
      if (!var_height) {
        var var_height = screen.height - 200;
      }
      if (!varPosX) {
        var varPosX = 50;
      }
      if (!varPosY) {
        var varPosY = 50;
      }
      window.open(var_dest, var_name, 'width=' + var_width + ',height=' + var_height + ',left=' + varPosX + ',top=' + varPosY + ',scrollbars=1');
<?php // FIXME; where was the ,screenX=50,screenY=50 for again? Which browser didn't support that? ?>
    }

    //-->
  </SCRIPT>
</HEAD>

<BODY style="margin : 0px;">

<TABLE border="0" cellpadding="0" cellspacing="0" width="100%"><TR><TD>

<TABLE border="0" cellpadding="0" cellspacing="0" width="100%" class="logo">
  <TR>
    <TD width="150">
      <IMG src="<?php echo ROOT_PATH; ?>gfx/LOVD_logo130x50.jpg" alt="LOVD - Leiden Open Variation Database" width="130" height="50">
    </TD>
<?php
print('    <TD valign="top" style="padding-top : 2px;">' . "\n" .
      '      <H2 style="margin-bottom : 2px;">' . $_CONF['system_title'] . '</H2>' . "\n" .
      (isset($_SESSION['currdb']) && $_SESSION['currdb']? '      <H5>' . $_SETT['currdb']['gene'] . ' (' . $_SETT['currdb']['symbol'] . ')</H5>' . "\n" : '') .
      '    </TD>' . "\n" .
      '    <TD valign="top" align="right" style="padding-right : 5px; padding-top : 2px;">' . "\n" .
      '      LOVD v.' . $_STAT['tree'] . ' Build ' . $_STAT['build'] . ' [ <A href="' . ROOT_PATH . 'status.php">Current LOVD status</A> ]<BR>' . "\n");
if ($_AUTH) {
    print('      <B>Welcome, ' . $_AUTH['name'] . '</B><BR>' . "\n" .
          '      <A href="' . ROOT_PATH . 'account_update.php"><B>Your account</B></A> | ' . (HAS_SUBS && $_CONF['my_submissions']? '<A href="' . ROOT_PATH . 'submitters_variants.php?all_genes"><B>Your submissions</B></A> | ' : '') . '<A href="' . ROOT_PATH . 'account_logout.php"><B>Log out</B></A><BR>' . "\n");
} else {
    print('      <A href="' . ROOT_PATH . 'submitters.php?action=register"><B>Register as submitter</B></A> | <A href="' . ROOT_PATH . 'account_login.php"><B>Log in</B></A><BR>' . "\n");
}

print('    </TD>' . "\n" .
      '  </TR>' . "\n" .
      '</TABLE>' . "\n\n");



// Build menu tabs...
print('<TABLE border="0" cellpadding="0" cellspacing="0" width="100%" class="logo">' . "\n" .
      '  <TR>' . "\n" .
      '    <TD align="left" style="background : url(\'' . ROOT_PATH . 'gfx/tab_fill.png\');">' . "\n");

// Loop menu.
$n         = 0;
$bSel      = false;
$bPrevSel  = false;
$sSelected = '';
foreach ($_MENU as $sPrefix => $aMenu) {
    // To determine where we are, build all links.
    $aTabLinks = array();
    foreach ($aMenu as $aLink) {
        if (is_array($aLink)) { // 'vr' is not an array, so skip it.
            $aTabLinks[] = lovd_cleanDirName(dirname($_SERVER['PHP_SELF']) . '/' . ROOT_PATH . (substr_count($aLink[0], '/')? $aLink[0] : $sPrefix . (!$aLink[0]? '' : '_' . $aLink[0]) . '.php') . ($aLink[1]? '?action=' . $aLink[1] : ''));
        }
    }
    // File to link to.
    $sFile = $aTabLinks[0];

    // Sorry... just nasty... but this is annoying!
    if ($sPrefix == 'variants') {
        unset($aTabLinks[5]); // Unsetting switch gene because this code activates the home and the variants tab!
    }

    // Determine if we're the current tab.
    $bSel = in_array($_SERVER['PHP_SELF'], $aTabLinks);
    if (!$bSel && !empty($_GET['action'])) {
        // Check for the URL with a $_GET['action'], then.
        $bSel = in_array($_SERVER['PHP_SELF'] . '?action=' . $_GET['action'], $aTabLinks);
    }
    // Auch! Hard coded exception!
    if (!$bSel && $sPrefix == 'docs' && substr(lovd_getProjectFile(), 0, 6) == '/docs/') { $bSel = true; }
    if ($bSel) {
        $sSelected = $sPrefix;
    }
    $sFileName = 'tab_' . $sPrefix;
    $sVariable = 'nav' . ucfirst($sPrefix);

    // Print transition.
    print('      <IMG src="' . ROOT_PATH . 'gfx/tab_' . (!$n? '0' : ($bPrevSel? 'F' : 'B')) . ($bSel? 'F' : 'B') . '.png" alt="" width="33" height="30" align="left">' . "\n");

    // Get header info.
    $sFileName = ROOT_PATH . 'gfx/' . $sFileName . '_' . ($bSel? 'F' : 'B') . '.png';
    if (!file_exists($sFileName)) {
        // Fallback.
        $sFileName = ROOT_PATH . 'gfx/tab_missing_' . ($bSel? 'F' : 'B') . '.png';
    }
    $aImage = getimagesize($sFileName);
    $sSize = $aImage[3];

    // Print header.
    $bRequireSelectDB = (in_array($sPrefix, $aRequireSelectDB) && $_SESSION['currdb']);
    $sFile .= ($bRequireSelectDB? ($aMenu[0][1]? '&amp;' : '?') . 'select_db=' . $_SESSION['currdb'] : '');
    print('      <A href="' . $sFile . '"><IMG src="' . $sFileName . '" alt="' . $aMenu[0][2] . '" title="' . $aMenu[0][2] . '" ' . $sSize . ' align="left" id="' . $sVariable . '" border="0"' . ($bSel? '></A>' : ' onmouseover="lovd_imageSwitch(\'' . $sVariable . '\', \'H\');" onmouseout="lovd_imageSwitch(\'' . $sVariable . '\', \'B\');"></A>') . "\n");

    $bPrevSel = $bSel;
    $n ++;
}

// Closing transition.
print('      <IMG src="' . ROOT_PATH . 'gfx/tab_' . ($bPrevSel? 'F' : 'B') . '0.png" alt="" width="33" height="30" align="left">' . "\n");

print('    </TD>' . "\n" .
      '  </TR>' . "\n" .
      '</TABLE>' . "\n\n");



if ($sSelected) {
    // Build sub menu...
    print('<DIV style="padding : 5px; margin-bottom : 5px;">' . "\n" .
          '<TABLE border="0" cellpadding="0" cellspacing="0" width="100%" class="submenu">' . "\n" .
          '  <TR>' . "\n" .
          '    <TD>' . "\n" .
          '      <TABLE border="0" cellpadding="0" cellspacing="0">' . "\n" .
          '        <TR>' . "\n");

    // Loop menu.
    foreach ($_MENU[$sSelected] as $key => $aLink) {
        // Various spacers.
        if (!is_array($aLink)) {
            switch ($aLink) {
                case 'vr':
                    print('          <TD width="1" style="padding : 0px; background : #224488;"><IMG src="' . ROOT_PATH . 'gfx/trans.png" alt="" width="1" height="1"></TD>' . "\n");
                    break;
                case 'skip':
                    print('          <TD>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</TD>' . "\n");
                    break;
                default:
                    print('          <TD>' . $aLink . '</TD>' . "\n");
            }
            continue;
        }
    
        // Build link.
        $sFile = lovd_cleanDirName(dirname($_SERVER['PHP_SELF']) . '/' . ROOT_PATH . (substr_count($aLink[0], '/')? $aLink[0] : $sSelected . (!$aLink[0]? '' : '_' . $aLink[0]) . '.php') . ($aLink[1]? '?action=' . $aLink[1] : ''));

        // Determine if we're the current link.
        $bSel = ($_SERVER['PHP_SELF'] . (isset($_GET['action']) && $_GET['action']? '?action=' . $_GET['action'] : '') == $sFile);
    
        // Print link.
        $sLink = str_replace(' ', '&nbsp;', $aLink[2]);
        if (isset($aLink[3], $aLink[4]) && file_exists(ROOT_PATH . 'gfx/' . $aLink[4] . '.png')) {
            $sLink = '<IMG src="' . ROOT_PATH . 'gfx/' . $aLink[4] . '.png" alt="' . $aLink[3] . '" title="' . $aLink[3] . '" width="32" height="32" border="0"><BR>' . $sLink;
        }
        print('          <TD align="center"' . ($bSel? ' style="background : #C8DCFA;"' : '') . '><A href="' . $sFile . '">' . $sLink . '</A></TD>' . "\n");

        // Print spacer.
        if (isset($_MENU[$sSelected][$key+1]) && is_array($_MENU[$sSelected][$key+1])) {
            print('          <TD style="padding : 0px;">&nbsp;</TD>' . "\n");
        }
    }
    
    print('        </TR>' . "\n" .
          '      </TABLE>' . "\n" .
          '    </TD>' . "\n" .
          '  </TR>' . "\n" .
          '</TABLE>' . "\n" .
          '</DIV>' . "\n\n");

} else {
    print('<BR>' . "\n\n");
}
?>



<DIV style="padding : 0px 10px;">
<TABLE border="0" cellpadding="0" cellspacing="0" width="100%">
  <TR>
    <TD>








