<?php
/**************************************************************************
 *
 * LOVD DATABASE WEBSITE
 *
 * Created     : 2008-07-17
 * Modified    : 2008-07-17
 * For LOVD    : 2.0-09
 *
 * Access      : Public
 *
 * Programmer  : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *************/

define('ROOT_PATH', '../../');
define('DOCS_PATH', ROOT_PATH . 'docs/');
require DOCS_PATH . 'inc-website-init.php';
require ROOT_PATH . 'inc-top.php';
?>

            <H3>LOVD Setup</H3>
            <H4>Custom links</H4>

            LOVD offers the custom link feature to quickly create links to external sources. By default, LOVD comes with a set of custom links allowing curators to quickly create links to entries in the online databases DbSNP, GenBank, OMIM and Pubmed, without actually having to know how to create links in HTML. You need access to the setup area to create new custom links to other external data sources. The curator can easily add custom links to the variant and patient data using shortcuts on the submission forms.<BR>
            <BR>

<?php lovd_showInfoTable('If you wish to add new custom links, or edit existing ones, you will need a basic knowledge of the internet markup language HTML. Custom links allow curators to put a text like \'{PMID15977173:Fokkema et al}\' in a certain column and get it replaced by a link to an article on PubMed, in this case the LOVD article: \'' . htmlspecialchars('<A href="http://www.ncbi.nlm.nih.gov/pubmed/15977173" target="_blank">Fokkema et al</A>') . '\', which will be interpreted as \'<A href="http://www.ncbi.nlm.nih.gov/pubmed/15977173" target="_blank">Fokkema et al</A>\'.', 'information'); ?>

            References are used to pass on information necessary for building the link, e.g. a PubMed ID. These references are defined in the link pattern and then speficied in the replacement text, and are indicated by numbers surrounded by square brackets, like '[1]' or '[2]'.<BR>
            <BR>

<?php lovd_showInfoTable('<B>Example:</B> the PubMed custom link.<BR><I>Pattern</I>:<BR>&nbsp;&nbsp;{PMID[1]:[2]}<BR>&nbsp;&nbsp;Links to abstracts in the PubMed database.<BR>&nbsp;&nbsp;[1] = The PubMed ID.<BR>&nbsp;&nbsp;[2] = The name of the author(s).<BR><I>Replacement text</I>:<BR>&nbsp;&nbsp;' . htmlspecialchars('<A href="http://www.ncbi.nlm.nih.gov/pubmed/[1]" target="_blank">[2]</A>') . '.', 'question'); ?>

<?php
include ROOT_PATH . 'inc-bot.php';
?>
