<?php
/**************************************************************************
 *
 * LOVD DATABASE WEBSITE
 *
 * Created     : 2008-08-12
 * Modified    : 2008-09-02
 * For LOVD    : 2.0-11
 *
 * Access      : Public
 *
 * Programmer  : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *************/

define('ROOT_PATH', '../../../');
define('DOCS_PATH', ROOT_PATH . 'docs/');
require DOCS_PATH . 'inc-website-init.php';
require ROOT_PATH . 'inc-top.php';
?>

            <H3>LOVD Setup</H3>
            <H4>System logs</H4>
            <H5>What is logged by LOVD</H5>

            LOVD logs four types of events: authorization events and errors, general events, general errors, and installation and upgrade events. In case the event or error was trigged by an authorized user, the username of this user is also logged.<BR>
            <BR>

            <H6>Authorization events and errors</H6>

            This list stores both successful and unsuccessful login attempts. When a user's account has been locked, this log shows you from what IP address the login attempts have been made. Also, it shows you if users provide a password or not. Brute-force attempts to hack into LOVD are quickly uncovered using these logs.<BR>
            <BR>

            <TABLE border="0" cellpadding="2" cellspacing="0" width="100%" class="S11" style="border : 1px solid #666666;">
              <TR>
                <TD style="border-top : 3px double #666666; border-bottom : 1px solid #666666;" width="15%"><I>Event</I></TD>
                <TD style="border-top : 3px double #666666; border-bottom : 1px solid #666666;" width="85%"><I>Caused by</I></TD></TR>
              <TR valign="top">
                <TD style="border-bottom : 1px dotted #666666;">AuthError</TD>
                <TD style="border-bottom : 1px dotted #666666;">Unsuccessful attempt to log into LOVD. Shows IP address, hostname, username, and the length of the provided password.</TD></TR>
              <TR valign="top">
                <TD>AuthLogin</TD>
                <TD>Successful attempt to log into LOVD. Shows IP address, hostname, username, and the length of the provided password.</TD></TR></TABLE><BR>

            <H6>General events</H6>

            General events are logged to show a user's activity, to allow collaborating users to track each other's activities or to check what happened to a certain variant or patient entry.<BR>
            <BR>

            <TABLE border="0" cellpadding="2" cellspacing="0" width="100%" class="S11" style="border : 1px solid #666666;">
              <TR>
                <TD style="border-top : 3px double #666666; border-bottom : 1px solid #666666;" width="15%"><I>Event</I></TD>
                <TD style="border-top : 3px double #666666; border-bottom : 1px solid #666666;" width="85%"><I>Caused by</I></TD></TR>
              <TR valign="top">
                <TD style="border-bottom : 1px dotted #666666;">ColAdd</TD>
                <TD style="border-bottom : 1px dotted #666666;">A custom column has been added to a variant table or the patient table. In case the column has been added to a variant table, the gene is also mentioned.</TD></TR>
              <TR valign="top">
                <TD style="border-bottom : 1px dotted #666666;">ColCreate</TD>
                <TD style="border-bottom : 1px dotted #666666;">A new column has been created from the setup area.</TD></TR>
              <TR valign="top">
                <TD style="border-bottom : 1px dotted #666666;">ColEdit</TD>
                <TD style="border-bottom : 1px dotted #666666;">A column's display settings or default settings have been edited.</TD></TR>
              <TR valign="top">
                <TD style="border-bottom : 1px dotted #666666;">ColRemove</TD>
                <TD style="border-bottom : 1px dotted #666666;">A selected column has been removed from a variant table or the patient table. In case the column has been removed to a variant table, the gene is also mentioned.</TD></TR>
              <TR valign="top">
                <TD style="border-bottom : 1px dotted #666666;">ColReset</TD>
                <TD style="border-bottom : 1px dotted #666666;">A selected column's display settings are reset to the default settings.</TD></TR>
              <TR valign="top">
                <TD style="border-bottom : 1px dotted #666666;">ConfigEdit</TD>
                <TD style="border-bottom : 1px dotted #666666;">Successfully edited LOVD's system settings.</TD></TR>
              <TR valign="top">
                <TD style="border-bottom : 1px dotted #666666;">FreeEditFNR</TD>
                <TD style="border-bottom : 1px dotted #666666;">Successfully ran Find &amp; Replace. The column and the selected genes where Find &amp; Replace was performed on are also logged.</TD></TR>
              <TR valign="top">
                <TD style="border-bottom : 1px dotted #666666;">GeneCreate</TD>
                <TD style="border-bottom : 1px dotted #666666;">Successfully created a new gene.</TD></TR>
              <TR valign="top">
                <TD style="border-bottom : 1px dotted #666666;">GeneDrop</TD>
                <TD style="border-bottom : 1px dotted #666666;">Deleted a gene and it's variants.</TD></TR>
              <TR valign="top">
                <TD style="border-bottom : 1px dotted #666666;">GeneEdit</TD>
                <TD style="border-bottom : 1px dotted #666666;">A gene's settings have been edited.</TD></TR>
              <TR valign="top">
                <TD style="border-bottom : 1px dotted #666666;">GeneEmpty</TD>
                <TD style="border-bottom : 1px dotted #666666;">All of a gene's variants have been removed.</TD></TR>
              <TR valign="top">
                <TD style="border-bottom : 1px dotted #666666;">LinkCreate</TD>
                <TD style="border-bottom : 1px dotted #666666;">A new custom link has been created. If the link also has been added to any columns, this is mentioned in separate log entries.</TD></TR>
              <TR valign="top">
                <TD style="border-bottom : 1px dotted #666666;">LinkDrop</TD>
                <TD style="border-bottom : 1px dotted #666666;">A custom link has been deleted.</TD></TR>
              <TR valign="top">
                <TD style="border-bottom : 1px dotted #666666;">LinkEdit</TD>
                <TD style="border-bottom : 1px dotted #666666;">A custom link has been edited. If the link also has been removed from or added to any columns, this is mentioned in separate log entries.</TD></TR>
              <TR valign="top">
                <TD style="border-bottom : 1px dotted #666666;">ModuleDisable</TD>
                <TD style="border-bottom : 1px dotted #666666;">Successfully disabled a module (turned off).</TD></TR>
              <TR valign="top">
                <TD style="border-bottom : 1px dotted #666666;">ModuleEnable</TD>
                <TD style="border-bottom : 1px dotted #666666;">Successfully enabled a module (turned on).</TD></TR>
              <TR valign="top">
                <TD style="border-bottom : 1px dotted #666666;">ModuleScan</TD>
                <TD style="border-bottom : 1px dotted #666666;">LOVD scanned for new modules, successfully recognized one and installed it.</TD></TR>
              <TR valign="top">
                <TD style="border-bottom : 1px dotted #666666;">ModuleUninstall</TD>
                <TD style="border-bottom : 1px dotted #666666;">Successfully uninstalled (removed) a module.</TD></TR>
              <TR valign="top">
                <TD style="border-bottom : 1px dotted #666666;">PatientDrop</TD>
                <TD style="border-bottom : 1px dotted #666666;">A patient and all of it's variants have been deleted.</TD></TR>
              <TR valign="top">
                <TD style="border-bottom : 1px dotted #666666;">PatientEdit</TD>
                <TD style="border-bottom : 1px dotted #666666;">A patient has been edited, by an authorized user or a submitter, or submitted changes have been accepted by an authorized user.</TD></TR>
              <TR valign="top">
                <TD style="border-bottom : 1px dotted #666666;">SelfEdit</TD>
                <TD style="border-bottom : 1px dotted #666666;">A user has successfully edited him/herself. When a user selects or deselects him/herself as a curator, this is also logged.</TD></TR>
              <TR valign="top">
                <TD style="border-bottom : 1px dotted #666666;">SubmitNew</TD>
                <TD style="border-bottom : 1px dotted #666666;">A new submission has been added to LOVD. The gene, internal patient ID and internal variant ID are also mentioned. This log entry could also mean that a new variant has been added to an existing patient.</TD></TR>
              <TR valign="top">
                <TD style="border-bottom : 1px dotted #666666;">SubmitterAssign</TD>
                <TD style="border-bottom : 1px dotted #666666;">A submitter has been assigned to a patient, or removed from a patient.</TD></TR>
              <TR valign="top">
                <TD style="border-bottom : 1px dotted #666666;">SubmitterCreate</TD>
                <TD style="border-bottom : 1px dotted #666666;">A submitter account has been created by an authorized user.</TD></TR>
              <TR valign="top">
                <TD style="border-bottom : 1px dotted #666666;">SubmitterDrop</TD>
                <TD style="border-bottom : 1px dotted #666666;">A submitter account has been deleted from the system. This is a non-permanent action.</TD></TR>
              <TR valign="top">
                <TD style="border-bottom : 1px dotted #666666;">SubmitterEdit</TD>
                <TD style="border-bottom : 1px dotted #666666;">A submitter account has been edited by an authorized user.</TD></TR>
              <TR valign="top">
                <TD style="border-bottom : 1px dotted #666666;">SubmitterPurge</TD>
                <TD style="border-bottom : 1px dotted #666666;">A previously deleted submitter account has been permanently deleted from the system.</TD></TR>
              <TR valign="top">
                <TD style="border-bottom : 1px dotted #666666;">SubmitterRegister</TD>
                <TD style="border-bottom : 1px dotted #666666;">A submitter has registered him/herself.</TD></TR>
              <TR valign="top">
                <TD style="border-bottom : 1px dotted #666666;">UserBoot</TD>
                <TD style="border-bottom : 1px dotted #666666;">An authorized user that was logged in, has been thrown out of the system by an authorized user with a higher level.</TD></TR>
              <TR valign="top">
                <TD style="border-bottom : 1px dotted #666666;">UserCreate</TD>
                <TD style="border-bottom : 1px dotted #666666;">A new authorized user has been created by an authorized user with a higher level. When this user is selected as a curator, this is also logged.</TD></TR>
              <TR valign="top">
                <TD style="border-bottom : 1px dotted #666666;">UserDrop</TD>
                <TD style="border-bottom : 1px dotted #666666;">An authorized user has been deleted from the system by an authorized user with a higher level. This is a non-permanent action.</TD></TR>
              <TR valign="top">
                <TD style="border-bottom : 1px dotted #666666;">UserEdit</TD>
                <TD style="border-bottom : 1px dotted #666666;">An authorized user has been edited by an authorized user with a higher level. When this user is selected or deselected as a curator, this is also logged.</TD></TR>
              <TR valign="top">
                <TD style="border-bottom : 1px dotted #666666;">UserLock</TD>
                <TD style="border-bottom : 1px dotted #666666;">An authorized user has been locked out of the system by an authorized user with a higher level.</TD></TR>
              <TR valign="top">
                <TD style="border-bottom : 1px dotted #666666;">UserUnlock</TD>
                <TD style="border-bottom : 1px dotted #666666;">An authorized user's account has been unlocked by an authorized user with a higher level.</TD></TR>
              <TR valign="top">
                <TD style="border-bottom : 1px dotted #666666;">VariantDrop</TD>
                <TD style="border-bottom : 1px dotted #666666;">A variant has been dropped from a patient. If this was the patient's only variant, the patient entry is also deleted.</TD></TR>
              <TR valign="top">
                <TD style="border-bottom : 1px dotted #666666;">VariantEdit</TD>
                <TD style="border-bottom : 1px dotted #666666;">A variant has been edited by either an authorized user or a submitter who owns the variant's patient entry.</TD></TR>
              <TR valign="top">
                <TD>VariantImport</TD>
                <TD>Variant and patient information has been loaded into the database. The amount of new patient and variant entries are reported.</TD></TR></TABLE><BR>



            <H6>General errors</H6>

            Whenever an unrecoverable error occurs, LOVD logs the error and stops processing. When it's a database error, LOVD tries to log the error to a file.<BR>
            In principle, during any database event, an error can occur. This is then logged under the name of the event, so any of the above event names can also be found in the error log. In the below table you can find the event names that appear exclusively in the error log. If you find any other event name in the error log, see the above table.<BR>
            <BR>

            <TABLE border="0" cellpadding="2" cellspacing="0" width="100%" class="S11" style="border : 1px solid #666666;">
              <TR>
                <TD style="border-top : 3px double #666666; border-bottom : 1px solid #666666;" width="15%"><I>Event</I></TD>
                <TD style="border-top : 3px double #666666; border-bottom : 1px solid #666666;" width="85%"><I>Caused by</I></TD></TR>
              <TR valign="top">
                <TD style="border-bottom : 1px dotted #666666;">CheckUpdate</TD>
                <TD style="border-bottom : 1px dotted #666666;">There was an error while reading the answer of the upstream server to see if there is an update available, or the current version seems newer than the one available.</TD></TR>
              <TR valign="top">
                <TD style="border-bottom : 1px dotted #666666;">CURRDB::Lib</TD>
                <TD style="border-bottom : 1px dotted #666666;">An error occured in a function from the CurrDB class. This is caused by a bug in LOVD.</TD></TR>
              <TR valign="top">
                <TD style="border-bottom : 1px dotted #666666;">EmailNotify</TD>
                <TD style="border-bottom : 1px dotted #666666;">An error occured while sending an email notification to a user who edited his/her own account, a submitter sending in new information, a curator of a gene which has received a new submission, or the database administrator.</TD></TR>
              <TR valign="top">
                <TD style="border-bottom : 1px dotted #666666;">HackAttempt</TD>
                <TD style="border-bottom : 1px dotted #666666;">Someone tried to access information or trying to edit or delete information while not being authorized. This error can only be caused if someone is actively modifying the URL to access LOVD.</TD></TR>
              <TR valign="top">
                <TD style="border-bottom : 1px dotted #666666;">LibInit</TD>
                <TD style="border-bottom : 1px dotted #666666;">An error occured in a function from inc-lib-init.php. This is caused by a bug in LOVD.</TD></TR>
              <TR valign="top">
                <TD style="border-bottom : 1px dotted #666666;">LibList</TD>
                <TD style="border-bottom : 1px dotted #666666;">An error occured in a function from inc-lib-list.php. This is caused by a bug in LOVD.</TD></TR>
              <TR valign="top">
                <TD>NoCurrDB</TD>
                <TD>The CurrDB class has been initiated without receiving a gene symbol. This is caused by a bug in LOVD.</TD></TR></TABLE><BR>



            <H6>Installation and upgrade events</H6>

            During installation of LOVD, a few log entries are added to the Install log to show the progress of the installation. Also, after each upgrade, LOVD will add an entry stating from which version and to which version it has been upgraded.<BR>
            <BR>

            <TABLE border="0" cellpadding="2" cellspacing="0" width="100%" class="S11" style="border : 1px solid #666666;">
              <TR>
                <TD style="border-top : 3px double #666666; border-bottom : 1px solid #666666;" width="15%"><I>Event</I></TD>
                <TD style="border-top : 3px double #666666; border-bottom : 1px solid #666666;" width="85%"><I>Caused by</I></TD></TR>
              <TR valign="top">
                <TD style="border-bottom : 1px dotted #666666;">Step2</TD>
                <TD style="border-bottom : 1px dotted #666666;">LOVD has successfully registered the system status, the variant pathogenicities and the variant statuses, and created the database administrator account.</TD></TR>
              <TR valign="top">
                <TD style="border-bottom : 1px dotted #666666;">Step3</TD>
                <TD style="border-bottom : 1px dotted #666666;">LOVD successfully stored the system settings.</TD></TR>
              <TR valign="top">
                <TD style="border-bottom : 1px dotted #666666;">Step4</TD>
                <TD style="border-bottom : 1px dotted #666666;">LOVD successfully installed the available modules.</TD></TR>
              <TR valign="top">
                <TD style="border-bottom : 1px dotted #666666;">Step5</TD>
                <TD style="border-bottom : 1px dotted #666666;">Successfully completed the installation.</TD></TR>
              <TR valign="top">
                <TD style="border-bottom : 1px dotted #666666;">Upgrade</TD>
                <TD style="border-bottom : 1px dotted #666666;">LOVD has been upgraded successfully. This entry also reports from which version LOVD was upgraded, which version it has been upgraded to, and how many queries are performed during the upgrade.</TD></TR>
              <TR valign="top">
                <TD>UpgradeError</TD>
                <TD>LOVD has found that the database backend is newer than the LOVD files. This can only be caused by retrieving LOVD files from backups without restoring the database. Since this can cause severe problems with the data within LOVD, LOVD will only work if you restore the correct LOVD files.</TD></TR></TABLE><BR>

<?php
include ROOT_PATH . 'inc-bot.php';
?>
