<?php
/**************************************************************************
 *
 * LOVD DATABASE WEBSITE
 *
 * Created     : 2008-07-03
 * Modified    : 2008-09-26
 * For LOVD    : 2.0-12
 *
 * Access      : Public
 *
 * Programmer  : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *************/

define('ROOT_PATH', '../../');
define('DOCS_PATH', ROOT_PATH . 'docs/');
require DOCS_PATH . 'inc-website-init.php';
require ROOT_PATH . 'inc-top.php';
?>

            <H3>LOVD Setup</H3>
            <H4>LOVD system settings</H4>

            The LOVD system settings form allows you to change global settings, such as the installation's displayed name, settings on statistics and security and some modifications to the disease and detection technique fields.<BR>
            <BR>

            <H5>General system settings</H5>
            These settings are used to somewhat update the LOVD behaviour to your needs.<BR>
            <B>Title of this LOVD installation</B>: This title will be shown on the top of every page, above the menu tabs. The default value is "LOVD - Leiden Open Variation Database".<BR>
            <B>Database location</B>: The database location is mentioned in the public area and in emails sent by LOVD. It's commonly set to a laboratory name or a website name. If it's not specified, LOVD will use the (autodetected) website name LOVD has been installed on.<BR>
            <B>LOVD email address</B>: This email address will be used to send emails from LOVD to users. LOVD needs this address to make sure that emails from LOVD arrive, to prevent problems with spam filters. Although strictly spoken this email address does not need to exist, we recommend that you use a valid address to make sure that bounces of emails sent from LOVD (to submitters or curators) are still caught by someone.<BR>
            <B>Forward messages to database admin</B>: With this setting enabled, LOVD will forward messages to the database administrator about submitter registrations, submissions, and such.<BR>
            <B>Enable 'My Submissions'</B>: 'My Submissions' is a new feature that allows submitters to quickly gather a list of submissions they've made to the database and make changes to them. Changes made by submitters will be reported to the curators by email.<BR>
            <B>Enable searching through hidden entries</B>: Enabling this feature allows the public to find the amount of entries in the database (including hidden entries) matching one or more search terms on a specified set of columns. This feature will only mention the amount of variant entries matched, without showing them.<BR>
            <BR>

            <H5>Global LOVD statistics</H5>
            Your LOVD installation can send some general information on your installation back to us. We use this information to see how popular LOVD is, which versions of LOVD are currently in use, to see what type of software is used to run LOVD and to construct the public list of LOVD installs.<BR>
            <B>Send signature</B>: This allows LOVD to send us a randomly generated 32 character text string that helps us keep your LOVD install apart from others, so we can reliably determine the number of LOVD installations world wide. We cannot use the signature to identify you.<BR>
            <B>Send statistics</B>: When this setting is enabled, LOVD will collect some general statistics and send this to us. This is the amount of submitters, genes, patients and variants in your system.<BR>
            <B>Include in the global LOVD listing</B>: On our website, we keep a list of public LOVD installations. If this setting is enabled, your LOVD installation will send us your installation's name, the URL and the available gene databases. If you changed this setting, please allow one day for the setting to take effect.<BR>
            <BR>

            <H5>Security settings</H5>
            This allows you to turn some LOVD security measures on or off.<BR>
            <B>Use cookies for user authentication</B>: Cookies are small textfiles stored on your computer that helps a website identify you. LOVD uses this to keep you identified after you log into the system. If this setting is disabled, LOVD will include a so-called session id in the URL, to keep track of the authenticated users. However, this is much less secure because including the session id in the URL may expose this session id in log files on your computer or on proxy servers. This may allow others to hijack your user's accounts. So leaving this option set is highly recommended.<BR>
            <B>Use SSL only to access LOVD</B>: SSL is a secure protocol allowing for encryption of data sent between you and LOVD. When you will record sensitive patient information in LOVD, you should enable this setting, as the patient information can otherwise be 'sniffed' off the network. If you do not record sensitive information, enabling SSL is recommended.<BR>
            <B>Hide non public entries from the unique variant listing</B>: If you turn this off, information on non public variants will be included in the unique variant listing. If visitors click the non-public variant, a message is printed that the data is hidden. This setting does not effect the safety of the patient data.<BR>
            <B>Lock curators after 3rd failed login</B>: With this settings enabled curators (and managers) will be locked out of the system after they have provided the wrong password three times. A manager or, in the case of a locked manager, the database administrator needs to unlock the user account once it's locked.<BR>
            <B>Lock submitters after 3rd failed login</B>: With this settings enabled submitters will be locked out of the system after they have provided the wrong password three times. A manager or the database administrator needs to unlock the submitter account once it's locked.<BR>
            <BR>

            <H5>Legend settings</H5>
            These settings are used to create a more detailed legend. Also, the lists of phenotypes and techniques are used to create selection lists on the variant submission form.<BR>
            <B>List of possible diseases associated with mutations in the available genes</B>: Specify a list of phenotypes that are used in this LOVD installation. This list will be put on the full legend and will allow a submitter to select a phenotype from the list. If no phenotypes are specified, the submitter will need to fill in the phenotype in a common text field.<BR>
            <B>List of available detection techniques</B>: Specify a list of detection techniques appropriate for the genes configured in this LOVD installation. By default, a full set of detection techniques have been put in this list already. This list will be put on the full legend and will allow a submitter to select the used detections technique(s) from the list. If no techniques are specified, the submitter will need to fill in the technique in a common text field.<BR>
            <BR>

<?php
include ROOT_PATH . 'inc-bot.php';
?>
