<?php
/**************************************************************************
 *
 * LOVD DATABASE WEBSITE
 *
 * Created     : 2008-07-23
 * Modified    : 2008-10-07
 * For LOVD    : 2.0-13
 *
 * Access      : Public
 *
 * Programmer  : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *************/

define('ROOT_PATH', '../../../');
define('DOCS_PATH', ROOT_PATH . 'docs/');
require DOCS_PATH . 'inc-website-init.php';
require ROOT_PATH . 'inc-top.php';
?>

            <H3>Variant and patient data</H3>
            <H4>Viewing and searching variant and patient data</H4>
            <H5>Advanced options</H5>

            The LOVD variant overviews support a range of advanced options. Not all options are available from all variant overviews.<BR>
            <BR>

            <H6>Sorting</H6>

            Sorting is available on all variant overviews and allows you to sort the data on whatever column you wish. The column currently sorted on has a darker blue background color than the other columns. Two arrows indicate which direction the values on sorted on:<BR>
            <IMG src="<?php echo ROOT_PATH; ?>gfx/order_arrow_asc_sel.png" alt="arrow pointing downwards" width="13" height="6" style="margin : 2px 0px;"> The values are sorted low to high (standard).<BR>
            <IMG src="<?php echo ROOT_PATH; ?>gfx/order_arrow_desc_sel.png" alt="arrow pointing upwards" width="13" height="6" style="margin : 2px 0px;"> The values are sorted high to low (reversed).<BR>
            <BR>

            To sort on a certain column, click on the column header or on the arrows. If that column is already selected to sort on, the sort order will be swapped.<BR>
            By default, LOVD sorts on Variant/Exon and Variant/DNA. The Variant/DNA field is interpreted to facilitate proper sorting. If sorting on any other field, LOVD will sort secondarily on Variant/Exon and Variant/DNA.<BR>
            <BR>

            <H6>Advanced search terms</H6>

            LOVD allows boolean search terms, meaning you can construct complex queries with AND, OR and NOT logic. All search terms are treated as AND by default. OR is indicated with a pipe '|' with no spaces around it and NOT is indicated by an exclamation mark '!', not followed by a space.<BR>
            <BR>

            <B>Examples</B>:<BR>
            <TABLE border="0" cellpadding="2" cellspacing="0" width="100%" style="border : 1px solid #666666;">
              <TR>
                <TD style="border-top : 3px double #666666; border-bottom : 1px solid #666666;"><I>Search terms</I></TD>
                <TD style="border-top : 3px double #666666; border-bottom : 1px solid #666666;"><I>Field</I></TD>
                <TD style="border-top : 3px double #666666; border-bottom : 1px solid #666666;"><I>Result</I></TD></TR>
              <TR>
                <TD style="border-bottom : 1px dotted #666666;">&gt;</TD>
                <TD style="border-bottom : 1px dotted #666666;">Variant/DNA</TD>
                <TD style="border-bottom : 1px dotted #666666;">Show only substitutions</TD></TR>
              <TR>
                <TD style="border-bottom : 1px dotted #666666;">A&gt;T|T&gt;A</TD>
                <TD style="border-bottom : 1px dotted #666666;">Variant/DNA</TD>
                <TD style="border-bottom : 1px dotted #666666;">Show only A to T or T to A substitutions</TD></TR>
              <TR>
                <TD style="border-bottom : 1px dotted #666666;">c.328 &gt;</TD>
                <TD style="border-bottom : 1px dotted #666666;">Variant/DNA</TD>
                <TD style="border-bottom : 1px dotted #666666;">Show only substitutions at position c.328</TD></TR>
              <TR>
                <TD style="border-bottom : 1px dotted #666666;">p.(Arg X)</TD>
                <TD style="border-bottom : 1px dotted #666666;">Variant/Protein</TD>
                <TD style="border-bottom : 1px dotted #666666;">Show only arginine to stopcodon changes</TD></TR>
              <TR>
                <TD style="border-bottom : 1px dotted #666666;">Asian</TD>
                <TD style="border-bottom : 1px dotted #666666;">Patient/Origin/Ethnic</TD>
                <TD style="border-bottom : 1px dotted #666666;">Shows "Asian", but also "Caucasian" entries</TD></TR>
              <TR>
                <TD style="border-bottom : 1px dotted #666666;">Asian !Caucasian</TD>
                <TD style="border-bottom : 1px dotted #666666;">Patient/Origin/Ethnic</TD>
                <TD style="border-bottom : 1px dotted #666666;">Shows "Asian", but no "Caucasian" entries</TD></TR>
              <TR>
                <TD>Asian|African !Caucasian</TD>
                <TD>Patient/Origin/Ethnic</TD>
                <TD>Shows "Asian" or "African", but no "Caucasian" entries</TD></TR></TABLE><BR>

            <H6>Column hiding</H6>

            The variant overviews can be personalized by temporarily hiding columns that you don't need. Especially the full overview including the patient data can get quite wide and to prevent a lot of horizontal scrolling, you can hide the columns you're currently not interested in. These settings will be stored in a cookie on your computer, so that the next time you return to LOVD the settings will remain.<BR>
            <BR>

            On the column headers of variant overviews that support this feature, there is a little red icon (<IMG src="<?php echo ROOT_PATH; ?>gfx/order_arrow_hide.png" alt="red cross" width="11" height="11">) that you can click to hide the column. The column will disappear, and leave a narrow column with an arrow (<IMG src="<?php echo ROOT_PATH; ?>gfx/order_arrow_show.png" alt="arrow" width="5" height="13">). If you click on this arrow, the column will be restored. To restore all columns all at once, click the "Unhide all columns" link.<BR>
            <BR>

<?php
include ROOT_PATH . 'inc-bot.php';
?>
