<?php
/**************************************************************************
 *
 * LOVD DATABASE WEBSITE
 *
 * Created     : 2008-08-27
 * Modified    : 2008-08-28
 * For LOVD    : 2.0-11
 *
 * Access      : Public
 *
 * Programmer  : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *************/

define('ROOT_PATH', '../');
define('DOCS_PATH', ROOT_PATH . 'docs/');
require DOCS_PATH . 'inc-website-init.php';
require ROOT_PATH . 'inc-top.php';
?>

            <H3>Keeping your data secure</H3>

            LOVD contains several important security measures to protect your data from unauthorized access. This page explains IT experts what kind of security measures are implemented in LOVD, but it also shows what you as a LOVD user can do to protect your data.<BR>
            <BR>

            <H4>Built-in security measures</H4>

            After a public request on a programmer's internet forum a LOVD installation had been subjected to various attacks and hack attempts. Furthermore, the source code has been security audited by three different software packages to ensure no security holes were left open.<BR>
            Some of the security risks LOVD protects you against, are mentioned below.<BR>
            <BR>

            <H5>Protection against SQL injection</H5>

            SQL injection is the process of including unwanted SQL database commands into a database through the manipulation of online web forms. SQL injection can be used for, amongst other things, unauthorized modification of database contents or unauthorized access to the administrator account.<BR>
            <BR>

            <H5>Protection against Cross-site scripting (XSS)</H5>

            Cross-site scripting is a vulnerability where malicious users can include Javascript code into webpages, through entering a script in web forms, or including code in variables which are being printed on the web page. This can, for instance, be used to forward a user unnoticed to a different site.<BR>
            <BR>

            <H5>Password protecting data manipulation forms</H5>

            To prevent manipulation of your variant or patient data when your computer is used by someone else while you are logged into LOVD, all data manipulation forms are password protected. Before the form can be submitted and processed, your password is required to confirm the changes.<BR>
            <BR>

            <BR>

            <H4>What you can do to protect your data</H4>

            A chain is only as strong as the weakest link. Even with all the effort we have put into making LOVD as safe as possible, some weak links may still exists. Read this section to learn about how to protect LOVD further.<BR>
            <BR>

            <OL style="margin : 0px;">
              <LI><B>Choose your password carefully and protect it.</B> Even though LOVD does include a password quality check, please take care in choosing a password that can not be guessed by others and you don't use for other systems as well. Also, don't write it down on a sticky note stuck near your computer.</LI>
              <LI><B>Don't leave your computer unattended while logged in.</B> This will give anyone who uses your computer in your absence access to the data stored in LOVD. Also, don't leave your computer unattended if you're not logged in but had your browser remember your password for you. Once you're done using LOVD, log out.</LI>
              <LI><B>Use cookies.</B> Make sure the "Use cookies for user authentication" setting in the <A href="<?php echo DOCS_PATH; ?>lovd_setup/lovd_system_settings.php">LOVD system settings</A> is enabled. Disabling it, allows others to hijack someone's user account more easily.</LI>
              <LI><B>Use SSL.</B> Ask your systems administrator to enable SSL (https) on the server your LOVD is installed on, and enable the "Use SSL only to access LOVD" option in the <A href="<?php echo DOCS_PATH; ?>lovd_setup/lovd_system_settings.php">LOVD system settings</A>. This encrypts any data exchange between you and LOVD, such as your password and sensitive patient information.</LI>
              <LI><B>Don't allow access to your LOVD files or the database to other users on the server.</B> If there are other users on the server you have LOVD hosted on, make sure they cannot access the LOVD directory or get access to the same database LOVD stores it's information in.</LI>
              <LI><B>Verify LOVD modules.</B> Modules for LOVD introduce new code in LOVD that can be malicious. Don't install a LOVD module unless you're sure it's from a trusted source.</LI>
            </OL>
            <BR>

<?php
include ROOT_PATH . 'inc-bot.php';
?>
