<?php
/*******************************************************************************
 *
 * LEIDEN OPEN VARIATION DATABASE (LOVD)
 *
 * Created     : 2008-03-17
 * Modified    : 2009-02-16
 * For LOVD    : 2.0-16
 *
 * Access      : Curators and up.
 * Purpose     : Provide additional variant edit tools; "Find & Replace" and
 *               "Copy values".
 *
 * Copyright   : 2004-2009 Leiden University Medical Center; http://www.LUMC.nl/
 * Programmer  : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *
 * This file is part of LOVD.
 *
 * LOVD is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * LOVD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LOVD; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *************/

define('ROOT_PATH', './');
require ROOT_PATH . 'inc-init.php';

if (HAS_AUTH) {
    // If authorized, check for updates.
    require ROOT_PATH . 'inc-upgrade.php';
}

// Require manager clearance.
lovd_requireAUTH(LEVEL_CURATOR);

// Need to have a gene.
if (!GENE_COUNT) {
    require ROOT_PATH . 'inc-top.php';
    lovd_showInfoTable('There are currently no databases installed.', 'stop');
    require ROOT_PATH . 'inc-bot.php';
    exit;
}





if ($_GET['action'] == 'fnr') {
    // Find & Replace: Find certain values in a specific column and replace it with a different value.

    // Require form functions.
    require ROOT_PATH . 'inc-lib-form.php';
    require ROOT_PATH . 'inc-lib-list.php'; // Only for lovd_escapeSearchTerm().

    // Find genes we're applying this to.
    $aGenes = array();
    if ($_AUTH['level'] == LEVEL_CURATOR) {
        $sQ = 'SELECT c.symbol, CONCAT(c.symbol, " (", g.gene, ")") AS gene FROM ' . TABLE_CURATES . ' AS c LEFT JOIN ' . TABLE_DBS . ' AS g USING (symbol) WHERE userid = "' . $_AUTH['userid'] . '" ORDER BY c.symbol';
    } else {
        $sQ = 'SELECT symbol, CONCAT(symbol, " (", gene, ")") AS gene FROM ' . TABLE_DBS . ' ORDER BY symbol';
    }
    $qGenes = mysql_query($sQ);
    $nGenes = mysql_num_rows($qGenes);
    while ($r = mysql_fetch_row($qGenes)) {
        $aGenes[$r[0]] = $r[1];
    }

    // Match type.
    $aTypes = array('full' => 'Field value is...', 'part' => 'Field contains...', 'start' => 'Field starts with...', 'end' => 'Field ends with...');

    if (isset($_GET['sent'])) {
        lovd_errorClean();

        // Must have gene selected.
        if (empty($_POST['genes']) || !is_array($_POST['genes'])) {
            lovd_errorAdd('Please select at least one gene to perform Find &amp; Replace on.');
        } else {
            // Gene(s) must exist!
            foreach ($_POST['genes'] as $sSymbol) {
                if (!array_key_exists($sSymbol, $aGenes)) {
                    lovd_errorAdd('Symbol not understood: ' . strip_tags($sSymbol));
                }
            }
        }

        // Mandatory fields.
        $aCheck =
                 array(
                        'col' => 'Apply find &amp; replace to',
                        'password' => 'Enter your password for authorization',
                      );

        foreach ($aCheck as $key => $val) {
            if (empty($_POST[$key])) {
                lovd_errorAdd('Please fill in the \'' . $val . '\' field.');
            }
        }

        if (empty($_POST['type']) || !array_key_exists($_POST['type'], $aTypes)) {
            lovd_errorAdd('Please fill in the \'Match type\' field.');
        }

        // If find text is empty, and type is "field value contains..." you get fucked up results.
        if (empty($_POST['find']) && $_POST['type'] == 'part') {
            lovd_errorAdd('You did not fill in a search text, but you are looking for a partial match. This will create garbage in non empty fields. Type in a text to search for or select a different match type.');
        }

        // User had to enter his/her password for authorization.
        if ($_POST['password'] && md5($_POST['password']) != $_AUTH['password']) {
            lovd_errorAdd('Please enter your correct password for authorization.');
        }

        // XSS attack prevention. Simply deny input of HTML, PHP other stuff blocked by strip_tags().
        lovd_checkXSS();

        if (!lovd_error()) {
            // First find, then replace...
            require ROOT_PATH . 'class/currdb.php';
            $aCURRDBs = array();
            $nMatched = 0;
            $nUpdated = 0;
            $nFieldTooShort = 0;
            $sTable = substr($_POST['col'], 0, strpos($_POST['col'] . '/', '/')); // Variant or Patient.

            // If Variant/ or Patient/ column, we check availability (Patient/ column actually requires just one loop).
            // Other columns will simply return no match if not mapped in the switch () below.
            // FIXME; this is way over the top. We initialize all these CURRDB's for nothing much really.
            foreach ($_POST['genes'] as $sSymbol) {
                $aCURRDBs[$sSymbol] = new CurrDB(true, $sSymbol);
                if (in_array($sTable, array('Variant', 'Patient'))) {
                    // Do we even have this column enabled?
                    if (!$aCURRDBs[$sSymbol]->colExists($_POST['col'])) {
                        // Nope.
                        unset($aCURRDBs[$sSymbol]);
                    } elseif ($_POST['replace']) {
                        // 2009-02-26; 2.0-16; Check for text input in a integer column.
                        switch ($aCURRDBs[$sSymbol]->getFieldType($_POST['col'])) {
                            case 'INT':
                                // FIXME; This allows negative values in possibly UNSIGNED integer fields.
                                if (!preg_match('/^\-?[0-9]+$/', $_POST['replace'])) {
                                    lovd_errorAdd('This field has to contain a valid numeric value.');
                                    break 2;
                                }
                                break;
                            case 'DEC':
                                // FIXME; This allows negative values in possibly UNSIGNED decimal fields.
                                if (!preg_match('/^\-?[0-9]+([.,][0-9]+)?$/', $_POST['replace'])) {
                                    lovd_errorAdd('This field has to contain a valid decimal value.');
                                    break 2;
                                }
                                break;
                            case 'DATE':
                                // FIXME; This allows negative values in possibly UNSIGNED integer fields.
                                if (!lovd_matchDate($_POST['replace'])) {
                                    lovd_errorAdd('This field has to contain a valid date value.');
                                    break 2;
                                }
                                break;
                        }
                    }
                }
            }

            // 2009-02-26; 2.0-16; SubmitterID should only allow for numeric values.
            if ($sTable == 'submitterid') {
                $_POST['find'] = str_pad($_POST['find'], 5, '0', STR_PAD_LEFT);
                if ($_POST['replace'] && (!preg_match('/^[0-9]{1,5}$/', $_POST['replace']) || $_POST['replace'] >= 65535)) {
                    lovd_errorAdd('This field has to contain a valid numeric value lower than 65535.');
                    break;
                }
            }

            if (!count($aCURRDBs)) {
                lovd_errorAdd('None of the selected genes have this column enabled!');
            } elseif (lovd_error()) {
                // 2009-02-26; 2.0-16; This will stop processing, to trow an error.
                $aCURRDBs = array();
            }

            // This will not work if we have no genes, so no check with lovd_error() necessary.
            // Check if we have matching entries.
            $sMatch = '';
            // 2008-08-01; 2.0-10; Added the slash as a delimiter in preg_quote(), to fix errors when the pattern contained a slash.
            switch ($_POST['type']) {
                case 'full':
                    // 2008-08-01; 2.0-10; Removed lovd_escapeSearchTerm() since this is not a LIKE statement.
                    $sMatch = '= "' . $_POST['find'] . '"';
                    $sPattern = '^' . preg_quote($_POST['find'], '/') . '$';
                    break;
                case 'start':
                    $sMatch = 'LIKE "' . lovd_escapeSearchTerm($_POST['find']) . '%"';
                    $sPattern = '^' . preg_quote($_POST['find'], '/');
                    break;
                case 'part':
                    $sMatch = 'LIKE "%' . lovd_escapeSearchTerm($_POST['find']) . '%"';
                    $sPattern = preg_quote($_POST['find'], '/');
                    break;
                case 'end':
                    $sMatch = 'LIKE "%' . lovd_escapeSearchTerm($_POST['find']) . '"';
                    $sPattern = preg_quote($_POST['find'], '/') . '$';
                    break;
            }

            foreach ($aCURRDBs as $sSymbol => $CurrDB) {
                $bUpdated = false;
                switch ($sTable) {
                    case 'Variant':
                        $qData = mysql_query('SELECT variantid, `'. $_POST['col'] . '` FROM ' . TABLEPREFIX . '_' . $sSymbol . '_variants WHERE `' . $_POST['col'] . '` ' . $sMatch);
                        $nMatched += mysql_num_rows($qData);
                        while ($r = mysql_fetch_row($qData)) {
                            // Find, replace & update.
                            $sNew = preg_replace('/' . $sPattern . '/', $_POST['replace'], $r[1]);
                            // 2008-08-01; 2.0-10; An error in the preg_replace could empty a whole field...
                            if ($sNew === NULL) {
                                // Preg_replace failed! Don't execute anything, but throw an error...
                                // 2009-02-16; 2.0-16; Added MySQL bit so that it will be logged properly.
                                lovd_displayError('FreeEditFNR', 'The preg_replace() in the Find &amp; Replace returned NULL. This is a bug in LOVD or in one of it\'s modules. Please <A href="' . $_SETT['upstream_URL'] . 'bugs/" target="_blank">file a bug</A> and include the below messages to help us solve the problem.<BR><BR>Tried to replace: "' . $sPattern . '"<BR>By: "' . stripslashes($_POST['replace']) . '"<BR>In: "' . stripslashes($_POST['col']) . '"', true);
                            } elseif (strlen($sNew) > $CurrDB->getFieldLength($_POST['col'])) {
                                // Do not update; result does not fit in.
                                $nFieldTooShort ++;
                            } elseif ($sNew != $r[1]) {
                                $sQ = 'UPDATE ' . TABLEPREFIX . '_' . $sSymbol . '_variants SET `' . $_POST['col'] . '` = "' . $sNew . '" WHERE variantid = "' . $r[0] . '"';
                                $q = @mysql_query($sQ);
                                if ($q) {
                                    $bUpdated = true;
                                    $nUpdated += mysql_affected_rows(); // Should be 1...
                                    @mysql_query('UPDATE ' . TABLE_PAT2VAR . ' SET edited_by = "' . $_AUTH['userid'] . '", edited_date = NOW() WHERE symbol = "' . $sSymbol . '" AND variantid = "' . $r[0] . '"');
                                } else {
                                    // Throw some error.
                                    require ROOT_PATH . 'inc-top.php';
                                    lovd_printHeader('config_free_edit_fnr', 'LOVD Configuration - Find & Replace');
                                    lovd_dbFout('FreeEditFNR', $sQ, mysql_error());
                                    require ROOT_PATH . 'inc-bot.php';
                                    exit;
                                }
                            }
                        }
                        break;

                    case 'Patient':
                    case 'submitterid':
                        $qData = mysql_query('SELECT p.patientid, p.`'. $_POST['col'] . '` FROM ' . TABLE_PATIENTS . ' AS p LEFT JOIN ' . TABLE_PAT2VAR . ' AS p2v USING (patientid) WHERE p2v.symbol = "' . $sSymbol . '" AND p.`' . $_POST['col'] . '` ' . $sMatch . ' GROUP BY p.patientid');
                        $nMatched += mysql_num_rows($qData);
                        while ($r = mysql_fetch_row($qData)) {
                            // Find, replace & update.
                            $sNew = preg_replace('/' . $sPattern . '/', $_POST['replace'], $r[1]);
                            // 2008-08-01; 2.0-10; An error in the preg_replace could empty a whole field...
                            if ($sNew === NULL) {
                                // Preg_replace failed! Don't execute anything, but throw an error...
                                // 2009-02-16; 2.0-16; Added MySQL bit so that it will be logged properly.
                                lovd_displayError('FreeEditFNR', 'The preg_replace() in the Find &amp; Replace returned NULL. This is a bug in LOVD or in one of it\'s modules. Please <A href="' . $_SETT['upstream_URL'] . 'bugs/" target="_blank">file a bug</A> and include the below messages to help us solve the problem.<BR><BR>Tried to replace: "' . $sPattern . '"<BR>By: "' . stripslashes($_POST['replace']) . '"<BR>In: "' . stripslashes($_POST['col']) . '"', true);
                            } elseif ($sTable == 'Patient' && strlen($sNew) > $CurrDB->getFieldLength($_POST['col'])) {
                                // Do not update; result does not fit in.
                                $nFieldTooShort ++;
                            } elseif ($sNew != $r[1]) {
                                $sQ = 'UPDATE ' . TABLE_PATIENTS . ' SET `' . $_POST['col'] . '` = "' . $sNew . '", edited_by = "' . $_AUTH['userid'] . '", edited_date = NOW() WHERE patientid = "' . $r[0] . '"';
                                $q = @mysql_query($sQ);
                                if ($q) {
                                    $bUpdated = true;
                                    $nUpdated += mysql_affected_rows(); // Should be 1...
                                } else {
                                    // Throw some error.
                                    require ROOT_PATH . 'inc-top.php';
                                    lovd_printHeader('config_free_edit_fnr', 'LOVD Configuration - Find & Replace');
                                    lovd_dbFout('FreeEditFNR', $sQ, mysql_error());
                                    require ROOT_PATH . 'inc-bot.php';
                                    exit;
                                }
                            }
                        }
                        break;
                }
                if ($bUpdated) {
                    // Update the DBS table, also.
                    lovd_setUpdatedDate($sSymbol);
                }
            }

            if (!lovd_error()) {
                if (!$nMatched) {
                    lovd_errorAdd('No matches found to your search!');
                } else {
                    // All OK!
                    // Write to log...
                    lovd_writeLog('MySQL:Event', 'FreeEditFNR', $_AUTH['username'] . ' (' . mysql_real_escape_string($_AUTH['name']) . ') successfully ran find &amp; replace on ' . $_POST['col'] . ' in ' . implode(', ', $_POST['genes']));

                    // Thank the user...
                    if (!$nFieldTooShort) {
                        header('Refresh: 5; url=' . PROTOCOL . $_SERVER['HTTP_HOST'] . rtrim(dirname($_SERVER['PHP_SELF']), '/') . '/config.php' . lovd_showSID());
                    }

                    require ROOT_PATH . 'inc-top.php';
                    lovd_printHeader('config_free_edit_fnr', 'LOVD Configuration - Find & Replace');
                    lovd_showInfoTable('Successfully applied find &amp; replace!<BR>Entries matched: ' . $nMatched . ', entries updated: ' . $nUpdated . '.', 'success');
                    if ($nFieldTooShort) {
                        lovd_showInfoTable($nFieldTooShort . ' entr' . ($nFieldTooShort == 1? 'y was' : 'ies were') . ' skipped because the field is too short to fit the new value in.' . ($_AUTH['level'] >= LEVEL_MANAGER? ' <A href="' . ROOT_PATH . 'setup_columns_global.php?action=edit&amp;edit=' . rawurlencode($_POST['col']) . '">Click here to increase the size of the field</A>.' : ''), 'warning');
                    }
                    require ROOT_PATH . 'inc-bot.php';
                    exit;
                }
            }
        }

        // Errors, so the whole lot returns to the form.
        lovd_magicUnquoteAll();

        // Because we're sending the data back to the form, I need to unset the password fields!
        unset($_POST['password']);

    } else {
        if ($_SESSION['currdb']) {
            $_POST['genes'] = array($_SESSION['currdb']);
        }
    }



    require ROOT_PATH . 'inc-top.php';
    lovd_printHeader('config_free_edit_fnr', 'LOVD Configuration - Find & Replace');

    lovd_showInfoTable('Find &amp; Replace applies to all values of a certain field in the database. Be extremely careful when using this function since misuse can render an entire field from the database useless. It would be wise to create a backup of the relevant gene databases first.', 'warning');

    lovd_errorPrint();

    // Table.
    print('      <FORM action="' . $_SERVER['PHP_SELF'] . '?action=' . $_GET['action'] . '&amp;sent=true" method="post">' . "\n" .
          '        <TABLE border="0" cellpadding="0" cellspacing="1" width="760">');

    // Find which column to apply this to. Because this can be applied in any of the genes, we're just going to show all columns and figure out later which gene this applies to, then.
    $aColumns = array();
    // Variant and patient columns.
    $qCols = mysql_query('SELECT colid, CONCAT(colid, " (", head_column, ")") AS head_column FROM ' . TABLE_COLS . ' ORDER BY colid');
    while ($r = mysql_fetch_row($qCols)) {
        $aColumns[$r[0]] = $r[1];
    }
    $aColumns['submitterid'] = 'submitterid (Submitter)';

    // Array which will make up the form table.
    $aForm = array(
                    array('POST', '', '', '40%', '60%'),
                    array('', 'print', '<B>Apply this action to these genes</B>'),
                    array('Select genes', 'select', 'genes', ($nGenes > 5? 5 : $nGenes), $aGenes, false, true, true),
                    'skip',
                    array('Apply find &amp; replace to', 'select', 'col', 1, $aColumns, true, false, false),
                    'skip',
                    array('Match type', 'select', 'type', 1, $aTypes, false, false, false),
                    array('Find text', 'text', 'find', 20),
                    array('Replace text', 'text', 'replace', 20),
                    'skip',
                    array('Enter your password for authorization', 'password', 'password', 20),
                    array('', 'submit', 'Find &amp; Replace'),
                  );
    $_MODULES->processForm('ConfigFreeEditFNR', $aForm);
    lovd_viewForm($aForm);

    print('</TABLE></FORM>' . "\n\n");

    require ROOT_PATH . 'inc-bot.php';
    exit;





} else {
    // Default action:
    require ROOT_PATH . 'inc-top.php';
    lovd_printHeader('config_free_edit', 'LOVD Configuration - Free edit');

    // Provide choice.
    print('            <TABLE border="0" cellpadding="2" cellspacing="0" class="setup" width="100%">' . "\n" .
          '              <TR>' . "\n" .
          '                <TD colspan="2"><B>Please select your choice</B></TD></TR>' . "\n" .
          '              <TR class="setup" onclick="window.location.href=\'' . $_SERVER['PHP_SELF'] . '?action=fnr' . lovd_showSID(true, true) . '\';">' . "\n" .
          '                <TD align="center" width="40"><IMG src="' . ROOT_PATH . 'gfx/lovd_free_edit_fnr.png" alt="Find & Replace" width="32" height="32"></TD>' . "\n" .
          '                <TD>Find &amp; Replace: Find certain values in a specific column and replace it with a different value.</TD></TR>' . "\n" .
//          '              <TR class="setup" onclick="window.location.href=\'' . $_SERVER['PHP_SELF'] . '?action=copy' . lovd_showSID(true, true) . '\';">' . "\n" .
          '              <TR style="font-size : 11px; color : #666666;">' . "\n" .
          '                <TD align="center" width="40"><IMG src="' . ROOT_PATH . 'gfx/lovd_free_edit_copy.png" alt="Copy values" width="32" height="32"></TD>' . "\n" .
          '                <TD>Copy: Copy one column\'s contents into another column (not yet available).</TD></TR></TABLE><BR>' . "\n");

    require ROOT_PATH . 'inc-bot.php';
    exit;
}
?>