<?php
/**************************************************************************
 *
 * LOVD DATABASE WEBSITE
 *
 * Created     : 2008-07-07
 * Modified    : 2009-03-10
 * For LOVD    : 2.0-17
 *
 * Access      : Public
 *
 * Programmer  : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *************/

define('ROOT_PATH', '../../../');
define('DOCS_PATH', ROOT_PATH . 'docs/');
require DOCS_PATH . 'inc-website-init.php';
require ROOT_PATH . 'inc-top.php';
?>

            <H3>LOVD Setup</H3>
            <H4>Gene databases</H4>
            <H5>Creating new genes</H5>

            Probably the first thing users want to do after installing LOVD, is creating a gene database. Then you can start adding variant and patient information to LOVD. After installing, you are forwarded to the setup area and LOVD will highlight the link to the create gene database form.<BR>
            <BR>

            The form used to create a new gene database also allows you to set a lot of gene-specific settings. The top part, "General information", is mostly mandatory to fill in. Only the "Date of creation" is optional. The entire bottom part of the form is optional.<BR>
            <BR>

            <H6>General information</H6>
            This part describes the bare essentials of the gene information; the gene name, gene symbol and chromosome location. Also the date of creation can be filled in; if you leave it empty it will default to today's date.<BR>
            <BR>

            <H6>Links to information sources (optional)</H6>
            Lots of optional information you can add about your gene, especially links to other resources such as Entrez Gene, OMIM, HGMD, GeneTests.org or any website you want. These links will be displayed on the gene homepage in the public area.<BR>
            New in LOVD 2.0 is the option to add a GenBank file to the gene. You can provide a GenBank ID, or upload your own genbank file in the LOVD genbank directory. LOVD can use this GenBank file for some optional functionalities, such as the <A href="<?php echo DOCS_PATH; ?>lovd_setup/modules/available_lovd_modules.php">Mutalyzer module</A> for nomenclature checking. As a contrast, the reference sequence is the gene's sequence formatted for display by human users.<BR>
            <BR>

            <H6>Customizations (optional)</H6>
            LOVD allows you to adapt the gene homepage by adding citation references, headers, footers, notes and a disclaimer. The header and footer will also be shown on the variant listings.<BR>
            <BR>

            <H6>Security settings</H6>
            Using the following settings you can control some security settings of LOVD. It allows you to control whether or not the public can also make downloads of your gene's variants, and whether or not you want your public data to be indexed by the <A href="http://www.wikiprofessional.org/" target="_blank">WikiProfessional</A> concept web.<BR>
            <BR>

<?php
include ROOT_PATH . 'inc-bot.php';
?>
