<?php
/*******************************************************************************
 *
 * LEIDEN OPEN VARIATION DATABASE (LOVD)
 *
 * Created     : 2006-08-15
 * Modified    : 2009-06-19
 * For LOVD    : 2.0-19
 *
 * Access      : Public
 * Purpose     : Include SQL to create the external sources list.
 *
 * Copyright   : 2004-2009 Leiden University Medical Center; http://www.LUMC.nl/
 * Programmer  : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *
 * This file is part of LOVD.
 *
 * LOVD is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * LOVD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LOVD; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *************/

// List of external biological sources.
$aSourceSQL =
         array(
                'Entrez_Gene' => 'INSERT INTO ' . TABLE_SOURCES . ' VALUES ("entrez", "http://www.ncbi.nlm.nih.gov/entrez/query.fcgi?db=gene&cmd=Retrieve&dopt=full_report&list_uids={{ ID }}")',
                'OMIM_gene' => 'INSERT INTO ' . TABLE_SOURCES . ' VALUES ("omim_gene", "http://www.ncbi.nlm.nih.gov/entrez/dispomim.cgi?id={{ ID }}")',
                'OMIM_disease' => 'INSERT INTO ' . TABLE_SOURCES . ' VALUES ("omim_disease", "http://www.ncbi.nlm.nih.gov/entrez/dispomim.cgi?id={{ ID }}")',
                'HGMD' => 'INSERT INTO ' . TABLE_SOURCES . ' VALUES ("hgmd", "http://www.hgmd.cf.ac.uk/ac/gene.php?gene={{ ID }}")',
                'Genetests' => 'INSERT INTO ' . TABLE_SOURCES . ' VALUES ("genetests", "http://www.ncbi.nlm.nih.gov/sites/GeneTests/lab/gene/{{ ID }}")',
                'GenBank' => 'INSERT INTO ' . TABLE_SOURCES . ' VALUES ("genbank", "http://www.ncbi.nlm.nih.gov/entrez/viewer.fcgi?db=nucleotide&sendto=t&extrafeatpresent=1&list_uids={{ ID }}")',
              );
?>