<?php
/*******************************************************************************
 *
 * LEIDEN OPEN VARIATION DATABASE (LOVD)
 *
 * Created     : 2009-03-09
 * Modified    : 2009-06-26
 * For LOVD    : 2.0-19
 *
 * Access      : Administrator and managers.
 * Purpose     : Provide JavaScript for checking the database URL.
 *
 * Copyright   : 2004-2009 Leiden University Medical Center; http://www.LUMC.nl/
 * Programmer  : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *
 * This file is part of LOVD.
 *
 * LOVD is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * LOVD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LOVD; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *************/

define('ROOT_PATH', './');
require ROOT_PATH . 'inc-init.php';

// Stupid solution, but because of the (sane) JS restrictions to access files on other domains, I have to do it this way.
if (isset($_GET['check'])) {
    if (empty($_GET['check'])) {
        readfile($_SETT['check_location_URL'] . '?url=' . rawurlencode(PROTOCOL . $_SERVER['HTTP_HOST'] . lovd_cleanDirName(dirname($_SERVER['PHP_SELF']) . '/' . ROOT_PATH)));
    } else {
        readfile($_SETT['check_location_URL'] . '?url=' . rawurlencode(rtrim($_GET['check'], '/') . '/'));
    }
    exit;
}
?>
function lovd_checkURL () {
    var objField = document.getElementById('location_url');
    var objCheck = document.getElementById('location_url_check');

    // Reset (check) link.
    // 2009-06-26; 2.0-19; Fixed URL such that it works from all locations.
    objCheck.innerHTML = '<IMG src="<?php echo PROTOCOL . $_SERVER['HTTP_HOST'] . lovd_cleanDirName(dirname($_SERVER['PHP_SELF']) . '/' . ROOT_PATH); ?>gfx/lovd_loading.gif" align="top">';

    // Create HTTP request object to contact the LOVD website to verify the database URL.
    var objHTTP;
    try {
        // W3C standard.
        objHTTP = new XMLHttpRequest();
    } catch (e) {
        // Internet Explorer?
        try {
            objHTTP = new ActiveXObject("Msxml2.XMLHTTP");
        } catch (e) {
            try {
                objHTTP = new ActiveXObject("Microsoft.XMLHTTP");
            } catch (e) {
                // Ok, last try!
                try {
                    objHTTP = window.createRequest();
                } catch (e) {
                    // Never mind.
                    objHTTP = false;
                }
            }
        }
    }

    if (objHTTP) {
        // 2009-06-26; 2.0-19; Fixed URL such that it works from all locations.
        objHTTP.open("GET", "<?php echo PROTOCOL . $_SERVER['HTTP_HOST'] . lovd_cleanDirName(dirname($_SERVER['PHP_SELF']) . '/' . ROOT_PATH); ?>inc-js-database_url.php?check=" + escape(objField.value), false);
        objHTTP.send(null);
        if (objHTTP.status == 200 && objHTTP.responseText.substring(0,4) == "http") {
            objField.value = objHTTP.responseText;
            // 2009-06-26; 2.0-19; Fixed URL such that it works from all locations.
            objCheck.innerHTML = '<IMG src="<?php echo PROTOCOL . $_SERVER['HTTP_HOST'] . lovd_cleanDirName(dirname($_SERVER['PHP_SELF']) . '/' . ROOT_PATH); ?>gfx/mark_1.png" align="top">';
        } else {
            // Throw error.
            if (!objField.value) {
                // Well no, we were just trying the automated values. So, it doesn't work. Big deal.
                window.alert("Please fill in a value in this field.");
            } else {
                window.alert("Error!\n" + objHTTP.responseText);
            }
            objCheck.innerHTML = '(<A href="#" onclick="javascript:lovd_checkURL(); return false;">check</A>)';
        }

    } else {
        // Change "loading" image with a clean "Failed" image.
        window.alert("Sorry, your browser does not support automated verification of the URL.");
        // 2009-06-26; 2.0-19; Fixed URL such that it works from all locations.
        objCheck.innerHTML = '<IMG src="<?php echo PROTOCOL . $_SERVER['HTTP_HOST'] . lovd_cleanDirName(dirname($_SERVER['PHP_SELF']) . '/' . ROOT_PATH); ?>gfx/mark_0.png" align="top">';
    }
}
