<?php
/**************************************************************************
 *
 * LOVD DATABASE WEBSITE
 *
 * Created     : 2008-07-02
 * Modified    : 2009-02-03
 * For LOVD    : 2.0-12
 *
 * Access      : Public
 *
 * Programmer  : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *************/

define('ROOT_PATH', '../');
define('DOCS_PATH', ROOT_PATH . 'docs/');
require DOCS_PATH . 'inc-website-init.php';
require ROOT_PATH . 'inc-top.php';
?>

            <H3>Introduction</H3>

            LOVD stands for <B>L</B>eiden <B>O</B>pen (source) <B>V</B>ariation <B>D</B>atabase. LOVD is designed to provide a flexible, freely available tool for gene-centered collection and display of DNA variations.<BR>
            <BR>

            LOVD was developed approaching the &quot;LSDB-in-a-Box&quot; idea for the easy creation and maintenance of a fully web-based gene sequence variation database, that is platform-independent and uses PHP and MySQL open source software only. The basic gene-centered and modular design of the database follows the recommendations of the Human Genome Variation Society (HGVS) and focuses on the collection and display of the DNA sequence variations but it is extendable with clinical data with minimal effort. The open LOVD set up also facilitates functional extensions with scripts written by the community.<BR>
            <BR>

            The development of (then nameless) LOVD started in late 2002, while it was first officially released in January, 2004. Before that LOVD was only in use by the <A href="http://www.DMD.nl/" target="_blank">Leiden Muscular Dystrophy pages</A>, as a not-so-modular system with lots of characteristics specific for that website only. With the official release of LOVD in 2004 the system had become much more dynamic and customizing LOVD was made easy mostly by editing text-files.<BR>
            In 2004, LOVD became available under the open source license GPL and with the 1.1.0 release most of the text-files had been replaced by online forms so customisations can be performed through the web interface. Early in 2005 the LOVD article was published, and in 2005 the development of LOVD was more targeted at improving the ease of use of the system.<BR>
            <BR>

            In 2006 the development of LOVD 2.0 started after the decision was made to rewrite all of LOVD from scratch to be able to include a long list of upgrade suggestions that were hard to implement in LOVD 1.1.0. Aimed at modularity and data redundancy, LOVD 2.0 was meant to be a more flexible and more powerful successor of the popular 1.1.0 version and soon it received the interest of LOVD users eager to try out the all-new version.<BR>
            LOVD 2.0 reached alpha stage in November 2006 after which a select group of enthusiastic LOVD users started testing the database software. With more features being added and bugs fixed rapidly, LOVD 2.0 reached beta stage in April 2007, after which more and more users started to upgrade their 1.1.0 databases to 2.0. Finally, in October 2007 LOVD 2.0 reached the stable stage but even now LOVD 2.0 is continuously improved. Every last Friday of the month, a new release is available from the LOVD website.<BR>
            <BR>

<?php
include ROOT_PATH . 'inc-bot.php';
?>
