/*******************************************************************************<?php/*
 *
 * LEIDEN OPEN VARIATION DATABASE (LOVD)
 *
 * Created     : 2008-12-05
 * Modified    : 2008-12-05
 * Version     : 0.1
 * For LOVD    : 2.0-15
 *
 * Copyright   : 2004-2008 Leiden University Medical Center; http://www.LUMC.nl/
 * Programmer  : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *
 * This file is part of LOVD.
 *
 * LOVD is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * LOVD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LOVD; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *************/

class recaptcha {
    function getInfo ()
    {
        return
             array(
                    'name' => 'LOVD reCAPTCHA security module',
                    'version' => '0.1',
                    'description' => 'LOVD module that uses a CAPTCHA (Completely Automated Public Turing test to tell Computers and Humans Apart) module to protect the submitter registration form from bots to register themselves.',
                    'settings' => array(),
                  );
    }



    function enable ()
    {
        // Will be run when module is getting enabled.
        /*
        $aSett = $GLOBALS['_MODULES']->getSettings('recaptcha');
        $GLOBALS['_MODULES']->setSettings('recaptcha', $aSett);
        */
    }



    function processForm ($sForm, & $aForm)
    {
        // Process LOVD form data before it gets to the screen.
        // Currently, the recaptcha library has been loaded by submitters.php.
        global $sCAPTCHAerror;

        if ($sForm == 'SubmittersRegister') {
            $aSett = $GLOBALS['_MODULES']->getSettings('recaptcha');

            $aReturn = array();
            foreach ($aForm as $nItem => $aItem) {
                // Line by line, go through the form.
                if ($aItem[1] == 'submit') {
                    // Add reCAPTCHA here about the last DB ID.
                    $aReturn[] = array('Please fill in the two words that you see in the image', 'print', recaptcha_get_html('6Le0JQQAAAAAAPQ55JT0m0_AVX5RqgSnHBplWHxZ', $sCAPTCHAerror, SSL));
                    $aReturn[] = 'skip';
                }
                $aReturn[] = $aItem;
            }
            $aForm = $aReturn;
            return true;
        }
        return false;
    }
}