<?php
/**************************************************************************
 *
 * LOVD DATABASE WEBSITE
 *
 * Created     : 2008-07-09
 * Modified    : 2009-04-24
 * For LOVD    : 2.0-18
 *
 * Access      : Public
 *
 * Programmer  : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *************/

define('ROOT_PATH', '../../../');
define('DOCS_PATH', ROOT_PATH . 'docs/');
require DOCS_PATH . 'inc-website-init.php';
require ROOT_PATH . 'inc-top.php';
?>

            <H3>LOVD Setup</H3>
            <H4>Custom columns</H4>
            <H5>Editing custom column default settings</H5>

            After a custom column is added to a variant table or the patient table, part of the settings can be edited by curators or managers. But the default column settings are stored separately and cannot be edited by curators for three reasons:<BR>
            <UL style="margin : 0px;">
              <LI>Variant columns can have different appearance settings per gene.</LI>
              <LI>Curators can modify some basic settings, but do not have permissions to edit the more advanced settings.</LI>
              <LI>If a column's settings are screwed up for whatever reason, they can be reset to default settings which can be defined by a manager.</LI>
            </UL>
            <BR>

            Because of this separation of settings, by default not all changes you make will take effect if the column has also been added to a variant table or the patient table, because some changes are overridden by the local display settings of that column. Changes to some advanced options do take effect immediately, like the MySQL data type and form field type. You can do two things to apply all of your changes also to selected columns;<BR>
            <UL style="margin : 0px;">
              <LI>You can (one by one) reset a selected column to the (new) default settings, to easily apply your changes to a selected column in a variant table or the patient table.</LI>
              <LI>You can have your changes applied immediately by overriding all local display settings, by selecting the checkbox "Apply changes to patient table where this column is active" in case of a patient table or "Apply changes to all genes where this column is active" in case of a variant table. This checkbox will only appear if the column has actually been added to any of the tables.</LI>
            </UL>
            <BR>

            <B>Edit column default settings</B><BR>
            To edit the custom column default settings, click the "Manage all custom column default settings" link in the setup area, select the column of interest and click the "Edit column default settings" link. The fields on this form are explained in the <A href="<?php echo DOCS_PATH; ?>lovd_setup/custom_columns/creating_new_columns.php">creating new columns</A> section.<BR>
            <BR>

            <B>Edit column ID</B> (columns created by users only)<BR>
            For columns which have been created by users of LOVD, you can change the column ID (the name the column is referenced by the system, such as "Variant/DNA") or move the column from the Patient to the Variant side or vice-versa, only if the column is currently not in use in the Patient table or any of the Variant tables. Click the "Manage all custom column default settings" link in the setup area, select the column of interest, click the "Edit column ID" link and complete the form.<BR>
            <BR>

<?php
lovd_showInfoTable('This feature was added in LOVD 2.0-15, released 2009-02-03.', 'information');
?>

<?php
include ROOT_PATH . 'inc-bot.php';
?>
