<?php
/**************************************************************************
 *
 * LOVD DATABASE WEBSITE
 *
 * Created     : 2009-09-16
 * Modified    : 2009-09-16
 * For LOVD    : 2.0-22
 *
 * Access      : Public
 *
 * Programmer  : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *************/

define('ROOT_PATH', '../');
define('DOCS_PATH', ROOT_PATH . 'docs/');
require DOCS_PATH . 'inc-website-init.php';
require ROOT_PATH . 'inc-top.php';
?>

            <H3>Gene homepage</H3>

            LOVD automatically generates a gene homepage for every gene created within LOVD. On this homepage you can find general information on the gene, including links to a list of all PubMed references in the database and a RSS feed subscription link for updates of the gene, combined with links to the sequence variant tables, link to search forms and links to other external resources.<BR>
            <BR>

            If the gene database contains variants, LOVD shows a second table titled "Sequence variant tables". It contains links to four different overviews, which are described in detail in the <A href="variant_and_patient_data/viewing_and_searching_variant_and_patient_data.php">Viewing and searching variant and patient data</A> section. Optionally, a download link is also added to the table, with which you can download all of the variant and patient information in the database.<BR>
            The unique sequence variants listing shows all unique sequence variants in the database, but no patient data. The complete sequence variant listing will show all variants in the database in combination with the patient data associated with them. The <A href="variant_and_patient_data/database_statistics.php">summary tables</A> show statistics on all sequence variants in the database, including graphs on the distribution of variants over the gene and the different variant types. The listing of variants with no known pathogenicity shows all variants that do not appear to have any pathogenic effect on the patient.<BR>
            <BR>

            Also links to search forms are provided on the gene homepage if the gene database contains data. A third table shows four or five links, depending on the database settings. The first three links (type of variant, simple search, advanced search) provide search forms with increasing number of fields. The results of your search will be displayed in the 'full database search' variant listing, where you can add more search terms if you like.<BR>
            The variant listing based on patient origin only works if origin fields have been enabled. If enabled, you can create an overview of all variants and patients from a certain geographical or ethnic origin. More information on this overview can ben found in the <A href="variant_and_patient_data/viewing_and_searching_variant_and_patient_data.php">Viewing and searching variant and patient data</A> section.<BR>
            And finally, if enabled, an option is presented to search through all (including hidden) data to return the number of entries matching your search terms. This overview allows you for instance to quickly check if a certain variant is already included in the database (even if it's not yet public) or the amount of entries associated with a certain reference.<BR>
            <BR>

            The "Links to other resources" table can contain any number of links to external sources, as configured by the gene's curator(s). Examples of external sources that LOVD can link to easily are Entrez Gene, OMIM, UniProtKB, HGMD, GeneCards and GeneTests.<BR>
            <BR>

<?php
include ROOT_PATH . 'inc-bot.php';
?>
