<?php
/*******************************************************************************
 *
 * LEIDEN OPEN VARIATION DATABASE (LOVD)
 *
 * Created     : 2006-01-27
 * Modified    : 2009-11-13
 * For LOVD    : 2.0-23
 *
 * Access      : Public
 * Purpose     : Provide bottom include file including footer.
 *
 * Copyright   : 2004-2009 Leiden University Medical Center; http://www.LUMC.nl/
 * Programmer  : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *
 * This file is part of LOVD.
 *
 * LOVD is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * LOVD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LOVD; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *************/

// Don't allow direct access.
if (!defined('ROOT_PATH')) {
    exit;
}

// Special case for the documents section. Previous and Next link.
if (substr(lovd_getProjectFile(), 0, 6) == '/docs/' && !empty($_PAGES)) {
    // Yep, documentation section.
    list($aPrev, $aNext) = lovd_findPrevNext($_PAGES, lovd_cleanDirName(dirname($_SERVER['PHP_SELF']) . '/' . DOCS_PATH));

    if (is_array($aPrev)) {
        $sLinkPrev = '&laquo; <A href="' . $aPrev[0] . '">' . $aPrev[1] . '</A>';
    } else {
        $sLinkPrev = '&nbsp;';
    }
    if (is_array($aNext)) {
        $sLinkNext = '<A href="' . $aNext[0] . '">' . $aNext[1] . '</A> &raquo;';
    } else {
        $sLinkNext = '&nbsp;';
    }
    print('      <TABLE border="0" cellspacing="0" cellpadding="0" width="100%">' . "\n" .
          '        <TR>' . "\n" .
          '          <TD width="50%">' . $sLinkPrev . '</TD>' . "\n" .
          '          <TD width="50%" align="right">' . $sLinkNext . '</TD></TR></TABLE><BR>' . "\n");
}
?>








    </TD>
  </TR>
</TABLE>
</DIV>
<BR>

<TABLE border="0" cellpadding="0" cellspacing="0" width="100%" class="footer">
  <TR>
    <TD width="84">
      &nbsp;
    </TD>
    <TD align="center">
<?php
if (substr(lovd_getProjectFile(), 0, 6) == '/docs/') {
    // In documents section.
    print('  For the latest version of the LOVD manual, <A href="http://www.LOVD.nl/2.0/docs/" target="_blank">check the online version</A>.<BR>' . "\n");
    
}
print('  Powered by <A href="' . $_SETT['upstream_URL'] . $_STAT['tree'] . '/" target="_blank">LOVD v.' . $_STAT['tree'] . '</A> Build ' . $_STAT['build'] . '<BR>' . "\n" .
      (isset($_MODULES) && count($_MODULES->getModuleList(true))? '  Enabled modules: ' . implode(', ', $_MODULES->getModuleList(true)) . '<BR>' . "\n" : '') .
      '  &copy;2004-2009 <A href="http://www.lumc.nl/" target="_blank">Leiden University Medical Center</A>' . "\n");
?>
    </TD>
    <TD width="42" align="right">
      <IMG src="<?php echo ROOT_PATH; ?>gfx/lovd_mapping_99.png" alt="" title="" width="32" height="32" id="mapping_progress" style="margin : 5px;">
    </TD>
    <TD width="42" align="right">
<?php
// FIXME: Can't check on HAS_AUTH, because after log out this constant is still set.
if (!defined('_NOT_INSTALLED_')) {
    if (HAS_AUTH) {
        print('      <A href="#" onclick="lovd_openWindow(\'' . ROOT_PATH . 'check_update.php' . lovd_showSID() . '\', \'CheckUpdate\', 650, 175); return false;"><IMG src="' . ROOT_PATH . 'check_update.php?icon" alt="" width="32" height="32" border="0" style="margin : 5px;"></A>' . "\n");
    } else {
        print('      <IMG src="' . ROOT_PATH . 'check_update.php?icon" alt="" width="32" height="32" style="margin : 5px;">' . "\n");
    }
}
?>
    </TD>
  </TR>
</TABLE>

</TD></TR></TABLE>

<SCRIPT type="text/javascript">
  <!--
  objImg = document.getElementById('mapping_progress');
<?php
// 2009-11-13; 2.0-23; Map variants to the genome in the background...
// Define function that will request the mapping of the variants. It will return a gene name, and a percentage (in 6.25% parts).
// That data is used then by this JS function to reload the image. Almost inmediately, it will repeat itself.
// This will be used to link to the UCSC browser, and both the c. and g. locations can be used in the API/webservice.
require ROOT_PATH . 'inc-js-ajax.php';

print('
function lovd_mapVariants () {
    // Request file that will do the actual work.
    objHTTP = lovd_HTTPRequest("' . PROTOCOL . $_SERVER['HTTP_HOST'] . lovd_cleanDirName(dirname($_SERVER['SCRIPT_NAME']) . '/' . ROOT_PATH) . 'ajax-map_variants.php");

    if (!objHTTP || objHTTP.status != 200) {
            // Don\'t try again.
            objImg.src = "' . ROOT_PATH . 'gfx/lovd_mapping_99.png";
            objImg.title = "There was a problem with LOVD while mapping variants to the genome.";
    } else {
        aResponse = objHTTP.responseText.split("\t");
        objImg.src = "' . ROOT_PATH . 'gfx/lovd_mapping_" + aResponse[0] + ".png";
        objImg.title = aResponse[1];

        if (aResponse[1] != "All done!") {
            setTimeout("lovd_mapVariants()", 50);
        } else {
            objImg.setAttribute("onclick", "lovd_mapVariants();");
        }
    }
}

');

// Not every page request should trigger the mapping... if it is longer than one day ago that mapping was complete, we will start again.
if (empty($_SESSION['mapping']['time_complete']) || $_SESSION['mapping']['time_complete'] < (time() - 60*60*24)) {
    $_SESSION['mapping']['genes'] = lovd_getGeneList();
    print('setTimeout("lovd_mapVariants()", 500);' . "\n");
} else {
    // If we won't start it, the user should be able to start it himself.
    // W3C only... Too bad, IE.
    print('objImg.setAttribute("onclick", "lovd_mapVariants();");' . "\n");
}

?>
  // -->
</SCRIPT>

</BODY>
</HTML>
