<?php
/*******************************************************************************
 *
 * LEIDEN OPEN VARIATION DATABASE (LOVD)
 *
 * Created     : 2006-04-25
 * Modified    : 2008-09-04
 * For LOVD    : 2.0-12
 *
 * Access      : Submitters and up.
 * Purpose     : Log the user out.
 *
 * Copyright   : 2004-2009 Leiden University Medical Center; http://www.LUMC.nl/
 * Programmer  : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *
 * This file is part of LOVD.
 *
 * LOVD is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * LOVD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LOVD; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *************/

define('ROOT_PATH', './');
require ROOT_PATH . 'inc-init.php';

// Log out of the system.
if (!$_AUTH) {
    header('Location: ' . PROTOCOL . $_SERVER['HTTP_HOST'] . rtrim(dirname($_SERVER['PHP_SELF']), '/') . '/index.php' . lovd_showSID());
    exit;
}

@mysql_query('UPDATE ' . TABLE_USERS . ' SET phpsessid = "" WHERE userid = "' . $_AUTH['userid'] . '"');
$nSec = time() - strtotime($_AUTH['last_login']);
$sCurrDB = $_SESSION['currdb']; // Temp storage.
$_SESSION = array(); // Delete variables both from $_SESSION and from session file.
if (isset($_COOKIE[session_name()])) {
    setcookie(session_name(), '', time() - 172800); // 'Delete' the cookie.
}
session_destroy();   // Destroy session, delete the session file.
$_SUBS = $_AUTH = false;

$_SESSION['currdb'] = $sCurrDB; // Put it back.
require ROOT_PATH . 'inc-top.php';
lovd_printHeader('account_logout', 'Account - Log out');

print('      You are successfully logged out.<BR>' . "\n");

$aTimes =
         array(
                array( 1, 'sec', 'sec'),
                array(60, 'min', 'min'),
                array(60, 'hr', 'hrs'),
                array(24, 'day', 'days'),
              );

foreach ($aTimes as $n => $aTime) {
    if ($n) {
        $aTimes[$n][0] = $aTime[0] * $aTimes[$n-1][0];
    }
}
$aTimes = array_reverse($aTimes);

$sPrint = '';
foreach ($aTimes as $n => $aTime) {
    if ($nSec >= $aTime[0]) {
        $nAmount = floor($nSec / $aTime[0]);
        $nSec = $nSec % $aTime[0];
        $sPrint .= ($sPrint? ', ' : '') . $nAmount . ' ' . ($nAmount == 1? $aTime[1] : $aTime[2]);
    }
}

print('      You\'ve been online for ' . $sPrint . '.' . "\n" .
      '      <SCRIPT type="text/javascript">' . "\n" .
      '        <!--' . "\n" .
      '        setTimeout("window.location.href = \'' . PROTOCOL . $_SERVER['HTTP_HOST'] . rtrim(dirname($_SERVER['PHP_SELF']), '/') . '/index.php' . lovd_showSID() . '\'", 5000);' . "\n" .
      '        // -->' . "\n" .
      '      </SCRIPT>' . "\n\n");

require ROOT_PATH . 'inc-bot.php';
exit;
?>