<?php
/*******************************************************************************
 *
 * LEIDEN OPEN VARIATION DATABASE (LOVD)
 *
 * Created     : 2006-11-07
 * Modified    : 2009-11-25
 * For LOVD    : 2.0-23
 *
 * Access      : Curators and up.
 * Purpose     : Provide links to gene configuration actions to curators.
 *
 * Copyright   : 2004-2009 Leiden University Medical Center; http://www.LUMC.nl/
 * Programmer  : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *
 * This file is part of LOVD.
 *
 * LOVD is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * LOVD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LOVD; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *************/

define('ROOT_PATH', './');
require ROOT_PATH . 'inc-init.php';

if (HAS_AUTH) {
    // If authorized, check for updates.
    require ROOT_PATH . 'inc-upgrade.php';
}

require ROOT_PATH . 'inc-top.php';
lovd_printHeader('config', 'LOVD Configuration area');

// Require curator clearance.
lovd_requireAUTH(LEVEL_CURATOR);

// If no gene selected, present the selection list.
if (!$_SESSION['currdb'] || $_GET['action'] == 'switch_db') {
    lovd_switchDB();
}

// Needs to be curator for THIS gene.
if (!lovd_isCurator($_SESSION['currdb'])) {
    // NOTE that this does not unset certain links in the top menu. Links are available.
    lovd_showInfoTable((GENE_COUNT? 'You are not allowed access to ' . (GENE_COUNT > 1? 'this gene database' : 'the installed gene database') . '. Please contact your manager or the administrator to grant you access.' : 'There are currently no databases installed.'), 'stop');
    require ROOT_PATH . 'inc-bot.php';
    exit;
}





// Some info & statistics.
$aTotalVars   = array(STATUS_NEW => 0, STATUS_HIDDEN => 0, STATUS_MARKED => 0, STATUS_OK => 0);
$nTotalVars   = 0;
$q = mysql_query('SELECT COUNT(*), status FROM ' . TABLE_PAT2VAR . ' WHERE symbol = "' . $_SESSION['currdb'] . '" GROUP BY status ORDER BY status');
while ($r = mysql_fetch_row($q)) {
    $aTotalVars[$r[1]] = $r[0];
    $nTotalVars += $r[0];
}

print('            <TABLE border="0" cellpadding="2" cellspacing="0" class="setup" width="100%">' . "\n" .
      '              <TR>' . "\n" .
      '                <TD colspan="' . (count($aTotalVars) + 1) . '"><B>Variants</B></TD>' . "\n" .
      '                <TD colspan="2"><B>Quicklinks</B></TD></TR>' . "\n" .
      '              <TR class="S11">' . "\n" .
      '                <TD>Total:' . $nTotalVars . '</TD>');
foreach ($aTotalVars as $nStatus => $nVars) {
    print("\n" .
          '                <TD>' . $_SETT['var_status'][$nStatus] . ':' . $nVars . '</TD>');
}
print("\n" .
      '                <TD><A href="' . ROOT_PATH . 'variants.php?action=search_all&amp;search_status_=Marked%7CPublic%20%21Non">Curated:' . (int) ($aTotalVars[STATUS_MARKED] + $aTotalVars[STATUS_OK]) . '</A></TD>' . "\n" .
      '                <TD><A href="' . ROOT_PATH . 'variants.php?action=search_all&amp;search_status_=Submitted%7CNon%7CMarked">Uncurated:' . (int) ($aTotalVars[STATUS_NEW] + $aTotalVars[STATUS_HIDDEN] + $aTotalVars[STATUS_MARKED]) . '</A></TD></TR></TABLE><BR>' . "\n\n");



// 2009-11-25; 2.0-23; Try to explain to curators how important it is to get a reference sequence set up!
if (!$_SETT['currdb']['genbank'] || !$_SETT['currdb']['refseq_genomic'] || !$_SETT['currdb']['refseq_mrna']) {
    lovd_showInfoTable('Not all GenBank reference sequence settings are configured properly for the ' . $_SESSION['currdb'] . ' gene database, please check them <A href="' . ROOT_PATH . 'config_genes.php?action=manage">here</A>. Without a reference sequence for this gene database, submitters cannot check their submissions to this database and in case of multi-transcript genes, variants in this gene database cannot be interpreted properly. Please check your gene database settings and provide the reference sequence information.', 'question');
}



// Setup main table.
print('      <TABLE border="0" cellpadding="0" cellspacing="0" width="100%">' . "\n" .
      '        <TR>' . "\n" .
      '          <TD valign="top" width="50%" style="padding-right : 10px; border-right : 1px solid #224488;">' . "\n");



// Curate entries.
print('            <TABLE border="0" cellpadding="2" cellspacing="0" class="setup" width="100%">' . "\n" .
      '              <TR>' . "\n" .
      '                <TD colspan="2"><B>Curating ' . $_SESSION['currdb'] . ' variants</B></TD></TR>' . "\n" .
      '              <TR class="setup" onclick="window.location.href=\'' . ROOT_PATH . 'variants.php?action=search_all&amp;search_status_=Submitted%7CNon%7CMarked' . lovd_showSID(true, true) . '\';">' . "\n" .
      '                <TD align="center" width="40"><IMG src="' . ROOT_PATH . 'gfx/lovd_variants_curate.png" alt="Curate ' . $_SESSION['currdb'] . ' variants" width="32" height="32"></TD>' . "\n" .
      '                <TD>View all uncurated entries in the ' . $_SESSION['currdb'] . ' gene database (newly submitted, non public and marked entries).</TD></TR>' . "\n" .
      '              <TR class="setup" onclick="window.location.href=\'' . ROOT_PATH . 'variants.php?action=view_all' . lovd_showSID(true, true) . '\';">' . "\n" .
      '                <TD align="center" width="40"><IMG src="' . ROOT_PATH . 'gfx/lovd_variants_edit.png" alt="Edit ' . $_SESSION['currdb'] . ' variants" width="32" height="32"></TD>' . "\n" .
      '                <TD>View all entries in the ' . $_SESSION['currdb'] . ' gene database.</TD></TR>' . "\n" .
      '              <TR class="setup" onclick="javascript:if(!confirm(\'Curate (publish) all marked and non-public variants?\\n\\nAll variants will be checked, and published only if no problems have been found.\\nPlease note that this process may take some time, if your database contains a lot of uncurated variants.\')){return false;}else{window.location.href=\'' . ROOT_PATH . 'config_variants.php?action=curate_all' . lovd_showSID(true, true) . '\';}">' . "\n" .
      '                <TD align="center" width="40"><IMG src="' . ROOT_PATH . 'gfx/lovd_variants_curate_all.png" alt="Curate all ' . $_SESSION['currdb'] . ' non-public variants" width="32" height="32"></TD>' . "\n" .
      '                <TD>Curate (publish) all marked and non-public entries in the ' . $_SESSION['currdb'] . ' gene database.</TD></TR></TABLE><BR>' . "\n");



// Free edit.
print('            <TABLE border="0" cellpadding="2" cellspacing="0" class="setup" width="100%">' . "\n" .
      '              <TR>' . "\n" .
      '                <TD colspan="2"><B>Free Edit - Advanced edit features</B></TD></TR>' . "\n" .
      '              <TR class="setup" onclick="window.location.href=\'' . ROOT_PATH . 'config_free_edit.php?action=fnr' . lovd_showSID(true, true) . '\';">' . "\n" .
      '                <TD align="center" width="40"><IMG src="' . ROOT_PATH . 'gfx/lovd_free_edit_fnr.png" alt="Find & Replace" width="32" height="32"></TD>' . "\n" .
      '                <TD>Find &amp; Replace: Find a certain value in a specific column and replace it with a different value.</TD></TR>' . "\n" .
      '              <TR class="setup" onclick="window.location.href=\'' . ROOT_PATH . 'config_free_edit.php?action=copy' . lovd_showSID(true, true) . '\';">' . "\n" .
      '                <TD align="center" width="40"><IMG src="' . ROOT_PATH . 'gfx/lovd_free_edit_copy.png" alt="Copy Column" width="32" height="32"></TD>' . "\n" .
      '                <TD>Copy Column: Copy or move one column\'s contents into another column.</TD></TR></TABLE><BR>' . "\n");



// Custom columns.
print('            <TABLE border="0" cellpadding="2" cellspacing="0" class="setup" width="100%">' . "\n" .
      '              <TR>' . "\n" .
      '                <TD colspan="2"><B>Custom columns for ' . $_SESSION['currdb'] . '</B></TD></TR>' . "\n" .
      '              <TR class="setup" onclick="window.location.href=\'' . ROOT_PATH . 'config_columns.php?action=add' . lovd_showSID(true, true) . '\';">' . "\n" .
      '                <TD align="center" width="40"><IMG src="' . ROOT_PATH . 'gfx/lovd_columns_add.png" alt="Add pre-configured custom column to the ' . $_SESSION['currdb'] . ' gene" width="32" height="32"></TD>' . "\n" .
      '                <TD>Add unselected pre-configured custom column to the ' . $_SESSION['currdb'] . ' gene.</TD></TR>' . "\n" .
      '              <TR class="setup" onclick="window.location.href=\'' . ROOT_PATH . 'config_columns.php?action=view_all' . lovd_showSID(true, true) . '\';">' . "\n" .
      '                <TD align="center" width="40"><IMG src="' . ROOT_PATH . 'gfx/lovd_columns_edit.png" alt="Manage custom columns in the ' . $_SESSION['currdb'] . ' gene" width="32" height="32"></TD>' . "\n" .
      '                <TD>Manage selected custom columns in the ' . $_SESSION['currdb'] . ' gene.</TD></TR></TABLE>' . "\n");



print('          </TD>' . "\n" .
      '          <TD valign="top" width="50%" style="padding-left : 10px;">' . "\n");



// Gene databases.
print('            <TABLE border="0" cellpadding="2" cellspacing="0" class="setup" width="100%">' . "\n" .
      '              <TR>' . "\n" .
      '                <TD colspan="2"><B>Gene settings</B></TD></TR>' . "\n" .
      '              <TR class="setup" onclick="window.location.href=\'' . ROOT_PATH . 'config_genes.php?action=manage\';">' . "\n" .
      '                <TD align="center" width="40"><IMG src="' . ROOT_PATH . 'gfx/lovd_database_edit.png" alt="Edit ' . $_SESSION['currdb'] . ' gene database" width="32" height="32"></TD>' . "\n" .
      '                <TD>Edit ' . $_SESSION['currdb'] . ' gene database.</TD></TR>' .
      (!$nTotalVars? '' : "\n" .
      '              <TR class="setup" onclick="window.location.href=\'' . ROOT_PATH . 'config_genes.php?action=empty\';">' . "\n" .
      '                <TD align="center" width="40"><IMG src="' . ROOT_PATH . 'gfx/lovd_database_empty.png" alt="Empty ' . $_SESSION['currdb'] . ' gene database" width="32" height="32"></TD>' . "\n" .
      '                <TD>Empty ' . $_SESSION['currdb'] . ' gene database (remove all variants).</TD></TR>') .
      '</TABLE><BR>' . "\n");

// Download & Import.
print('            <TABLE border="0" cellpadding="2" cellspacing="0" class="setup" width="100%">' . "\n" .
      '              <TR>' . "\n" .
      '                <TD colspan="2"><B>Download/Import variant and patient data</B></TD></TR>' .
      (!$nTotalVars? '' : "\n" .
      '              <TR class="setup" onclick="window.location.href=\'' . ROOT_PATH . 'download.php?action=view_all\';">' . "\n" .
      '                <TD align="center" width="40"><IMG src="' . ROOT_PATH . 'gfx/lovd_save.png" alt="Download all data from the ' . $_SESSION['currdb'] . ' gene database" width="32" height="32"></TD>' . "\n" .
      '                <TD>Download all variant and patient data from the ' . $_SESSION['currdb'] . ' gene database.</TD></TR>') . "\n" .
      '              <TR class="setup" onclick="window.location.href=\'' . ROOT_PATH . 'config_import.php\';">' . "\n" .
      '                <TD align="center" width="40"><IMG src="' . ROOT_PATH . 'gfx/lovd_database_import.png" alt="Import variants into the ' . $_SESSION['currdb'] . ' gene database" width="32" height="32"></TD>' . "\n" .
      '                <TD>Import new variant and patient data into the ' . $_SESSION['currdb'] . ' gene database.</TD></TR>' .
      '</TABLE><BR>' . "\n");

// Export central repository format.
print('            <TABLE border="0" cellpadding="2" cellspacing="0" class="setup" width="100%">' . "\n" .
      '              <TR>' . "\n" .
      '                <TD colspan="2"><B>Download variant data for central repository</B></TD></TR>' . "\n" .
      '              <TR class="setup" onclick="window.location.href=\'' . ROOT_PATH . 'export_data.php?genes%5B%5D=' . $_SESSION['currdb'] . lovd_showSID(true, true) . '\';">' . "\n" .
      '                <TD align="center" width="40"><IMG src="' . ROOT_PATH . 'gfx/lovd_save.png" alt="Download variant data" width="32" height="32"></TD>' . "\n" .
      '                <TD>Download the variant data for central repositories. This format includes the gene name, DNA change, DB ID, and possible OMIM and DbSNP IDs.</TD></TR>' .
      '</TABLE><BR>' . "\n");

// LOVD scripts.
print('            <TABLE border="0" cellpadding="2" cellspacing="0" class="setup" width="100%">' . "\n" .
      '              <TR>' . "\n" .
      '                <TD colspan="2"><B>LOVD scripts</B></TD></TR>' . "\n" .
      '              <TR class="setup" onclick="window.location.href=\'' . ROOT_PATH . 'config_scripts.php\';">' . "\n" .
      '                <TD align="center" width="40"><IMG src="' . ROOT_PATH . 'gfx/lovd_scripts.png" alt="LOVD scripts" width="32" height="32"></TD>' . "\n" .
      '                <TD>Tools that extend LOVD by providing some additional functionality.</TD></TR></TABLE>' . "\n");



print('          </TD>' . "\n" .
      '        </TR>' . "\n" .
      '      </TABLE>' . "\n");

require ROOT_PATH . 'inc-bot.php';
?>