<?php
/**************************************************************************
 *
 * LOVD DATABASE WEBSITE
 *
 * Created     : 2008-07-22
 * Modified    : 2008-07-22
 * For LOVD    : 2.0-09
 *
 * Access      : Public
 *
 * Programmer  : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *************/

define('ROOT_PATH', '../../');
define('DOCS_PATH', ROOT_PATH . 'docs/');
require DOCS_PATH . 'inc-website-init.php';
require ROOT_PATH . 'inc-top.php';
?>

            <H3>LOVD Gene configuration area</H3>
            <H4>Download or import variants</H4>

            From the configuration area, there are two options to download data from LOVD. The most commonly used option is available from the "Download all variant and patient data" link. It downloads all variant and patient data (public and non-public data) in the standard LOVD import format, which can be imported back into LOVD directly. Not only can this file be used as a backup for your variant and patient data, for instance if you accidentally deleted the wrong entry or the wrong column, it can also be used to make large parallel changes to LOVD entries using spreadsheet software such as OpenOffice.org Calc or MS Excel.<BR>
            <BR>

<?php lovd_showInfoTable('Please NOTE that spreadsheets are well known for introducing errors in importing/exporting text files, due to automatic interpretation of the values. Before using a spreadsheet program to edit a downloaded file, format all cells to "Text".', 'warning'); ?>

            For more information on how to import variant and patient information, see <A href="<?php echo DOCS_PATH; ?>variant_and_patient_data/importing_text_files.php">importing text files</A>.<BR>
            <BR>

            The other option to download variant data is the central repository format, available from the "Download the variant data for central repositories" link. The form allows you to select which gene(s) you wish to download the variant data from and set some filter options. Curator-level users will only be able to select the genes they control from the list, manager-level users and the database administrator can select any gene.<BR>
            <BR>

            The central repository format is designed for limited data exchange with other databases, such as genome browsers. The format contains the gene name, the DNA field, the DBID to facilitate linking back to the LOVD database entry, and possible DbSNP and OMIM ID's associated with the variant entry.<BR>
            <BR>

<?php
include ROOT_PATH . 'inc-bot.php';
?>
