/*******************************************************************************<?php/*
 *
 * LEIDEN OPEN VARIATION DATABASE (LOVD)
 *
 * Created     : 2007-06-18
 * Modified    : 2010-09-22
 * Version     : 0.8
 * For LOVD    : 2.0-29
 *
 * Copyright   : 2004-2010 Leiden University Medical Center; http://www.LUMC.nl/
 * Programmers : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *               Ir. Gerard C.P. Schaafsma <G.C.P.Schaafsma@LUMC.nl>
 * Last edited : Ir. Gerard C.P. Schaafsma <G.C.P.Schaafsma@LUMC.nl>
 *
 *
 * This file is part of LOVD.
 *
 * LOVD is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * LOVD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LOVD; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *************/

class mutalyzer {
    function getInfo ()
    {
        return
             array(
                    'name' => 'LOVD Mutalyzer connection module',
                    'version' => '0.8',
                    'description' => 'LOVD module to connect to Mutalyzer to verify submitted variants with a reference sequence.',
                    'settings' =>
                             array(
                                    // 2010-08-23; 2.0-29; changed to Mutalyzer 2.0
                                    'url' => 'http://www.mutalyzer.nl/2.0/',
                                    'url_version' => '2.0',
                                    'accessionid' => array(),
                                  ),
                  );
    }



    function getUDfromMutalyzer ($sData)
    {
        // Fetches the UD number after uploading a GenBank file to Mutalyzer (2.0)
        $aSett = $GLOBALS['_MODULES']->getSettings('mutalyzer');
        $sMutUrl = $aSett['url'] . 'upload';
        // Get data from Mutalyzer
        $aFile = lovd_php_file($sMutUrl, false, $sData);
        foreach ($aFile as $key => $value) {
            if (preg_match('/(UD_\d{12})/', $value, $aMatches)) {
                $sUD = $aMatches[1];
                return $sUD;
            }
        }
        return false;
    }



    function enable ()
    {
        // Will be run when module is getting enabled.
        $aSett = $GLOBALS['_MODULES']->getSettings('mutalyzer');

        // Per gene, check if there is a genbank file that we can send to mutalyzer.
        // If so, send it and retrieve accessionnumber. This needs to be stored and used as a reference.
        $qGenes = mysql_query('SELECT symbol, genbank_uri FROM ' . TABLE_DBS . ' WHERE genbank = 1');
        while ($r = mysql_fetch_row($qGenes)) {
            // Send GenBank file.
            list($sSymbol, $sFile) = $r;
            if (empty($aSett['accessionid'][$sSymbol])) {
                $sData = 'invoermethode=file&bestandsveld=' . urlencode(file_get_contents(ROOT_PATH . 'genbank/' . $sFile));
                $sUD = $this->getUDfromMutalyzer($sData);
                if ($sUD) {
                    $aSett['accessionid'][$sSymbol] = $sUD;
                } // else do nothing
            }
        }
        $GLOBALS['_MODULES']->setSettings('mutalyzer', $aSett);
    }



    function processForm ($sForm, & $aForm)
    {
        // Process LOVD form data before it gets to the screen.

        if (in_array($sForm, array('SubmitVariantData', 'SubmitVariantsEdit'))) {
            $aSett = $GLOBALS['_MODULES']->getSettings('mutalyzer');
            $_CURRDB = mysql_fetch_assoc(mysql_query('SELECT * FROM ' . TABLE_DBS . ' WHERE symbol = "' . ($sForm == 'SubmitVariantData'? $_POST['gene'] : $_SESSION['currdb']) . '"'));
            $_CURRDB['symbol_short'] = substr($_CURRDB['symbol'], 0, strpos($_CURRDB['symbol'] . '_', '_'));

            // We only work, if we've got a reference sequence in the database.
            if (($_CURRDB['genbank'] == 1 && !empty($aSett['accessionid'][$_CURRDB['symbol']]) && !empty($_CURRDB['refseq_mrna'])) || ($_CURRDB['genbank'] > 1 && $_CURRDB['genbank_uri'])) {
                $aReturn = array();
                foreach ($aForm as $nItem => $aItem) {
                    // Line by line, go through the form.
                    if ($aItem[2] == 'Variant/DNA') {
                        // Add mutalyzer button.
                        $aReturn[] = $aItem;
                        // FIXME; we should somehow parse this output.
                        $aReturn[] = array('', 'print', '<BUTTON type="button" onclick="javascript:if (document.forms[0][\'Variant/DNA\'].value.length > 0) { lovd_openWindow(\'' . $aSett['url'] . 'getGS?variantRecord=' . $_CURRDB['refseq_mrna'] . '&forward=1&mutationName=' . ($_CURRDB['genbank'] == 1? $aSett['accessionid'][$_CURRDB['symbol']] : $_CURRDB['genbank_uri']) . rawurlencode(':') . '\' + encodeURIComponent(document.forms[0][\'Variant/DNA\'].value), \'ModuleMutalyzerNamecheck\', 800, 400); } else { window.alert(\'Please fill in the DNA field.\'); } return false;">Check variant with Mutalyzer ' . $aSett['url_version'] . '</BUTTON>');
                    } else {
                        $aReturn[] = $aItem;
                    }
                }
                $aForm = $aReturn;
                return true;
            }
        }
        return false;
    }





    function upgrade ($sVersionOld)
    {
        // Run necessary code for upgrading this module.
        $aInfo = $this->getInfo();

        // Module version 0.8 has switched to Mutalyzer 2.0.
        if ($sVersionOld <= '0.7') {
            $GLOBALS['_MODULES']->setSettings('mutalyzer', 'url', $aInfo['settings']['url']);
            $GLOBALS['_MODULES']->setSettings('mutalyzer', 'url_version', $aInfo['settings']['url_version']);
            // Get the settings from TABLE_MODULES
            $aSett = $GLOBALS['_MODULES']->getSettings('mutalyzer');

            // Now see which genes have uploaded their own GenBank file
            $qGenes = mysql_query('SELECT symbol, genbank_uri FROM ' . TABLE_DBS . ' WHERE genbank = 1');
            // Now for each gene, get a Mutalyzer 2 UD_ number
            while ($r = mysql_fetch_row($qGenes)) {
                // Send GenBank file.
                list($sSymbol, $sFile) = $r;
                $sGenBankFile = ROOT_PATH . 'genbank/' . $sFile;
                $sData = 'invoermethode=file&bestandsveld=' . urlencode(file_get_contents($sGenBankFile));
                $sUD = $this->getUDfromMutalyzer($sData);
                if ($sUD) {
                    // Store in settings: UD_012345678901
                    $aSett['accessionid'][$sSymbol] = $sUD;
                }
            }
    
            // Now see which genes use a Mutalyzer (1.0.4) UD identifier
            $qGenes = mysql_query('SELECT symbol, genbank_uri FROM ' . TABLE_DBS . ' WHERE genbank = 3');
            while ($r = mysql_fetch_row($qGenes)) {
                // Send GenBank file.
                list($sSymbol, $sFile) = $r;
                $sData = 'invoermethode=url&urlveld=http://localhost/1.0.4/custom/' . urlencode($sFile); // localhost on Mutalyzer server!
                $sUD = $this->getUDfromMutalyzer($sData);
                if ($sUD) {
                // Store in settings: UD_012345678901
                    $aSett['accessionid'][$sSymbol] = $sUD;
                    // update TABLE_DBS
                    $sQ = 'UPDATE ' . TABLE_DBS . ' SET genbank_uri="' . $aSett['accessionid'][$sSymbol] . '" WHERE symbol="' . $sSymbol . '"';
                    $q = mysql_query($sQ);
                }
            }

            // now also set the new settings
            $GLOBALS['_MODULES']->setSettings('mutalyzer', $aSett);
        }
    }
}