<?php
/**************************************************************************
 *
 * LOVD DATABASE WEBSITE
 *
 * Created     : 2008-07-22
 * Modified    : 2010-08-02
 * For LOVD    : 2.0-28
 *
 * Access      : Public
 *
 * Programmer  : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *************/

define('ROOT_PATH', '../../');
define('DOCS_PATH', ROOT_PATH . 'docs/');
require DOCS_PATH . 'inc-website-init.php';
require ROOT_PATH . 'inc-top.php';
?>

            <H3>Variant and patient data</H3>
            <H4>Viewing and searching variant and patient data</H4>

            The variant and patient listings are available from the Variants tab. There are three different gene-specific variant listings, of which two can have the advanced search capabilities enabled. There are also two system-wide variant listings.<BR>
            <BR>

            <H5>Gene-specific variant listings</H5>
            <H6>Unique variants</H6>

            When you click on the Variants tab and you have a gene selected, the default overview is the unique variant listing with search fields enabled. It is also accessible through the gene's homepage, through the link "Unique sequence variants", which leads to the same overview but without the search fields enabled. This overview shows all variant fields, but no patient information. Also, information on pathogenicity is not shown. Variants that are found multiple times are shown only once, including the number of times it has been found. By clicking on a variant, you are guided to the full contents of the selected variant.<BR>
            <BR>
            
            If the top search bar is enabled, you can type search terms for that particular column. After typing in a search term, either press enter or click outside the field.<BR>
            <BR>

            This overview supports these <A href="<?php echo DOCS_PATH; ?>variant_and_patient_data/viewing_and_searching_variant_and_patient_data/advanced_options.php">advanced options</A>: sorting, advanced search terms, column hiding.<BR>
            <BR>

            <H6>All contents</H6>

            This complete overview can be reached through the "View all contents" submenu item just below the menu tabs or the gene's homepage, through the "Complete sequence variant listing" link. This overview shows all information on the variants and associated patients in a large table. Variants that are found multiple times, are not grouped. The pathogenicity information in always shown as the first column. Also, the variant columns are always shown first, after which the patient columns are shown. Although the order of the variant and patient columns can be set by an authorized user, variant and patient columns can not be mixed in this overview.<BR>
            <BR>

            The "Full database search" submenu item just below the menu tabs enables the top search bar, in which you can type the search terms for that particular column. After typing in a search term, either press enter or click outside the field.<BR>
            <BR>

            This overview supports these <A href="<?php echo DOCS_PATH; ?>variant_and_patient_data/viewing_and_searching_variant_and_patient_data/advanced_options.php">advanced options</A>: sorting, advanced search terms, column hiding.<BR>
            <BR>

            <H6>Variants with no known pathogenicity</H6>

            From the gene's homepage, a link named "Variants with no known pathogenicity" leads to a list of variants that do not appear to have any pathogenic effect. Variants with an unknown effect are left out of this overview. This overview is based on the unique variant listing and clicking on a variant will therefore show all variant information including the associated patient(s).<BR>
            <BR>

            This overview supports these <A href="<?php echo DOCS_PATH; ?>variant_and_patient_data/viewing_and_searching_variant_and_patient_data/advanced_options.php">advanced options</A>: sorting, advanced search terms, column hiding.<BR>
            <BR>

            <H5>System-wide variant listings</H5>
            <H6>Based on patient origin</H6>

            If any of the Patient/Origin fields are enabled, LOVD allows you to search through all genes in the database based on the Patient/Origin columns. The standard LOVD origin columns are Patient/Origin/Geographic (geographic origin), Patient/Origin/Ethnic (ethnic origin) and Patient/Origin/Population (population). If you wish to add any columns to search on, create a new patient column and make sure the column ID starts with "Origin/".<BR>
            <BR>

            To reach the variant listings based on patient origin, select the "Variant listing based on patient origin" submenu item under the Variant tab, or click the "Based on patient origin" link on a gene homepage in the "Search the database" table.<BR>
            <BR>

            This overview supports these <A href="<?php echo DOCS_PATH; ?>variant_and_patient_data/viewing_and_searching_variant_and_patient_data/advanced_options.php">advanced options</A>: sorting, advanced search terms (on origin fields only), column hiding.<BR>
            <BR>

<?php lovd_showInfoTable('You may get this error: "There are no Patient/Origin columns enabled. Therefore this overview is non functional."<BR>That means that none of the Patient/Origin fields have been added to the patient table yet. Three Patient/Origin columns are available by default, but they are not added to the patient table by default. See <A href="' . DOCS_PATH . 'lovd_setup/custom_columns/managing_patient_columns.php">Managing patient columns</A>.', 'information'); ?>

            <H6>Submitter variant listing</H6>

            The "my submissions" feature allows submitters to gather a list of variants they've submitted to the LOVD database installation. It is available for submitters and the public if the "my submissions" setting has been enabled in the <A href="<?php echo DOCS_PATH; ?>lovd_setup/lovd_system_settings.php">LOVD system settings</A>, otherwise it's only available for authorized users. Also this overview is system-wide, meaning the overview allows you to select which genes you want to show the variants of.<BR>
            <BR>

            Submitters can access this overview by clicking on "your submissions" on the top right of the screen. You can also go through the Submitters tab, and then click the "My submissions" sub menu item.<BR>
            <BR>

            This overview supports these <A href="<?php echo DOCS_PATH; ?>variant_and_patient_data/viewing_and_searching_variant_and_patient_data/advanced_options.php">advanced options</A>: sorting, column hiding.<BR>
            <BR>

<?php
include ROOT_PATH . 'inc-bot.php';
?>
