/*******************************************************************************
 *
 * LEIDEN OPEN VARIATION DATABASE (LOVD)
 *
 * Created     : 2011-01-25
 * Modified    : 2011-03-09
 * For LOVD    : 2.0-31
 *
 * Access      : Public
 * Purpose     : Provide JavaScript for making the table header in variants.php
 *               "stick" to the top of the data table.
 *
 * Copyright   : 2004-2011 Leiden University Medical Center; http://www.LUMC.nl/
 * Programmers : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *
 * This file is part of LOVD.
 *
 * LOVD is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * LOVD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LOVD; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *************/

oDiv  = document.getElementById('table_div');
oTab1 = document.getElementById('table_headers');
oTab2 = document.getElementById('table_data');

// Set all the widths properly.
for (i in oTab1.rows[0].children) {
  if (!isNaN(i)) {
    oTH = oTab1.rows[0].children[i];
    oTD = oTab2.rows[0].children[i];
    nMax = Math.max(oTH.offsetWidth, oTD.offsetWidth);
    // FIXME; I used to have (nMax - 8) here. That usually works, but sometimes the table body
    // seems to stretch some of the columns anyway and then the header misaligns (is too short).
    // I can't seem to fix that in any other way then making the images stretch the columns a bit.
    // 2011-03-29; IFokkema; I can't reproduce this behaviour anymore! Recheck later in multiple databases.
    oTH.getElementsByTagName('IMG')[0].style.width = (nMax) + 'px';
    oTD.getElementsByTagName('IMG')[0].style.width = (nMax) + 'px';
  }
}



// Move the table down, to not slide underneath the header.
oDiv.style.height = (oTab1.offsetHeight - 3) + 'px';
nOffSetDiff = oTab1.offsetTop - oDiv.offsetTop;



function getPageYOffset ()
{
  // Annoying problem where browsers handle the check for scrolling differently.
  var nPageYOffset = 0;
  if (window.pageYOffset) {
    // WC3 standard method.
    nPageYOffset = window.pageYOffset;
  } else if (document.body && document.body.scrollTop) {
    // Backup IE method #1
    nPageYOffset = document.body.scrollTop;
  } else if (document.documentElement && document.documentElement.scrollTop) {
    // Backup IE method #2
    nPageYOffset = document.documentElement.scrollTop;
  }
  return nPageYOffset;
}



function moveHeader ()
{
  nOffSet = (oDiv.offsetTop + nOffSetDiff);
  nPageYOffset = getPageYOffset();
  if (nPageYOffset < nOffSet) {
    // Still in normal view.
    oTab1.style.top = nOffSet + 'px';
  } else {
    // Move it!
    nPos = parseInt(oTab1.style.top);
    oTab1.style.top = (nPos + Math.ceil((nPageYOffset - nPos) * 0.3)) + 'px';
  }
  setTimeout("moveHeader()", 20);
}
moveHeader();

