<?php
/**************************************************************************
 *
 * LOVD DATABASE WEBSITE
 *
 * Created     : 2008-09-18
 * Modified    : 2009-09-10
 * For LOVD    : 2.0-22
 *
 * Access      : Public
 *
 * Programmer  : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *************/

define('ROOT_PATH', '../../');
define('DOCS_PATH', ROOT_PATH . 'docs/');
require DOCS_PATH . 'inc-website-init.php';
require ROOT_PATH . 'inc-top.php';
?>

            <H3>LOVD Scripts</H3>
            <H4>Reference Sequence Parser</H4>

            The Reference Sequence Parser allows you to create coding DNA reference sequences for the genes in your database. For it to work, you will need to <A href="enabling_the_scripts.php">make the refseq directory writable</A>. If you also want the script to generate a GenBank file for you, you'll also need to make the genbank directory writable.<BR>
            <BR>

            <H5>Input formats Reference Sequence Parser</H5>
            The Reference Sequence Parser accepts specific input formats for each step. Step 1 requires a GenBank file, and will generate the formats for steps 2 and 3 automatically, so starting at this step is recommended.<BR>
            Step 2 requires the genomic sequence formatted to provide the positions of the upstream sequence, exons, introns, downstream sequence and the start of the translation.<BR>
            Step 3 requires the coding DNA sequence formatted to provide the positions of the exon borders and the start of the translation.<BR>
            All formats are case-<B>in</B>sensitive. It does not matter whether you use capital or non-capital nucleotides.<BR>
            <BR>

            <B>Input format for step 1</B><BR>
            Step 1 requires a valid GenBank file, uploaded into the 'genbank' directory. You can upload GenBank files with the <A href="genbank_file_uploader.php">GenBank File Uploader</A>. Preferably, the GenBank file contains only your gene of interest and only one transcript is defined. If more than one transcript is defined, you will have to fill in the appropriate transcript_id and protein_id. If you do not fill in both fields, the first mRNA and CDS fields appearing in the file and associated with this gene will be selected.<BR>
            <BR>

            Step 1 will create the correct format for step 2, so this is the recommended step to start out with.<BR>
            <BR>

            <B>Input format for step 2</B><BR>
            <I>UPSTREAM&lt;EXON&gt;INTRON&lt;EXON&gt;INTRON&lt;EXON&gt;INTRON (...etc...) &lt;EXON&gt;DOWNSTREAM</I><BR>

            Make sure you include the starting point of the translation by putting a '|' in front of the 'a' of the 'atg' starting codon. If you started at step 1, this is done for you automatically.<BR>
            <BR>

            Example:<BR>
            <I>cccccccc&lt;gggggg|at&gt;tttttttt&lt;gggggggg&gt;aaaaaaaa</I><BR>
            will parse:<BR>

            - 'cccccccc' as the upstream sequence.<BR>
            - 'ggggggat' as exon 1, with the translation starting at the 'a'.<BR>
            - 'tttttttt' as intron 1.<BR>
            - 'gggggggg' as exon 2.<BR>
            - 'aaaaaaaa' as the downstream sequence.<BR>
            <BR>

            Step 2 will create the upstream sequence, intronic sequences and the downstream sequence, as well as exon lengths tables in html and text format, in which the exon start and end positions (in c. and g. numbering) and exon and intron lengths are provided. These are all saved in the refseq directory. Step 2 will also create the input for step 3 for you. Optionally, you can also have it create a file in GenBank format. You will then have to fill in the appropriate transcript_id, protein_id and db_xref numbers. The created file will meet the minimum requirements for uploading in <A href="http://www.mutalyzer.nl/" target="_blank">Mutalyzer</A>.<BR>
            <BR>

            <B>Input format for step 3</B><BR>
            <I>EXON;EXON;EXON; (...etc...) ;EXON</I><BR>
            Make sure you include the starting point of the translation by putting a '|' in front of the 'a' of the 'atg' starting codon. If you started at step 1 or 2, the same start codon is used.<BR>

            <BR>

            Example:<BR>
            <I>gggggg|at;gggggggg</I><BR>
            will parse:<BR>
            - 'ggggggat' as exon 1, with the translation starting at the 'a'.<BR>
            - 'gggggggg' as exon 2.<BR>

            <BR>
            Step 3 will create the coding DNA sequence including the translation and save it in the refseq directory.<BR>
            If your gene does not have a reference sequence configured yet, this script will automatically add the created coding DNA reference sequence to the gene homepage.<BR>
            <BR>

            For examples on how these reference sequences will look like, take a look at the reference sequences <A href="http://www.dmd.nl/" target="_blank">www.DMD.nl</A>, such as the <A href="http://www.dmd.nl/nmdb2/refseq/CAPN3_codingDNA.html" target="_blank">CAPN3 reference sequence</A>.<BR>
            <BR>

<?php
include ROOT_PATH . 'inc-bot.php';
?>
