<?php
/*******************************************************************************
 *
 * LEIDEN OPEN VARIATION DATABASE (LOVD)
 *
 * Created     : 2006-04-03
 * Modified    : 2011-08-01
 * For LOVD    : 2.0-32b
 *
 * Access      : Public
 * Purpose     : Include SQL to create the standard LOVD custom links.
 *
 * Copyright   : 2004-2011 Leiden University Medical Center; http://www.LUMC.nl/
 * Programmer  : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *
 * This file is part of LOVD.
 *
 * LOVD is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * LOVD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LOVD; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *************/

$aLinkSQL =
         array(
                'PubMed' => 'INSERT INTO ' . TABLE_LINKS . ' VALUES (001, "PubMed", "{PMID[1]:[2]}", "<A href=\"http://www.ncbi.nlm.nih.gov/pubmed/[1]\" target=\"_blank\">[2]</A>", "Links to abstracts in the PubMed database.\r\n[1] = The PubMed ID.\r\n[2] = The name of the author(s).", 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS2LINKS . ' VALUES ("Variant/Reference", 001)',
                'INSERT INTO ' . TABLE_COLS2LINKS . ' VALUES ("Patient/Reference", 001)',
                'INSERT INTO ' . TABLE_COLS2LINKS . ' VALUES ("Gene/Reference", 001)',
                'DbSNP' => 'INSERT INTO ' . TABLE_LINKS . ' VALUES (002, "DbSNP", "{dbSNP[1]}", "<A href=\"http://www.ncbi.nlm.nih.gov/SNP/snp_ref.cgi?type=rs&amp;rs=rs[1]\" target=\"_blank\">dbSNP</A>", "Links to the DbSNP database.\r\n[1] = The DbSNP ID.", 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS2LINKS . ' VALUES ("Variant/Reference", 002)',
                'GenBank' => 'INSERT INTO ' . TABLE_LINKS . ' VALUES (003, "GenBank", "{GenBank[1]}", "<A href=\"http://www.ncbi.nlm.nih.gov/entrez/viewer.fcgi?cmd=Retrieve&amp;db=nucleotide&amp;dopt=GenBank&amp;list_uids=[1]\" target=\"_blank\">GenBank</A>", "Links to GenBank sequences.\r\n[1] = The GenBank ID.", 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS2LINKS . ' VALUES ("Variant/Reference", 003)',
                'OMIM' => 'INSERT INTO ' . TABLE_LINKS . ' VALUES (004, "OMIM", "{OMIM[1]:[2]}", "<A href=\"http://www.omim.org/entry/[1]#[2]\" target=\"_blank\">(OMIM [2])</A>", "Links to an allelic variant on the gene\'s OMIM page.\r\n[1] = The OMIM gene ID.\r\n[2] = The number of the OMIM allelic variant on that page.", 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS2LINKS . ' VALUES ("Variant/Reference", 004)',
              );
?>