<?php
/*******************************************************************************
 *
 * LEIDEN OPEN VARIATION DATABASE (LOVD)
 *
 * Created     : 2007-06-05
 * Modified    : 2011-09-27
 * For LOVD    : 2.0-33
 *
 * Access      : Public
 * Purpose     : Handle information and control of the available modules.
 *
 * Copyright   : 2004-2011 Leiden University Medical Center; http://www.LUMC.nl/
 * Programmer  : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *
 * This file is part of LOVD.
 *
 * LOVD is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * LOVD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LOVD; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *************/

// Don't allow direct access.
if (!defined('ROOT_PATH')) {
    exit;
}



class Modules {
    // Member variable.
    // FIXME; for PHP5 we would use a private member variable. Backwards compatible with PHP4.X.
    var $aModuleList = array(); // List of modules. BEWARE that inc-upgrade.php directly accesses this variable.





    // Methods.
    function Modules ()
    {
        // PHP 4 constructor.
        // Gather standard info necessary for the other methods.
        $sQ = 'SELECT * FROM ' . TABLE_MODULES;

        $q = mysql_query($sQ);
        if (!$q) {
            lovd_dbFout('MODULES::__construct()', $sQ, mysql_error());
        }
        while ($z = mysql_fetch_assoc($q)) {
            $this->aModuleList[$z['moduleid']] = $z;
            if ($z['active']) {
                // Read out settings of active modules.
                $this->aModuleList[$z['moduleid']]['settings'] = unserialize($z['settings']);
            }
        }



        // Load actual module classes.
        foreach ($this->aModuleList as $sModuleID => $aModule) {
            // Errors will not be logged, since the log will be flooded, then.
            // FIXME; how 'bout log and deactivate the module right after?

            // We're going to skip this for non-activaged modules...
            if (!$aModule['active']) {
                continue;
            }

            // All put in one method. This method will unset faulty modules by default.
            $this->initModule($sModuleID);
        }
    }





    function disable ($sModuleID)
    {
        // Disables (deactivates) module.
        if ($this->isInstalled($sModuleID)) {
            if ($this->aModuleList[$sModuleID]['active']) {
                // Save current settings to the database.
                $this->setSettings($sModuleID, $this->getSettings($sModuleID));

                // Tell module it's getting disabled.
                if (method_exists($this->aModuleList[$sModuleID]['module'], 'disable')) {
                    $this->aModuleList[$sModuleID]['module']->disable();
                }
            }

            $sQ = 'UPDATE ' . TABLE_MODULES . ' SET active = 0 WHERE moduleid = "' . $sModuleID . '"';
            $q = @mysql_query($sQ);
            if (!$q) {
                return false;
            } else {
                $this->aModuleList[$sModuleID]['active'] = false;
                return true;
            }

        } else {
            return false;
        }
    }





    function enable ($sModuleID)
    {
        // Enables (activates) module.
        if ($this->isInstalled($sModuleID) && !$this->aModuleList[$sModuleID]['active'] && $this->initModule($sModuleID)) {
            $sQ = 'UPDATE ' . TABLE_MODULES . ' SET active = 1 WHERE moduleid = "' . $sModuleID . '"';
            $q = @mysql_query($sQ);
            if (!$q) {
                return false;
            } else {
                // Tell module it's been enabled.
                $this->aModuleList[$sModuleID]['active'] = true;
                if (method_exists($this->aModuleList[$sModuleID]['module'], 'enable')) {
                    $this->aModuleList[$sModuleID]['module']->enable();
                }

                // 2009-02-24; 2.0-16; Also check if it needs to be upgraded!
                $aSQL = $this->getUpgradeSQL($sModuleID);
                if (is_array($aSQL)) {
                    foreach ($aSQL as $sSQL) {
                        @mysql_query($sSQL);
                    }
                }

                return true;
            }
        }
        return false;
    }





    function getSettings ($sModuleID, $sSetting = '')
    {
        // Return settings for specific module.
        if (!$this->isInstalled($sModuleID)) {
            return false;
        }

        if ($sSetting !== '') {
            // Return specific setting.
            if (array_key_exists($sSetting, $this->aModuleList[$sModuleID]['settings'])) {
                return $this->aModuleList[$sModuleID]['settings'][$sSetting];
            } else {
                return false;
            }
        } else {
            // Return entire array.
            return $this->aModuleList[$sModuleID]['settings'];
        }
    }





    function getUpgradeSQL ($sModuleID = '') {
        // Generates necessary SQL code to perform upgrades for the modules, if necessary.
        // 2009-02-24; 2.0-16; First basic version of this function.
        $aReturn = array();

        // If no module has been given, we return the necessary code for all active modules.
        if ($sModuleID) {
            if (!$this->isLoaded($sModuleID)) {
                return false;
            }
            $aModules = array($sModuleID);
        } else {
            $aModules = $this->getModuleList(true);
        }

        // List of modules now in $aModules.
        // 2009-09-03; 2.0-21; Also compare 'name' and 'description'.
        $aFields = array('name', 'version', 'description');
        foreach ($aModules as $sModule) {
            $aInfo = $this->aModuleList[$sModule]['module']->getInfo();
            foreach ($aFields as $sField) {
                if ($this->aModuleList[$sModule][$sField] != $aInfo[$sField]) {
                    // Not very efficient, could be updated three times if all three fields change, but alas.
                    $aReturn[] = 'UPDATE ' . TABLE_MODULES . ' SET ' . $sField . ' = "' . $aInfo[$sField] . '", date_updated = NOW() WHERE moduleid = "' . $sModule . '"';
                }
            }

            // 2009-09-03; 2.0-21; Added getUpgradeSQL (not in use yet) and upgrade() (in use by Mutalyzer) for module upgrades.
            if (method_exists($this->aModuleList[$sModule]['module'], 'getUpgradeSQL')) {
                $aReturn = array_merge($aReturn, $this->aModuleList[$sModule]['module']->getUpgradeSQL($this->aModuleList[$sModule]['version']));
            }
            if (method_exists($this->aModuleList[$sModule]['module'], 'upgrade')) {
                $this->aModuleList[$sModule]['module']->upgrade($this->aModuleList[$sModule]['version']);
            }
        }
        return $aReturn;
    }





    function setSettings ($sModuleID, $sSetting, $sValue = false, $bSave = true)
    {
        // Change settings.
        if (!$this->isLoaded($sModuleID)) {
            return false;
        }

        // FIXME; this if/else can be made a lot more efficient.
        if (is_string($sSetting)) {
            // Change specific setting.
            if (array_key_exists($sSetting, $this->aModuleList[$sModuleID]['settings'])) {
                $this->aModuleList[$sModuleID]['settings'][$sSetting] = $sValue;
                if ($bSave) {
                    // Save new settings in the database.
                    return @mysql_query('UPDATE ' . TABLE_MODULES . ' SET settings = "' . mysql_real_escape_string(serialize($this->aModuleList[$sModuleID]['settings'])) . '" WHERE moduleid = "' . $sModuleID . '"');
                } else {
                    return true;
                }
            } else {
                return false;
            }
        } elseif (is_array($sSetting) && count($sSetting)) {
            // Replace entire array.
            $this->aModuleList[$sModuleID]['settings'] = $sSetting;
            if ($bSave) {
                // Save new settings in the database.
                return @mysql_query('UPDATE ' . TABLE_MODULES . ' SET settings = "' . mysql_real_escape_string(serialize($this->aModuleList[$sModuleID]['settings'])) . '" WHERE moduleid = "' . $sModuleID . '"');
            } else {
                return true;
            }
        } else {
            return false;
        }
    }





    function initModule ($sModuleID, $bUnset = true)
    {
        // Do some basic checks on this module and initialize it.

        // 1) Is the directory there?
        if (!is_dir(MODULE_PATH . $sModuleID)) {
            if ($bUnset) {
                unset($this->aModuleList[$sModuleID]);
            }
            return false;
        }

        // 2) Class file?
        if (!is_readable(MODULE_PATH . $sModuleID . '/module.php')) {
            if ($bUnset) {
                unset($this->aModuleList[$sModuleID]);
            }
            return false;
        }

        // 3) Load module file!
        if (!class_exists($sModuleID)) {
            // Sometimes we reload a module. Then this step should be skipped.
            $sFile = file_get_contents(MODULE_PATH . $sModuleID . '/module.php');
            @eval($sFile);
            if (!class_exists($sModuleID)) {
                // Apparently, not defined or malformed module code (parse error or such).
                if ($bUnset) {
                    unset($this->aModuleList[$sModuleID]);
                }
                return false;
            }
        }
        if (class_exists($sModuleID)) {
            // Load module!
            $this->aModuleList[$sModuleID]['module'] = new $sModuleID;
        }

        // Updated?
        $aInfo = $this->aModuleList[$sModuleID]['module']->getInfo();
        if ($aInfo['version'] != $this->aModuleList[$sModuleID]['version']) {
            // FIXME; upgrade things or so.
        }

        // Load settings from database and update default settings.
        if (is_string($this->aModuleList[$sModuleID]['settings'])) {
            $this->aModuleList[$sModuleID]['settings'] = unserialize($this->aModuleList[$sModuleID]['settings']);
        }
        $this->aModuleList[$sModuleID]['settings'] = array_merge($aInfo['settings'], $this->aModuleList[$sModuleID]['settings']);

        return true;
    }





    function isInstalled ($sModuleID, $sVersion = '')
    {
        // Checks if module is installed; active or not.
        return (array_key_exists($sModuleID, $this->aModuleList) && ($sVersion? ($this->aModuleList[$sModuleID]['version'] == $sVersion) : true));
    }





    function isLoaded ($sModuleID, $sVersion = '')
    {
        // Checks if module is active and has been loaded.
        return ($this->isInstalled($sModuleID, $sVersion) && $this->aModuleList[$sModuleID]['active']);
    }





    function getModule ($sModuleID)
    {
        // Return module class.
        if ($this->isLoaded($sModuleID)) {
            return $this->aModuleList[$sModuleID]['module'];
        }
        return false;
    }





    function getModuleList ($bActive = false)
    {
        // Return array of all or enabled module names.
        if (!$bActive) {
            return array_keys($this->aModuleList);
        } else {
            $aReturn = array();
            foreach ($this->aModuleList as $sModuleID => $aModule) {
                if ($aModule['active']) {
                    $aReturn[] = $sModuleID;
                }
            }
            return $aReturn;
        }
    }





    function processForm ($sForm, & $aForm) {
        // Go through the active modules one by one to let them process the
        // form data, before it gets to the screen.
        foreach ($this->aModuleList as $sModuleID => $aModule) {
            if ($this->isLoaded($sModuleID) && method_exists($this->aModuleList[$sModuleID]['module'], 'processForm')) {
                $this->aModuleList[$sModuleID]['module']->processForm($sForm, $aForm);
            }
        }
        return true;
    }
}
?>