<?php
/*******************************************************************************
 *
 * LEIDEN OPEN VARIATION DATABASE (LOVD)
 *
 * Created     : 2008-10-02
 * Modified    : 2008-10-07
 * For LOVD    : 2.0-13
 *
 * Access      : Curators and up.
 * Purpose     : Curate all marked and non-public variants by checking them one
 *               by one and marking them public if found OK.
 *
 * Copyright   : 2004-2008 Leiden University Medical Center; http://www.LUMC.nl/
 * Programmer  : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *
 * This file is part of LOVD.
 *
 * LOVD is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * LOVD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LOVD; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *************/

define('ROOT_PATH', './');
require ROOT_PATH . 'inc-init.php';

if (HAS_AUTH) {
    // If authorized, check for updates.
    require ROOT_PATH . 'inc-upgrade.php';
}

// Require curator clearance.
lovd_requireAUTH(LEVEL_CURATOR);

// If no gene selected, present the selection list.
if (!$_SESSION['currdb'] || $_GET['action'] == 'switch_db') {
    lovd_switchDB();
}

// Needs to be curator for THIS gene.
if (!lovd_isCurator($_SESSION['currdb'])) {
    // NOTE that this does not unset certain links in the top menu. Links are available.
    require ROOT_PATH . 'inc-top.php';
    lovd_showInfoTable((GENE_COUNT? 'You are not allowed access to ' . (GENE_COUNT > 1? 'this gene database' : 'the installed gene database') . '. Please contact your manager or the administrator to grant you access.' : 'There are currently no databases installed.'), 'stop');
    require ROOT_PATH . 'inc-bot.php';
    exit;
}

// Require form functions.
require ROOT_PATH . 'inc-lib-form.php';
require ROOT_PATH . 'class/currdb.php';
$_CURRDB = new CurrDB();
$sMutationCol = $_CURRDB->getMutationCol();
require ROOT_PATH . 'inc-top.php';
lovd_printHeader('config', 'LOVD Configuration area');





// Fetch all variants that need to be curated, and loop through them.
$qVariants = mysql_query('SELECT v.*, p2v.* FROM ' . TABLE_CURRDB_VARS . ' AS v LEFT JOIN ' . TABLE_PAT2VAR . ' AS p2v ON (p2v.symbol = "' . $_SESSION['currdb'] . '" AND v.variantid = p2v.variantid) WHERE p2v.status <= "' . STATUS_MARKED . '"');
$nTotal = mysql_num_rows($qVariants);
$nSuccess = 0;
$nSkipped = 0;

// No variants?
if (!$nTotal) {
    print('      No entries found that need to be curated. Either your gene database contains no variants, or all entries are already curated.<BR>' . "\n\n");
    require ROOT_PATH . 'inc-bot.php';
    exit;
}

// Progress bar.
print('      Verifying and curating entries...<BR><BR>' . "\n" .
      '      <TABLE border="0" cellpadding="0" cellspacing="0" class="S11" width="250">' . "\n" .
      '        <TR style="height : 15px;">' . "\n" .
      '          <TD width="100%" style="border : 1px solid black;">' . "\n" .
      '            <IMG src="' . ROOT_PATH . 'gfx/trans.png" alt="" title="" width="0%" height="15" id="lovd_progress_curate" style="background : #AFC8FA;"></TD>' . "\n" .
      '          <TD align="right" width="25"><INPUT type="text" id="lovd_progress_curate_value" size="3" value="0%" style="border : 0px; margin : 0px; padding : 0px; text-align : right;"></TD></TR></TABLE><BR>' . "\n\n" .
      '      <SCRIPT type="text/javascript">var progressCurate = document.getElementById(\'lovd_progress_curate\'); var progressCurateValue = document.getElementById(\'lovd_progress_curate_value\');</SCRIPT>' . "\n");

// Progress...
$nProgressPrev = '0%';
$n = 0;

// Loop through all results and verify.
while ($zData = mysql_fetch_assoc($qVariants)) {
    lovd_errorClean();
    $n++;

    // Mandatory fields.
    $_POST = $zData;
    $_CURRDB->checkMandatory('Variant');

    // Nothing else to check, really. All other checks have already been performed on create/edit/import.

    if (!lovd_error()) {
        // Query text.
        $sQ = 'UPDATE ' . TABLE_PAT2VAR . ' SET status = "' . STATUS_OK . '", edited_by = "' . $_AUTH['userid'] . '", edited_date = NOW() WHERE symbol = "' . $_SESSION['currdb'] . '" AND variantid = "' . $zData['variantid'] . '" AND patientid = "' . $zData['patientid'] . '" AND allele = "' . $zData['allele'] . '"';
        $q = mysql_query($sQ);
        if (!$q) {
            lovd_dbFout('VariantCurateAll', $sQ, mysql_error());
        }
        $nSuccess ++;
    } else {
        $nSkipped ++;
    }

    $nProgress = round(($n*100)/$nTotal) . '%';
    if ($nProgress != $nProgressPrev) {
        print('      <SCRIPT type="text/javascript">progressCurate.style.width = \'' . $nProgress . '\'; progressCurateValue.value = \'' . $nProgress . '\';</SCRIPT>' . "\n");
    }

    flush();
    usleep(1000);
    $nProgressPrev = $nProgress;
}



// Update gene's "Last update" field.
if ($nSuccess) {
    lovd_setUpdatedDate($_SESSION['currdb']);
}

// Write to log...
lovd_writeLog('MySQL:Event', 'VariantCurateAll', $_AUTH['username'] . ' (' . mysql_real_escape_string($_AUTH['name']) . ') successfully curated ' . $nSuccess . ' variant' . ($nSuccess == 1? '' : 's') . ' in the ' . $_SESSION['currdb'] . ' gene');

// Thank the user...
lovd_showInfoTable('Successfully curated ' . $nSuccess . ' variant entr' . ($nSuccess == 1? 'y' : 'ies') . ', skipped ' . $nSkipped . ' incomplete entr' . ($nSkipped == 1? 'y' : 'ies') . '.', 'success');

// Forward the user.
print('      <SCRIPT type="text/javascript">' . "\n" .
      '        <!--' . "\n" .
      '        setTimeout("window.location.href = \'' . PROTOCOL . $_SERVER['HTTP_HOST'] . rtrim(dirname($_SERVER['PHP_SELF']), '/') . '/config.php' . lovd_showSID() . '\'", ' . ($nSkipped? 5000 : 3000) . ');' . "\n" .
      '        // -->' . "\n" .
      '      </SCRIPT>' . "\n\n");

require ROOT_PATH . 'inc-bot.php';
exit;
