<?php
/**************************************************************************
 *
 * LOVD DATABASE WEBSITE
 *
 * Created     : 2009-07-23
 * Modified    : 2009-12-11
 * For LOVD    : 2.0-21
 *
 * Access      : Public
 *
 * Programmer  : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *************/

define('ROOT_PATH', '../../../');
define('DOCS_PATH', ROOT_PATH . 'docs/');
require DOCS_PATH . 'inc-website-init.php';
require ROOT_PATH . 'inc-top.php';
?>

            <H3>LOVD Setup</H3>
            <H4>Modules</H4>
            <H5>Available LOVD modules</H5>

            These are the modules included with LOVD. Of each of the modules, the functionality is described in detail.<BR>
            <BR>

            <H6>Mutalyzer module</H6>
            The <A href="http://www.mutalyzer.nl/" target="_blank">Mutalyzer software</A> was developed to guide researchers in using the correct HGVS nomenclature for their variants. LOVD helps by connecting to the Mutalyzer module from the submitter form, to allow both submitters and curators to check their nomenclature.<BR>
            <BR>

            For Mutalyzer to work correctly, a GenBank file is necessary.<BR>
            You can <A href="<?php echo DOCS_PATH; ?>lovd_scripts/genbank_file_uploader.php">upload a GenBank file to LOVD</A>, after which it can be used by the Mutalyzer module and for the LOVD Reference Sequence parser.<BR>
            You can also upload one through the Mutalyzer GenBank uploader or even have Mutalyzer <A href="http://www.mutalyzer.nl/2.0/upload" target="_blank">generate one for you</A>, after which you can configure LOVD to use the Mutalyzer GenBank ID by editing the gene's settings.<BR>
            Also filling in a valid NCBI NG or NC accession number in the "GenBank file name or ID" field in the gene settings, will enable the Mutalyzer module to check your variants.<BR>
            <BR>

            <B>Using the Mutalyzer module</B><BR>
            Once the module is enabled, the variant submission form for every gene which has a GenBank file associated to it, will include a button "Check variant with Mutalyzer 1.0.4" directly below the "DNA change" field. Fill in a value in the "DNA change" field, and click the button. A new window will pop up, where the results of the query to the Mutalyzer service will appear.<BR>
            <BR>

            <B>Mutalyzer stores your GenBank files</B><BR>
            Mutalyzer saves all GenBank files in the GenBank file cache. Currently, the cache size is sufficient and no files are removed.<BR>
            In a future version of Mutalyzer, the GenBank file cache will be cleaned up automatically, when the GenBank file cache is nearly full. In this case, the files which have not been used for the longest period of time will be removed. The clean up may include files with a Mutalyzer GenBank ID, which are generated in the following cases:<BR>
            <OL style="margin-top : 0px;">
              <LI>You have a GenBank file uploaded to LOVD, or</LI>
              <LI>You have uploaded a GenBank file into Mutalyzer, and have supplied LOVD with the generated Mutalyzer UD identifier</LI>
            </OL>

            <B>Troubleshooting</B><BR>
            In the future, the automatic cache clean up may result in breaking the link between Mutalyzer and your gene database in LOVD if the Mutalyzer module has not been used for a long period of time. To fix this, do <I>either</I> of the following:<BR>
            <OL style="margin-top : 0px;">
              <LI>Don't download a GenBank file, but configure LOVD to use an official NCBI GenBank ID, or</LI>
              <LI>Uninstall and reinstall the Mutalyzer module. Reinstallation may take some time, as the module is contacting Mutalyzer to generate new ID's for every gene's GenBank files.</LI>
            </OL>

            Fortunately, it is unlikely that this will happen to an active database.<BR>
            <BR>
            <BR>



            <H6>ShowMaxDBID</H6>
            This module is useful for curators, as it mentions the first free DBID value on the variant submission form and allows curators to quickly insert it into the DBID field. Do this by clicking the link "copy to field".<BR>
            <BR>
            <BR>


            <H6>reCAPTCHA</H6>
            This module is an implementation of a <A href="http://en.wikipedia.org/wiki/Captcha" target="_blank">CAPTCHA</A> functionality in the submitter registration form, used to block fake submitter registrations done by spambots or similar programs. CAPTCHA stands for "<B>C</B>ompletely <B>A</B>utomated <B>P</B>ublic <B>T</B>uring test to tell <B>C</B>omputers and <B>H</B>umans <B>A</B>part". It is a technique nowadays used widespread over the internet to protect data entry forms, such as registration forms or contact forms, to be filled in by computers by presenting a question that is regarded currently not possible for a computer to answer. This could be a simple mathematical equation or, more often used, a distorted image that contains text.<BR>
            <BR>

            This module is based on the <A href="http://recaptcha.net/" target="_blank">reCAPTCHA project</A> that is currently the recommended standard of the CAPTCHA method. It combines a CAPTCHA test with the digitalisation of books, by using the answers given by human beings using reCAPTCHA modules all over the world, to solve words which could not be digitized properly.<BR>
            <BR>


<?php
include ROOT_PATH . 'inc-bot.php';
?>
