<?php
/**************************************************************************
 *
 * LOVD DATABASE WEBSITE
 *
 * Created     : 2009-04-06
 * Modified    : 2009-04-06
 * For LOVD    : 2.0-17
 *
 * Access      : Public
 *
 * Programmer  : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 * Last edited : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *
 *************/

define('ROOT_PATH', '../../');
define('DOCS_PATH', ROOT_PATH . 'docs/');
require DOCS_PATH . 'inc-website-init.php';
require ROOT_PATH . 'inc-top.php';
?>

            <H3>LOVD Scripts</H3>
            <H4>Enabling the scripts</H4>

            LOVD comes with a couple of useful scripts, allowing you to perform some extra tasks related to LOVD. Since these scripts need to have writing permissions on some of the LOVD directories, you need to perform some actions before you can use them.<BR>
            LOVD's GenBank File Uploader requires the genbank directory to be writable, the Reference Sequence Parser requires a writable refseq directory, and if you want it to generate GenBank files for you, it also requires a writable genbank directory.<BR>
            <BR>

            <H5>Making the genbank and refseq directories writable</H5>
            Your LOVD package comes with two (empty) directories called 'genbank' and 'refseq'. As explained above, these directories need to be made writable so that the LOVD scripts can access these folders. Below we will explain how to do that on Unix/Linux systems. If your LOVD is installed on a different server (Windows, Macintosh), please contact the person responsible for that server in order to make the directory world writable.<BR>
            <BR>

<?php lovd_showInfoTable('<B>For advanced users</B><BR>It is actually more secure to do a \'chgrp\' on the folder to the user running the webserver, than to make the directory world writable. If you don\'t know which user the webserver runs as (i.e. \'www-data\' or \'httpd\'), you will need to do a \'ps\' to find out which user that is, or consult the webserver configuration. After that, make sure the groupbit has been set to 7 (rwx). This way, the scripts work without having to make the directories world writable.', 'information'); ?>

            <B>Using the commandline</B><BR>
            <OL style="margin-top : 0px;">
              <LI>Log in to the server using SSH, telnet or any non-graphical (S)FTP client.</LI>
              <LI>Move into the directory LOVD is placed using the 'cd' command.</LI>
              <LI>Type in 'chmod 777 genbank refseq'.</LI>
              <LI>Check if the scripts are still generating an error. If not, you're done.</LI>
            </OL><BR>

            <B>Using a graphical (S)FTP client</B><BR>
            Of course, there are so many different FTP clients that I can't write a exact manual on how to change rights on a folder. This will describe a generally used method.<BR>
            <OL style="margin-top : 0px;">
              <LI>Log in to the server using your favorite (S)FTP client.<BR>
                (FTP is a protocol used to transfer files to or from the internet. If you have uploaded your LOVD files to a server, you can use the same program you used then.)</LI>
              <LI>Move into the directory LOVD is placed (usually by double clicking on the folder names).</LI>
              <LI>Right click on the folder 'genbank', this will bring up a menu.</LI>
              <LI>Select 'chmod' if it is an option. Otherwise, click 'Properties' and look for the folder permissions/rights.</LI>
              <LI>Fill in '777' as the new value.</LI>
              <LI>Repeat steps 3-5 for the 'refseq' directory.</LI>
              <LI>Check if the scripts are still generating an error. If not, you're done.</LI>
            </OL><BR>

<?php
include ROOT_PATH . 'inc-bot.php';
?>
