<?php
/*******************************************************************************
 *
 * LEIDEN OPEN VARIATION DATABASE (LOVD)
 *
 * Created     : 2009-10-22
 * Modified    : 2012-07-31
 * For LOVD    : 3.0-beta-08
 *
 * Copyright   : 2004-2012 Leiden University Medical Center; http://www.LUMC.nl/
 * Programmers : Ing. Ivo F.A.C. Fokkema <I.F.A.C.Fokkema@LUMC.nl>
 *               Ing. Ivar C. Lugtenburg <I.C.Lugtenburg@LUMC.nl>
 *
 *
 * This file is part of LOVD.
 *
 * LOVD is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LOVD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LOVD.  If not, see <http://www.gnu.org/licenses/>.
 *
 *************/

$aColSQL =
         array(
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("Individual/Age_of_death",                    248, 100, 0, 0, 0, "Age of death",         "Type 35y for 35 years, 04y08m for 4 years and 8 months, 18y? for around 18 years, >54y for still alive at 55, ? for unknown.", "The age at which the individual deceased, if known and applicable. 04y08m = 4 years and 8 months.", "The age at which the individual deceased, if known and applicable.\r\n<UL style=\"margin-top:0px;\">\r\n  <LI>35y = 35 years</LI>\r\n  <LI>04y08m = 4 years and 8 months</LI>\r\n  <LI>18y? = around 18 years</LI>\r\n  <LI>&gt;54y = still alive at 55</LI>\r\n  <LI>? = unknown</LI>\r\n</UL>", "VARCHAR(12)", "Age of death|The age at which the individual deceased, if known and applicable. Numbers lower than 10 should be prefixed by a zero and the field should always begin with years, to facilitate sorting on this column.|text|10", "", "/^([<>]?\\\\d{2,3}y(\\\\d{2}m(\\\\d{2}d)?)?)?\\\\??$/", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("Individual/Consanguinity",                   240,  40, 0, 0, 0, "Consanguinity",        "Indicates whether the parents are related (consanguineous), not related (non-consanguineous) or whether consanguinity is not known (unknown)", "Indicates whether the parents are related (consanguineous), not related (non-consanguineous) or whether consanguinity is not known (unknown)", "Indicates whether the parents are related (consanguineous), not related (non-consanguineous) or whether consanguinity is not known (unknown)", "VARCHAR(100)", "Consanguinity||select|1|--Not specified--|false|false", "? = Unknown\r\nno = Non-consanguineous parents\r\nyes = Consanguineous parents", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("Individual/Death/Cause",                     249, 150, 0, 0, 0, "Cause of death",       "", "The cause of the individual\'s death, if known and applicable.", "The cause of the individual\'s death, if known and applicable.", "VARCHAR(255)", "Cause of death|The cause of the individual\'s death, if known and applicable.|text|30", "", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                // SEER list: 1 Male, 2 Female, 3 Other (hermaphrodite, sex chromosome abberations), 4 Transsexual/Transgender, 9 Not stated/Unknown
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("Individual/Gender",                            3,  70, 0, 0, 0, "Gender",               "", "Individual\'s gender.", "The gender of the reported individual.", "VARCHAR(100)", "Gender||select|1|--Not specified--|false|false", "? = Unknown\r\nF = Female\r\nM = Male\r\nrF = Raised as female\r\nrM = Raised as male", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("Individual/Lab_ID",                            1,  80, 1, 1, 1, "Lab-ID",               "", "The individual\'s ID in the hospital, diagnostic laboratory or in the publication.", "The individual\'s ID in the hospital, diagnostic laboratory or in the publication.", "VARCHAR(15)", "Lab ID||text|15", "", "", 0, 1, 0, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("Individual/Origin/Ethnic",                   201, 200, 0, 0, 0, "Ethnic origin",        "Ethnic origin of individual; e.g. African, Caucasian, gypsy, jew (Ashkenazi).", "Ethnic origin of individual; e.g. African, Caucasian, gypsy, jew (Ashkenazi).", "The ethnic origin of the individual; e.g. African, Caucasian, gypsy, jew (Ashkenazi).", "VARCHAR(50)", "Ethnic origin|If mixed, please indicate origin of father and mother, if known.|text|20", "", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("Individual/Origin/Geographic",               200, 200, 0, 0, 0, "Geographic origin",    "Geographic origin of individual; Belgium = individual\'s origin is Belgium, (France) = reported by laboratory in France, individual\'s origin not sure.", "Geographic origin of individual; Belgium = individual\'s origin is Belgium, (France) = reported by laboratory in France, individual\'s origin not sure.", "The geographic origin of the individual (country and/or region); Belgium = individual\'s origin is Belgium, (France) = reported by laboratory in France, individual\'s origin not sure.", "VARCHAR(50)", "Geographic origin|If mixed, please indicate origin of father and mother, if known.|text|30", "", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("Individual/Origin/Population",               202, 200, 0, 0, 0, "Population",           "", "Individual population.", "Additional information on the individual\'s population.", "VARCHAR(50)", "Individual population||text|30", "", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("Individual/Reference",                         2, 200, 1, 1, 0, "Reference",            "", "Reference to publication describing the individual/family.", "Reference to publication describing the individual/family, possibly giving more phenotypic details than listed in this database entry, including link to PubMed or other source, e.g. \"den Dunnen ASHG2003 P2346\". References in the &quot;Country:City&quot; format indicate that the variant was submitted directly to this database by the laboratory indicated.", "VARCHAR(200)", "Reference||text|50", "", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("Individual/Remarks",                         250, 200, 0, 1, 0, "Remarks",              "", "Remarks about the individual.", "Remarks about the individual.", "TEXT", "Remarks|Only provide data that do not belong in any other field.|textarea|50|3", "", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("Individual/Remarks_Non_Public",              251, 200, 0, 1, 0, "Remarks (non public)", "", "Non-public remarks about the individual.", "Non-public remarks about the individual.", "TEXT", "Remarks (non public)||textarea|50|3", "", "", 0, 0, 0, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("Phenotype/Additional",                       250, 200, 0, 1, 0, "Phenotype details",    "Additional information on the phenotype of the individual.", "Additional information on the phenotype of the individual.", "Additional information on the phenotype of the individual.", "TEXT", "Additional phenotype details||textarea|40|4", "", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                // If you ever change this column, change the install script accordingly.
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("Phenotype/Age",                                2, 100, 0, 0, 0, "Age examined",         "Type 35y for 35 years, 04y08m for 4 years and 8 months, 18y? for around 18 years, >54y for older than 54, ? for unknown.", "The age at which the individual was examined, if known. 04y08m = 4 years and 8 months.", "The age at which the individual was examined, if known.\r\n<UL style=\"margin-top:0px;\">\r\n  <LI>35y = 35 years</LI>\r\n  <LI>04y08m = 4 years and 8 months</LI>\r\n  <LI>18y? = around 18 years</LI>\r\n  <LI>&gt;54y = older than 54</LI>\r\n  <LI>? = unknown</LI>\r\n</UL>", "VARCHAR(12)", "Age at examination|The age at which the individual was examined, if known. Numbers lower than 10 should be prefixed by a zero and the field should always begin with years, to facilitate sorting on this column.|text|10", "", "/^([<>]?\\\\d{2,3}y(\\\\d{2}m(\\\\d{2}d)?)?)?\\\\??$/", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("Phenotype/Date",                               1,  80, 0, 0, 0, "Date",                 "Format: YYYY-MM-DD.", "Date the phenotype was observed.", "Date the phenotype was observed, in YYYY-MM-DD format.", "DATE", "Date||text|10", "", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("Phenotype/Inheritance",                      254, 200, 1, 1, 0, "Inheritance",          "Indicates the inheritance of the phenotype in the family; unknown, familial (autosomal/X-linked, dominant/ recessive), paternal (Y-linked), maternal (mitochondrial) or isolated (sporadic)", "Indicates the inheritance of the phenotype in the family; unknown, familial (autosomal/X-linked, dominant/ recessive), paternal (Y-linked), maternal (mitochondrial) or isolated (sporadic)", "Indicates the inheritance of the phenotype in the family; unknown, familial (autosomal/X-linked, dominant/ recessive), paternal (Y-linked), maternal (mitochondrial) or isolated (sporadic)", "VARCHAR(50)", "Inheritance||select|1|--Not specified--|false|false", "Unknown\r\nFamilial\r\nFamilial, autosomal dominant\r\nFamilial, autosomal recessive\r\nFamilial, X-linked dominant\r\nFamilial, X-linked dominant, male sparing\r\nFamilial, X-linked recessive\r\nPaternal, Y-linked\r\nMaternal, mitochondrial\r\nIsolated (sporadic)", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                // If you ever change this column, change the install script accordingly.
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("Phenotype/Length",                           200, 100, 0, 0, 0, "Length",               "", "Length of the individual, in cm.", "Length of the individual, in centimeters (cm).", "SMALLINT(3) UNSIGNED", "Length of individual (cm)|Length of individual, in centimeters.|text|3", "", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("Screening/Date",                               1,  80, 0, 0, 0, "Date",                 "Format: YYYY-MM-DD.", "Date the detection technique was performed.", "Date the detection technique was performed, in YYYY-MM-DD format.", "DATE", "Date||text|10", "", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("Screening/Technique",                          3, 200, 1, 1, 1, "Technique",            "Technique(s) used to identify the sequence variant; select multiple when more were used. For SEQ-NG, please indicate in the variant\'s remarks field the number of reads showing the variant (e.g. 47/96 reads, 123/123 reads), and create a second screening if you confirmed a variant using another method (e.g. SEQ).", "Technique(s) used to identify the sequence variant.", "Technique(s) used to identify the sequence variant.", "TEXT", "Technique(s) used||select|5|false|true|false", "? = Unknown\r\narrayCGH = array for Comparative Genomic Hybridisation\r\narraySEQ = array for resequencing\r\narraySNP = array for SNP typing\r\narrayCNV = array for Copy Number Variation (SNP and CNV probes)\r\nBESS = Base Excision Sequence Scanning\r\nCMC = Chemical Mismatch Cleavage\r\nCSCE = Conformation Sensitive Capillary Electrophoresis\r\nDGGE = Denaturing-Gradient Gel-Electrophoresis\r\nDHPLC = Denaturing High-Performance Liquid Chromatography\r\nDOVAM = Detection Of Virtually All Mutations (SSCA variant)\r\nddF = dideoxy Fingerprinting\r\nDSCA = Double-Strand DNA Conformation Analysis\r\nEMC = Enzymatic Mismatch Cleavage\r\nHD = HeteroDuplex analysis\r\nMCA = high-resolution Melting Curve Analysis (hrMCA)\r\nIHC = Immuno-Histo-Chemistry\r\nMAPH = Multiplex Amplifiable Probe Hybridisation\r\nMLPA = Multiplex Ligation-dependent Probe Amplification\r\nSEQ-NG = Next-Generation Sequencing\r\nSEQ-NG-H = Next-Generation Sequencing - Helicos\r\nSEQ-NG-I = Next-Generation Sequencing - Illumina/Solexa\r\nSEQ-NG-R = Next-Generation Sequencing - Roche/454\r\nSEQ-NG-S = Next-Generation Sequencing - SOLiD\r\nNorthern = Northern blotting\r\nPCR = Polymerase Chain Reaction\r\nPCRdig = PCR + restriction enzyme digestion\r\nPCRlr = PCR, long-range\r\nPCRm = PCR, multiplex\r\nPCRq = PCR, quantitative\r\nPAGE = Poly-Acrylamide Gel-Electrophoresis\r\nPTT = Protein Truncation Test\r\nPFGE = Pulsed-Field Gel-Electrophoresis (+Southern)\r\nRT-PCR = Reverse Transcription and PCR\r\nSEQ = SEQuencing\r\nSBE = Single Base Extension\r\nSSCA = Single-Strand DNA Conformation polymorphism Analysis (SSCP)\r\nSSCAf = SSCA, fluorescent (SSCP)\r\nSouthern = Southern blotting\r\nTaqMan = TaqMan assay\r\nWestern = Western Blotting", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("Screening/Template",                           2,  80, 1, 1, 1, "Template",             "", "Template(s) used to detect the sequence variant; DNA = genomic DNA, RNA = RNA (cDNA).", "Template(s) used to detect the sequence variant; DNA = genomic DNA, RNA = RNA (cDNA).", "TEXT", "Detection template||select|3|false|true|false", "DNA\r\nRNA = RNA (cDNA)\r\nProtein\r\n? = unknown", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("Screening/Tissue",                             4, 100, 0, 0, 1, "Tissue",               "", "Tissue type used for the detection of sequence variants.", "Tissue type used for the detection of sequence variants.", "VARCHAR(25)", "Tissue||text|20", "", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("VariantOnGenome/Conservation_score/GERP",      4, 100, 0, 0, 0, "GERP conservation",    "", "Conservation score as calculated by GERP.", "The Conservation score as calculated by GERP.", "DECIMAL(5,3)", "GERP conservation score||text|6", "", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("VariantOnGenome/DBID",                         7, 120, 1, 1, 1, "DB-ID",                "NOTE: This field will be predicted and filled in by LOVD, if left empty.", "Database ID of variant starting with the HGNC gene symbol, followed by an underscore (_) and a six digit number (e.g. DMD_012345). _000000 is used for variants where DNA was not analysed (change predicted from RNA analysis), variants seen in animal models or variants not seen in humans but functionally tested in vitro.", "Database ID of variant, grouping multiple observations of the same variant together, starting with the HGNC gene symbol, followed by an underscore (_) and a six digit number (e.g. DMD_012345). _000000 is used for variants where DNA was not analysed (change predicted from RNA analysis), variants seen in animal models or variants not seen in humans but functionally tested in vitro.", "VARCHAR(50)", "ID|This ID is used to group multiple observations of the same variant together. This field will be predicted and filled in by LOVD when left empty. The ID starts with the HGNC gene symbol of the transcript most influenced by the variant or otherwise the closest gene, followed by an underscore (_) and a six digit number (e.g. DMD_012345). _000000 is used for variants where DNA was not analysed (change predicted from RNA analysis), variants seen in animal models or variants not seen in humans but functionally tested in vitro.|text|20", "", "/^(chr(\\\\d{1,2}|[XYM])|(C(\\\\d{1,2}|[XYM])orf\\\\d+-|[A-Z][A-Z0-9]+-)?(C(\\\\d{1,2}|[XYM])orf\\\\d+|[A-Z][A-Z0-9]+))_\\\\d{6}$/", 1, 0, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("VariantOnGenome/dbSNP",                        8, 120, 0, 0, 0, "dbSNP ID",             "", "The dbSNP ID.", "The dbSNP ID.", "VARCHAR(15)", "dbSNP ID|If available, please fill in the dbSNP ID, such as rs12345678.|text|10", "", "/^[rs]s\\\\d+$/", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("VariantOnGenome/DNA",                          2, 200, 1, 1, 1, "DNA change (genomic)", "", "Description of variant at DNA level, based on the genomic DNA reference sequence (following HGVS recommendations).", "Description of variant at DNA level, based on the genomic DNA reference sequence (following HGVS recommendations).<BR>\r\n<UL style=\"margin-top : 0px;\">\r\n  <LI>g.12345678C>T</LI>\r\n  <LI>g.12345678_12345890del</LI>\r\n  <LI>g.12345678_12345890dup</LI>\r\n</UL>", "VARCHAR(100)", "Genomic DNA change (HGVS format)||text|30", "", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("VariantOnGenome/Frequency",                    9,  90, 0, 1, 0, "Frequency",            "", "Frequency in which the variant was found; e.g 5/76 chomosomes (in 5 of 760 chromosomes tested), 1/33 patients (in 1 of 33 patients analysed in study), 0.05 controls (in 5% of control cases tested).", "Frequency in which the variant was found; e.g 5/76 chomosomes (in 5 of 760 chromosomes tested), 1/33 patients (in 1 of 33 patients analysed in study), 0.05 controls (in 5% of control cases tested).", "VARCHAR(15)", "Frequency|Frequency in which the variant was found; e.g 5/76 chomosomes (in 5 of 760 chromosomes tested), 1/33 patients (in 1 of 33 patients analysed in study), 0.05 controls (in 5% of control cases tested). Preferred format is 3/75, not 0.04.|text|10", "", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("VariantOnGenome/Genetic_origin",              11, 200, 0, 0, 1, "Genetic origin",       "", "Origin of variant; unknown, germline (inherited), somatic, de novo, from parental disomy (maternal or paternal) or in vitro (cloned) when tested for functional consequences.", "Origin of variant; unknown, germline (inherited), somatic, de novo, from parental disomy (maternal or paternal) or in vitro (cloned) when tested for functional consequences.", "VARCHAR(100)", "Genetic origin||select|1|--Not specified--|false|false", "Unknown\r\nGermline (inherited)\r\nSomatic\r\nDe novo\r\nUniparental disomy\r\nUniparental disomy, maternal allele\r\nUniparental disomy, paternal allele\r\nIn vitro (cloned)", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("VariantOnGenome/Published_as",                 3, 200, 0, 0, 0, "Published as",         "Variant as originally reported (e.g. 521delT); provide only when different from \"DNA change\".", "Variant as originally reported (e.g. 521delT); listed only when different from \"DNA change\". Variants seen in animal models, tested in vitro, predicted from RNA analysis, etc. are described between brackets like c.(456C>G).", "Variant as originally reported (e.g. 521delT); listed only when different from \"DNA change\". Variants seen in animal models, tested in vitro, predicted from RNA analysis, etc. are described between brackets like c.(456C>G).", "VARCHAR(100)", "Published as|Variants seen in animal models, tested in vitro, predicted from RNA analysis, etc. are described between brackets like c.(456C>G).|text|30", "", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("VariantOnGenome/Reference",                    6, 200, 1, 1, 0, "Reference",            "", "Reference to publication describing the variant.", "Reference to publication describing the variant, including links to OMIM (when available), PubMed or or other source, e.g. \"den Dunnen ASHG2003 P2346\".", "VARCHAR(255)", "Reference||text|50", "", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                // Add remarks non public? Add remarks column(s) to VariantOnTranscript???
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("VariantOnGenome/Remarks",                     10, 200, 0, 0, 0, "Variant remarks",      "Remarks regarding the variant described, e.g. germline mosaicism in mother, 345 kb deletion, muscle RNA analysed, not in 200 control chromosomes tested, on founder haplotype, etc.", "Remarks regarding the variant described.", "Remarks regarding the variant described, e.g. germline mosaicism in mother, 345 kb deletion, muscle RNA analysed, not in 200 control chromosomes tested, on founder haplotype, etc.", "TEXT", "Remarks||textarea|50|3", "", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("VariantOnGenome/Restriction_site",             5,  75, 0, 1, 0, "Re-site",              "", "Restriction enzyme recognition site created (+) or destroyed (-).", "Restriction enzyme recognition site created (+) or destroyed (-); e.g. BglII+, BamHI-.", "VARCHAR(25)", "Re-site|Restriction enzyme recognition site created (+) or destroyed (-); e.g. BglII+, BamHI-|text|10", "", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("VariantOnGenome/Segregation",                 12,  40, 0, 0, 0, "Segregation",          "Indicates whether the variant segregates with the disease (yes), does not segregate with the disease (no) or segregation is unknown (?)", "Indicates whether the variant segregates with the disease (yes), does not segregate with the disease (no) or segregation is unknown (?)", "Indicates whether the variant segregates with the disease (yes), does not segregate with the disease (no) or segregation is unknown (?)", "VARCHAR(100)", "Segregation||select|1|--Not specified--|false|false", "? = Unknown\r\nyes = Segregates with phenotype\r\nno = Does not segregate with phenotype", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                // FIXME; link this one to an ontology?
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("VariantOnGenome/Type",                         1, 200, 0, 0, 1, "Type",                 "", "Type of variant at DNA level.", "Type of variant at DNA level; note that the variant type can also be derived from the variant description (for all levels).", "VARCHAR(100)", "Type of variant (DNA level)|Type of variant at DNA level; note that the variant type can also be derived from the variant description (for all levels).|select|1|true|false|false", "Substitution\r\nDeletion\r\nDuplication\r\nInsertion\r\nInversion\r\nInsertion/Deletion\r\nTranslocation\r\nOther/Complex", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("VariantOnTranscript/Distance_to_splice_site", 10, 150, 0, 0, 0, "Splice distance",      "", "The distance to the nearest splice site.", "The distance to the nearest splice site.", "MEDIUMINT(8) UNSIGNED", "Distance to splice site||text|8", "", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("VariantOnTranscript/DNA",                      3, 200, 1, 1, 1, "DNA change (cDNA)",    "", "Description of variant at DNA level, based on a coding DNA reference sequence (following HGVS recommendations).", "Description of variant at DNA level, based on a coding DNA reference sequence (following HGVS recommendations); e.g. c.123C>T, c.123_145del, c.123_126dup.", "VARCHAR(100)", "DNA change (HGVS format)|Description of variant at DNA level, based on a coding DNA reference sequence (following HGVS recommendations); e.g. c.123C>T, c.123_145del, c.123_126dup.|text|30", "", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("VariantOnTranscript/Exon",                     2,  50, 0, 1, 1, "Exon",                 "", "Number of exon/intron containing the variant.", "Number of exon/intron containing variant; 2 = exon 2, 12i = intron 12, 2i_7i = exons 3 to 7, 8i_9 = border intron 8/exon 9.", "VARCHAR(7)", "Exon|Format: 2 = exon 2, 12i = intron 12, 2i_7i = exons 3 to 7, 8i_9 = border intron 8/exon 9.|text|7", "", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("VariantOnTranscript/GVS/Function",             9, 200, 0, 0, 0, "GVS function",         "", "Functional annotation of this position from the Genome Variation Server.", "The functional annotation of this position from the Genome Variation Server.", "VARCHAR(100)", "GVS function||select|1|true|false|false", "intergenic\r\nnear-gene-5\r\nutr-5\r\ncoding\r\ncoding-near-splice\r\ncodingComplex\r\ncodingComplex-near-splice\r\nframeshift\r\nframeshift-near-splice\r\nsplice-5\r\nintron\r\nsplice-3\r\nutr-3\r\nnear-gene-3", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("VariantOnTranscript/Location",                 1, 200, 0, 0, 1, "Location",             "", "Location of variant at DNA level.", "Location of variant at DNA level; note that the variant location can also be derived from the variant description.", "VARCHAR(100)", "Location of variant|The variant location can also be derived from the variant description|select|1|true|false|false", "5\' gene flanking\r\n5\' UTR\r\nExon\r\nIntron\r\n3\' UTR\r\n3\' gene flanking", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("VariantOnTranscript/PolyPhen",                 8, 200, 0, 0, 0, "PolyPhen prediction",  "", "Effect of variant, predicted by PolyPhen.", "Effect of variant, predicted by PolyPhen.", "VARCHAR(100)", "PolyPhen prediction|Effect of variant, predicted by PolyPhen|select|1|true|false|false", "benign = Benign\r\npossiblyDamaging = Possibly damaging\r\nprobablyDamaging = Probably damaging\r\nnoPrediction = No prediction", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("VariantOnTranscript/Position",                 5, 100, 0, 0, 0, "Position",             "", "Position of variant in coding DNA sequence.", "Position of variant in coding DNA sequence; note that coding DNA position can also be derived from the variant description.", "MEDIUMINT(5)", "cDNA position|Note that cDNA position can be derived from the variant description.|text|5", "", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("VariantOnTranscript/Protein",                  7, 200, 1, 1, 1, "Protein",              "", "Description of variant at protein level (following HGVS recommendations).", "Description of variant at protein level (following HGVS recommendations).<BR>\r\n<UL style=\"margin-top : 0px;\">\r\n  <LI>p.(Arg345Pro) = change predicted from DNA (RNA not analysed)</LI>\r\n  <LI>p.Arg345Pro = change derived from RNA analysis</LI>\r\n  <LI>p.? = unknown effect</LI>\r\n  <LI>p.0? = probably no protein produced</LI>\r\n</UL>", "VARCHAR(100)", "Protein change (HGVS format)|Description of variant at protein level (following HGVS recommendations); e.g. p.(Arg345Pro) = change predicted from DNA (RNA not analysed), p.Arg345Pro = change derived from RNA analysis, p.0 (no protein produced), p.? (unknown effect).|text|30", "", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("VariantOnTranscript/Published_as",             4, 200, 0, 0, 0, "Published as",         "Variant as originally reported (e.g. 521delT); provide only when different from \"DNA change\".", "Variant as originally reported (e.g. 521delT); listed only when different from \"DNA change\". Variants seen in animal models, tested in vitro, predicted from RNA analysis, etc. are described between brackets like c.(456C>G).", "Variant as originally reported (e.g. 521delT); listed only when different from \"DNA change\". Variants seen in animal models, tested in vitro, predicted from RNA analysis, etc. are described between brackets like c.(456C>G).", "VARCHAR(100)", "Published as|Variants seen in animal models, tested in vitro, predicted from RNA analysis, etc. are described between brackets like c.(456C>G).|text|30", "", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
                'INSERT INTO ' . TABLE_COLS . ' VALUES ("VariantOnTranscript/RNA",                      6, 200, 1, 1, 1, "RNA change",           "", "Description of variant at RNA level (following HGVS recommendations).", "Description of variant at RNA level (following HGVS recommendations).<BR>\r\n<UL style=\"margin-top : 0px;\">\r\n  <LI>r.123c>u</LI>\r\n  <LI>r.? = unknown</LI>\r\n  <LI>r.(?) = RNA not analysed but probably transcribed copy of DNA variant</LI>\r\n  <LI>r.spl? = RNA not analysed but variant probably affects splicing</LI>\r\n  <LI>r.(spl?) = RNA not analysed but variant may affect splicing</LI>\r\n  <LI>r.0? = change expected to abolish transcription</LI>\r\n</UL>", "VARCHAR(100)", "RNA change (HGVS format)|Description of variant at RNA level (following HGVS recommendations); e.g. r.123c>u, r.? = unknown, r.(?) = RNA not analysed but probably transcribed copy of DNA variant, r.spl? = RNA not analysed but variant probably affects splicing, r.(spl?) = RNA not analysed but variant may affect splicing.|text|30", "", "", 1, 1, 1, 0, NOW(), NULL, NULL)',
              );
?>
